# Laravel Project Setup Guide

This guide will help you download, install, and run the Laravel project from GitHub.

## **Clone the Repository**

First, clone the repository from GitHub using the following command:

```sh
git clone https://github.com/shruti-rawal/starter-kit.git
```

## **Navigate to the Project Directory**

Change to the project directory:

```sh
cd C:\Users\ASUS\Downloads\starter-kit-main
```

## **Install Dependencies**

Install the PHP dependencies using Composer:

```sh
composer install
```

Next, install the JavaScript dependencies:

```sh
npm install
```

## **Build Frontend Assets**

Compile the frontend assets using Vite:

```sh
npm run build
```

## **Set Up the Environment File**

Copy the `.env.example` file and create a new `.env` file:

```sh
cp .env.example .env
```

Generate the application key:

```sh
php artisan key:generate
```

## **Run the Application**

Start the Laravel development server:

```sh
php artisan serve
```

Your Laravel project should now be running successfully! 🎉
