<?php

namespace App\Http\Controllers\authentications;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\DSpaceApiService;


class AuthenticationController extends Controller
{

    public function index(Request $request, DSpaceApiService $apiService)
    {
        if (session()->has('api_token')) {
            return redirect()->route('dashboard');
        }

        if ($request->isMethod('get')) {
            $pageConfigs = ['myLayout' => 'blank'];
            return view('content.authentications.auth-login-basic', ['pageConfigs' => $pageConfigs]);
        }

        if ($request->isMethod('post')) {
            try {
                $result = $apiService->login(
                    $request->input('email-username'),
                    $request->input('password')
                );

                if ($result['auth_token']) {
                    // session([
                    //     'api_token' => $result['auth_token'],
                    //     'xsrf-token' => $result['xsrf_token'],
                    //     'email' => $request->input('email-username')
                    // ]);
                    session([
                        'api_token'     => $result['auth_token'],
                        'xsrf-token'    => $result['xsrf_token'],
                        'email'         => $request->input('email-username'),
                        'encrypted_password' => encrypt($request->input('password')),
                        'dspace_expires_at' => now()->addMinutes(15),
                    ]);



                    return redirect()->route('dashboard')->with('success', 'Login Successfully');
                }

                return back()->withErrors(['Unauthorized' => 'Please enter valid credentials']);
            } catch (\GuzzleHttp\Exception\ClientException $e) {
                return back()->withErrors(['Unauthorized' => 'Invalid credentials: ' . $e->getResponse()->getBody()->getContents()]);
            } catch (\Exception $e) {
                return back()->withErrors(['error' => 'An error occurred: ' . $e->getMessage()]);
            }
        }
    }

    public function logout()
    {
        session()->flush(); // Clear all session data
        return redirect()->route('auth-login-basic')->with('success', 'Logout Successfully'); // Redirect to the named route
    }
}
