<?php

namespace App\Http\Controllers\pages;


use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use phpseclib3\Net\SSH2;

class Community2CollectionController extends Controller
{

    private $host;
    private $port;
    private $username;
    private $password;
    protected $title;

    // comstructor
    public function __construct()
    {
        $this->host = config('services.putty.host'); // Load from .env via config
        $this->port = config('services.putty.port');
        $this->username = config('services.putty.username');
        $this->password = config('services.putty.password');
        $this->title = DB::table('metadatafieldregistry')
            ->where('element', 'title')
            ->whereNull('qualifier')
            ->where('metadata_schema_id', 1)
            ->value('metadata_field_id');
    }

    // index
    public function index(Request $request)
    {
        $data = DB::select("
            SELECT text_value, dspace_object_id 
            FROM metadatavalue 
            WHERE dspace_object_id IN (
                SELECT uuid FROM public.collection
            ) 
            AND metadata_field_id = (
                SELECT metadata_field_id FROM public.metadatafieldregistry 
                WHERE element = 'title' 
                AND metadata_schema_id = 1 
                AND qualifier IS NULL
            )
        ");

        // Dusri Query (community_id ke basis pe filter)
        $communityData = DB::table('public.metadatavalue as md')
            ->join('community as c', 'md.dspace_object_id', '=', 'c.uuid')
            ->select('md.text_value', 'md.dspace_object_id')
            ->where('md.metadata_field_id', $this->title)
            ->get();

        return view('content.pages.collection2community', compact('data', 'communityData'));
    }

    // A function which will update collection from one community to other
    public function store(Request $request)
    {
        try {
            // Retrieve input data
            $box2Data = $request->input('box2Data');
            $box4Data = $request->input('box4Data');

            // Extracting dspace_object_id
            $box2Ids = array_column($box2Data, 'dspace_object_id');
            $box4Ids = array_column($box4Data, 'dspace_object_id');

            // 🟢 Update Query
            $updated = DB::table('community2collection')
                ->whereIn('collection_id', $box4Ids)
                ->update(['community_id' => implode(',', $box2Ids)]);

            if (!$updated) {
                return response()->json(['success' => false, 'message' => 'No records updated.'], 400);
            }

            // 🔹 SSH Configuration
            $host = $this->host;
            $port = $this->port;
            $username = $this->username;
            $password = $this->password;


            // 🔹 Command to run
            $command = 'cd /dspace/bin && echo ' . escapeshellarg($password) . ' | sudo -S ./dspace index-discovery -f';

            // Attempt SSH execution using phpseclib3
            Log::info('Attempting SSH connection to run index-discovery');
            $ssh = new SSH2($host, $port);

            if (!$ssh->login($username, $password)) {
                throw new \Exception("SSH login failed.");
            }

            $output = $ssh->exec($command);

            // Log and return response
            Log::info('SSH Command Output', ['output' => $output]);

            session()->flash('success', 'Edit Collection to Community successfully!');
            return response()->json([
                'success' => true,
                'message' => 'Edit Collection to Community executed!',
                'ssh_output' => $output
            ], 200);
        } catch (\Exception $e) {
            Log::error('Error in updateData', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);

            session()->flash('error', 'Error: ' . $e->getMessage());
            return response()->json([
                'success' => false,
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
