<?php

namespace App\Http\Controllers\pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class EditmetadataController extends Controller
{
    // index
    public function index()
    {
        $homeHeaderId = DB::table('public.metadatafieldregistry')
            ->where('element', 'cms')
            ->where('qualifier', 'home-header')
            ->value('metadata_field_id');

        $homeNewsId = DB::table('public.metadatafieldregistry')
            ->where('element', 'cms')
            ->where('qualifier', 'home-news')
            ->value('metadata_field_id');

        $footerId = DB::table('public.metadatafieldregistry')
            ->where('element', 'cms')
            ->where('qualifier', 'footer')
            ->value('metadata_field_id');

        return view('content.pages.editmetadata', [
            'homeHeaderId' => $homeHeaderId,
            'homeNewsId' => $homeNewsId,
            'footerId' => $footerId,
        ]);
    }

    // getMetadata for getting data according to id
    public function getMetadata($metadataFieldId)
    {
        // Get existing metadata
        $metadata = DB::table('metadatavalue')
            ->where('metadata_field_id', $metadataFieldId)
            ->where('text_lang', 'en') //  Ensure correct language is fetched
            ->select('text_value') //  Only fetch text_value
            // ->value('text_value'); // Sirf text_value return karega
            ->first();

        return response()->json([
            'text_value' => $metadata->text_value ?? '' //  Return text_value or empty string
        ]);
    }

    // saveMetadata
    public function saveMetadata(Request $request)
    {
        $metadataFieldId = $request->input('metadata_field_id');
        $textValue = $request->input('text_value');

        $allowedIds = DB::table('metadatavalue')
            ->distinct()
            ->pluck('metadata_field_id')
            ->toArray();

        if (!in_array($metadataFieldId, $allowedIds, false)) {
            return response()->json([
                'status' => 'error',
                'message' => 'Invalid metadata_field_id! Operation not allowed.'
            ], 400);
        }

        // Pehle existing metadata check karna
        $existingMetadata = DB::table('metadatavalue')
            ->where('metadata_field_id', $metadataFieldId)
            ->first();

        if ($existingMetadata) {
            // Agar data exist karta hai to update hoga
            DB::table('metadatavalue')
                ->where('metadata_field_id', $metadataFieldId)
                ->where('text_lang', 'en')
                ->update([
                    'text_value' => $textValue
                ]);

            DB::table('metadatavalue')
                ->where('metadata_field_id', $metadataFieldId)
                ->where('text_lang', '!=', 'en')
                ->update([
                    'text_value' => ''
                ]);

            session()->flash('success', 'Metadata successfully updated!');

            return response()->json([
                'status' => 'success',
                'message' => session('success')
            ]);
        } else {
            session()->flash('Error', 'Metadata not exists!');
            return response()->json([
                'status' => 'Error',
                'message' => session('Error')
            ]);
        }
    }
}
