<?php

namespace App\Http\Controllers\pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FacultyProfileController extends Controller
{
    protected $title;
    protected $scopudId;
    protected $googleScholarId;
    protected $researcherId;
    protected $orchidId;
    protected $emailId;
    protected $affilationId;
    protected $scopusCitationId;
    protected $unpaywallId;
    protected $typeId;

    public function __construct()
    {
        $this->title = DB::table('metadatafieldregistry')
            ->where('element', 'title')
            ->whereNull('qualifier')
            ->where('metadata_schema_id', 1)
            ->value('metadata_field_id');

        $this->scopudId = DB::table('metadatafieldregistry')
            ->where('element', 'identifier')
            ->where('qualifier', 'scopus-author-id')
            ->value('metadata_field_id');

        $this->googleScholarId = DB::table('metadatafieldregistry')
            ->where('element', 'identifier')
            ->where('qualifier', 'gsid')
            ->value('metadata_field_id');

        $this->researcherId = DB::table('metadatafieldregistry')
            ->where('element', 'identifier')
            ->where('qualifier', 'rid')
            ->value('metadata_field_id');

        $this->orchidId = DB::table('metadatafieldregistry')
            ->where('element', 'identifier')
            ->where('qualifier', 'orcid')
            ->value('metadata_field_id');

        $this->emailId = DB::table('metadatafieldregistry')
            ->where('element', 'email')
            ->whereNull('qualifier')
            ->value('metadata_field_id');

        $this->affilationId = DB::table('metadatafieldregistry')
            ->where('element', 'affiliation')
            ->where('qualifier', 'name')
            ->value('metadata_field_id');

        $this->scopusCitationId = DB::table('metadatafieldregistry')
            ->where('element', 'identifier')
            ->where('qualifier', 'citedby')
            ->value('metadata_field_id');

        $this->unpaywallId = DB::table('metadatafieldregistry')
            ->where('element', 'venue')
            ->where('qualifier', 'unpaywall')
            ->value('metadata_field_id');

        $this->typeId = DB::table('metadatafieldregistry')
            ->where('element', 'entity')
            ->where('qualifier', 'type')
            ->value('metadata_field_id');
    }

    // index function
    public function index($profileid, Request $request)
    {

        // Define readable names mapped to metadata IDs
        $fields = [
            'title' => $this->title,
            'scopus_id' => $this->scopudId,
            'google_scholar_id' => $this->googleScholarId,
            'researcher_id' => $this->researcherId,
            'orchid_id' => $this->orchidId,
            'email' => $this->emailId,
            'affiliation' => $this->affilationId,
        ];
        $scopusCitationId = $this->scopusCitationId;
        $unpaywallId = $this->unpaywallId;
        // Fetch all matching metadata records
        $results = DB::table('metadatavalue')
            ->select('metadata_field_id', 'text_value', 'authority')
            ->where('dspace_object_id', $profileid)
            ->whereIn('metadata_field_id', array_values($fields))
            ->get();

        // Toatl Scopus citation
        $totalCitation = DB::table('metadatavalue')
            ->whereIn('dspace_object_id', function ($query) use ($profileid) {
                $query->select('dspace_object_id')
                    ->from('metadatavalue')
                    ->where('authority', $profileid);
            })
            ->where('metadata_field_id', $scopusCitationId)
            ->sum(DB::raw('CAST(text_value AS NUMERIC)'));

        $unpaywallCounts = DB::table('metadatavalue')
            ->select('text_value', DB::raw('COUNT(*) as total_count'))
            ->whereIn('dspace_object_id', function ($query) use ($profileid) {
                $query->select('dspace_object_id')
                    ->from('metadatavalue')
                    ->where('authority', $profileid);
            })
            ->where('metadata_field_id', $unpaywallId)
            ->whereIn('text_value', ['green', 'gold', 'close', 'bronze','hybrid'])
            ->groupBy('text_value')
            ->get()
            ->pluck('total_count', 'text_value')
            ->toArray();


        $meta = [];
        $meta['totalCitation'] = $totalCitation;
        $meta['unpaywallCounts'] = $unpaywallCounts;

        // Build a named array like:
        foreach ($fields as $key => $id) {
            $record = $results->firstWhere('metadata_field_id', $id);
            if ($record) {
                $meta[$key] = [
                    'value' => $record->text_value,
                    'authority' => $record->authority,
                ];
            } else {
                $meta[$key] = [
                    'value' => null,
                    'authority' => null,
                ];
            }
        }
        return view('content.pages.facultyprofile', compact('profileid', 'meta'));
    }


    public function getPublications($uuid, Request $request)
    {
        $typeId = $this->typeId;
        // 1️⃣ Get publication IDs linked to this profile
        $publicationIds = DB::table('metadatavalue')
            ->whereIn('dspace_object_id', function ($query) use ($uuid) {
                $query->select('dspace_object_id')
                    ->from('metadatavalue')
                    ->where('authority', $uuid);
            })
            ->where('metadata_field_id', $typeId)
            ->where('text_value', 'Publication')
            ->groupBy('dspace_object_id')
            ->pluck('dspace_object_id')
            ->toArray();

        // 2️⃣ Load publication JSON data
        $filePath = storage_path('app/json/publicationlist.json');
        if (!file_exists($filePath)) {
            return response()->json(['data' => []]);
        }

        $fileContent = file_get_contents($filePath);
        $publicationsRaw = json_decode($fileContent, true);
        $publications = [];

        foreach ($publicationsRaw as $publication) {
            if (in_array($publication['dspace_object_id'], $publicationIds)) {
                $metadataArray = json_decode($publication['metadata_details'], true);

                $publications[] = [
                    'uuid' => $publication['dspace_object_id'],
                    'title' => $this->getMetadataValue($metadataArray, 'title'),
                    'authors' => $this->getMetadataValue($metadataArray, 'authors'),
                    'journal' => $this->getMetadataValue($metadataArray, 'journal'),
                    'publication_type' => $this->getMetadataValue($metadataArray, 'publication_type'),
                    'date_issued' => $this->getMetadataValue($metadataArray, 'date_issued'),
                    'doi' => $this->getMetadataValue($metadataArray, 'doi'),
                    'scopus_citation' => $this->getMetadataValue($metadataArray, 'scopus_citation') ?: 0,
                    'crossref_citation' => $this->getMetadataValue($metadataArray, 'crossref_citation') ?: 0,
                ];
            }
        }
        return response()->json(['data' => array_values($publications)]);
    }

    // Helper function
    private function getMetadataValue($metadataArray, $field)
    {
        if (!is_array($metadataArray)) return null;

        foreach ($metadataArray as $meta) {
            if (
                isset($meta['field_name'], $meta['text_value']) &&
                strtolower(trim($meta['field_name'])) === strtolower($field)
            ) {
                return $meta['text_value'];
            }
        }

        return null;
    }

}
