<?php

namespace App\Http\Controllers\pages;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;


class HomePage extends Controller
{
  private $jsonPath;
  private $defaults = [
    'totalPublication' => 0,
    'totalPatent' => 0,
    'totalPerson' => 0,
    'totalCommunities' => 0,
    'totalCollections' => 0,
    'totalEPerson' => 0,
    'totalProcess' => 0,
    'totalcrossRef' => 0,
    'totalScopus' => 0,
    'open' => 0,
    'close' => 0,
    'bronze' => 0,
    'gold' => 0,
  ];

  public function __construct()
  {
    $this->jsonPath = storage_path('app/json/totalcount.json');
  }

  public function index()
  {
    if (!session()->has('api_token')) {
      return redirect()->route('auth-login-basic');
    }

    // Check if the file exists
    if (file_exists($this->jsonPath)) {
      // Read the file contents
      $fileContent = file_get_contents($this->jsonPath);
      $data = json_decode($fileContent, true);

      // If decoding fails or data is null, use default values
      if ($data === null) {
        $data = $this->defaults;
      }
    } else {
      // Default empty data if the file does not exist
      $data = $this->defaults;
    }
    return view('content.pages.pages-home', compact('data'));
  }

  //Funcation for total conts on screen
  public function totalCount()
  {
    if (!session()->has('api_token')) {
      return redirect()->route('auth-login-basic');
    }
    $entityType = DB::table('metadatafieldregistry')
      ->where('element', 'entity')
      ->where('qualifier', 'type')
      ->value('metadata_field_id');
    $totalPublication = DB::table('item as i')
      ->join('metadatavalue as mv', 'mv.dspace_object_id', '=', 'i.uuid')
      ->where('mv.metadata_field_id', $entityType)
      ->where('mv.text_value', 'Publication')
      ->where('i.in_archive', true)
      ->where('i.withdrawn', false)
      ->distinct('i.uuid')
      ->count('i.uuid');

    $totalPerson =  DB::table('collection2item as c2i')
      ->join('metadatavalue as mv', 'c2i.collection_id', '=', 'mv.dspace_object_id')
      ->join('public.collection as col', 'mv.dspace_object_id', '=', 'col.uuid')
      ->where('mv.metadata_field_id', $entityType)
      ->where('mv.text_value', 'Person')
      ->count();

    $totalPatent = DB::table('item as i')
      ->join('metadatavalue as mv', 'mv.dspace_object_id', '=', 'i.uuid')
      ->where('mv.metadata_field_id', $entityType)
      ->where('mv.text_value', 'Patent')
      ->where('i.in_archive', true)
      ->where('i.withdrawn', false)
      ->distinct('i.uuid')
      ->count('i.uuid');
    $totalCommunities = DB::table('community')->count();
    $totalCollections = DB::table('collection')->count();
    $totalEPerson = DB::table('eperson')->count();
    $totalProcess = DB::table('process')
      ->whereNotNull('user_id')
      ->count();

    // Collect id of unpaywall
    $unpaywall = DB::table('metadatafieldregistry')
      ->where('element', 'venue')
      ->where('qualifier', 'unpaywall')
      ->value('metadata_field_id');

    // id of crossRef
    $crossref_citation = DB::table('metadatafieldregistry')
      ->where('element', 'identifier')
      ->where('qualifier', 'crossref_citation')
      ->value('metadata_field_id');


    $totalcrossRef = DB::table('public.metadatavalue')
      ->where('metadata_field_id', $crossref_citation)
      ->sum(DB::raw('CAST(text_value AS INTEGER)'));


    $totalScopus = DB::table('cris_metrics')
      ->where('metrictype', 'scopusCitation')
      ->sum('metriccount');

    // **New Query to Count Specific Values in metadatavalue**
    $valueCounts = DB::table('metadatavalue')
      ->where('metadata_field_id', $unpaywall)
      ->select('text_value', DB::raw('COUNT(*) as count'))
      ->groupBy('text_value')
      ->pluck('count', 'text_value');

    // Ensure all keys exist to avoid errors
    $metadataCounts = [
      'open' => $valueCounts->get('green', 0),
      'close' => $valueCounts->get('close', 0),
      'bronze' => $valueCounts->get('bronze', 0) + $valueCounts->get('hybrid', 0),
      'gold' => $valueCounts->get('gold', 0)
    ];

    // Merge new counts into data array
    $data = array_merge([
      'totalPublication' => $totalPublication,
      'totalPatent' => $totalPatent,
      'totalPerson' => $totalPerson,
      'totalCommunities' => $totalCommunities,
      'totalCollections' => $totalCollections,
      'totalEPerson' => $totalEPerson,
      'totalProcess' => $totalProcess,
      'totalcrossRef' => $totalcrossRef,
      'totalScopus' => $totalScopus,
    ], $metadataCounts);


    $directory = storage_path('app/json');

    if (!File::exists($directory)) {
      File::makeDirectory($directory, 0755, true);
    }
    // Save the JSON data
    if (File::put($this->jsonPath, json_encode($data, JSON_PRETTY_PRINT)) !== false) {
      session()->flash('success', 'Dashboard Data Updated Successfully!');
      return response()->json(['success' => true, 'message' => session('success')]);
    } else {
      // Return JSON file content
      session()->flash('error', 'Failed to Update Dashboard Data.');
      return response()->json(['success' => false, 'message' => session('error')]);
    }
  }
}
