<?php

namespace App\Http\Controllers\pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use phpseclib3\Net\SFTP;
use phpseclib3\Net\SSH2;

class ImportExportController extends Controller
{
    private $host;
    private $port;
    private $username;
    private $password;

    public function __construct()
    {
        $this->host = config('services.putty.host'); // Load from .env via config
        $this->port = config('services.putty.port');
        $this->username = config('services.putty.username');
        $this->password = config('services.putty.password');
    }


    // It will export CSV via command 
    public function exportMetadata(Request $request)
    {
        try {

            $id = $request->input('id');
            $token = $request->input('download_token');
            // Mark the token as "processing"
            Cache::put("download_$token", false, 300);

            $host = $this->host;
            $port = $this->port;
            $username = $this->username;
            $password = $this->password;

            // Define File Paths
            $fileName = "metadata_export_{$id}.csv";
            $remoteFilePath = "/tmp/{$fileName}";
            $localFilePath = storage_path("app/public/{$fileName}");

            // Run DSpace Export via SSH
            $ssh = new SSH2($host, $port);
            if (!$ssh->login($username, $password)) {
                throw new \Exception("SSH login failed.");
            }
            $command = "echo " . escapeshellarg($password) . " | sudo -S /dspace/bin/dspace metadata-export -f {$remoteFilePath} -i {$id}";
            $ssh->exec($command);

            // Download File via SFTP
            $sftp = new SFTP($host, $port);
            if (!$sftp->login($username, $password)) {
                throw new \Exception("SFTP login failed.");
            }

            if (!$sftp->get($remoteFilePath, $localFilePath)) {
                throw new \Exception("Failed to download CSV file.");
            }

            // Mark token as ready before returning download
            Cache::put("download_$token", true, 300);

            // Return file as download response with proper headers
            return response()->download($localFilePath, $fileName, [
                'Content-Type' => 'text/csv',
            ])->deleteFileAfterSend(true);
        } catch (\Exception $e) {
            Log::error('Error in SSH File Transfer: ' . $e->getMessage());
            Cache::put("download_{$token}", true, 300);
            return redirect()->back()->with('error', 'File transfer failed: ' . $e->getMessage());
        }
    }

    public function checkStatus($token)
    {
        $ready = Cache::get("download_$token", false);
        return response()->json(['ready' => $ready]);
    }
}
