<?php

namespace App\Http\Controllers\pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Services\DSpaceApiService;

class OrgUnitController extends Controller
{
    //index
    public function index($id,$communityId)
    {    
            $title = DB::table('metadatafieldregistry')
                ->where('element', 'title')
                ->whereNull('qualifier')
                ->where('metadata_schema_id', 1)
                ->value('metadata_field_id');

            $data = DB::table('metadatavalue as mv')
                ->select('mv.text_value', 'mv.dspace_object_id')
                ->join('collection2item as c2i', 'mv.dspace_object_id', '=', 'c2i.item_id')
                ->where('c2i.collection_id', $id)
                ->where('mv.metadata_field_id', $title)
                ->get();

            $count = $data->count();

            $name = DB::table('metadatavalue')
                ->where('dspace_object_id', $id)
                ->where('metadata_field_id', $title)
                ->value('text_value'); // Fetches a single value

            // Pass the data and count to the view (also passing $id if needed)
            return view('content.pages.orgunit', compact('data', 'count', 'id', 'name','communityId'));
    }

    // Edit function
    public function editOrgUnit(Request $request)
    {
            // Get ID and new name from the request
            $id = $request->input('id');
            $name = $request->input('orgunit_name');

            $title = DB::table('metadatafieldregistry')
                ->where('element', 'title')
                ->whereNull('qualifier')
                ->where('metadata_schema_id', 1)
                ->value('metadata_field_id');

            // Update the database
            DB::table('metadatavalue')
                ->where('dspace_object_id', $id)
                ->where('metadata_field_id', $title)
                ->update(['text_value' => $name]);


            // Redirect back with success message
            return redirect()->back()->with('success', 'Organization updated successfully!');
    }
    // delete funcation
    public function delete($id,DSpaceApiService $apiService)
    {
        if (session()->has('api_token')) {
            $authorizationHeader = Session::get('api_token');

             $response = $apiService->delete('core/items/' . $id, $authorizationHeader);

            if ($response->getStatusCode() === 204) {
                return redirect()->back()->with('success', 'OrgUnit deleted successfully');
            } else {
                return redirect()->back()->with('error', 'Failed to delete item');
            }
        } else {
            return redirect()->route('auth-login-basic');
        }
    }
}
