<?php

namespace App\Http\Controllers\pages;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Request;
use Yajra\DataTables\Facades\DataTables;

class Patentcontroller extends Controller
{
    //
    protected $title;

    private function getTitleFieldId()
    {
        return DB::table('metadatafieldregistry')
            ->where('element', 'title')
            ->whereNull('qualifier')
            ->where('metadata_schema_id', 1)
            ->value('metadata_field_id');
    }
    public function index($id, $communityid)
    {
        $title = $this->getTitleFieldId();

        $totalPatent = DB::table('metadatavalue as mv')
            ->join('collection2item as c2i', 'c2i.item_id', '=', 'mv.dspace_object_id')
            ->where('mv.metadata_field_id', 7)
            ->where('mv.text_value', 'Patent')
            ->where('c2i.collection_id', $id)
            ->distinct('mv.dspace_object_id')
            ->count('mv.dspace_object_id');


        $name = DB::table('metadatavalue')
            ->where('dspace_object_id', $id)
            ->where('metadata_field_id', $title)
            ->value('text_value');


        return view('content.pages.patent', compact('communityid', 'name', 'totalPatent', 'id'));
    }
    public function getPatentData($collectionId)
    {

        $title = $this->getTitleFieldId();

        $dateIssue = DB::table('metadatafieldregistry')
            ->where('element', 'date')
            ->where('qualifier', 'issued')
            ->value('metadata_field_id');

        $authorId = DB::table('metadatafieldregistry')
            ->where('element', 'contributor')
            ->where('qualifier', 'author')
            ->value('metadata_field_id');

        $patentNo = DB::table('metadatafieldregistry')
            ->where('element', 'identifier')
            ->where('qualifier', 'patentno')
            ->value('metadata_field_id');

        $publisherId = DB::table('metadatafieldregistry as mr')
            ->join('metadataschemaregistry as ms', 'mr.metadata_schema_id', '=', 'ms.metadata_schema_id')
            ->where('mr.element', 'publisher')
            ->where('ms.short_id', 'dc')
            ->value('mr.metadata_field_id');

        $entityType = DB::table('metadatafieldregistry')
            ->where('element', 'entity')
            ->where('qualifier', 'type')
            ->value('metadata_field_id');


        $query = DB::table('metadatavalue as o')
            ->join('collection2item as c2i', 'c2i.item_id', '=', 'o.dspace_object_id')
            ->join('metadatavalue as e', function ($join) use ($title, $dateIssue, $publisherId, $patentNo, $authorId) {
                $join->on('e.dspace_object_id', '=', 'o.dspace_object_id')
                    ->whereIn('e.metadata_field_id', [$title, $dateIssue, $publisherId, $patentNo, $authorId]);
            })
            ->where('o.metadata_field_id', $entityType)
            ->where('o.text_value', 'Patent')
            ->where('c2i.collection_id', $collectionId)
            ->groupBy('o.dspace_object_id')
            ->select(
                'o.dspace_object_id',
                DB::raw("MAX(CASE WHEN e.metadata_field_id = {$title} THEN e.text_value END) AS title"),
                DB::raw("MAX(CASE WHEN e.metadata_field_id = {$dateIssue} THEN e.text_value END) AS dateIssue"),
                DB::raw("MAX(CASE WHEN e.metadata_field_id = {$publisherId} THEN e.text_value END) AS publisher"),
                DB::raw("MAX(CASE WHEN e.metadata_field_id = {$patentNo} THEN e.text_value END) AS patent"),
                DB::raw("STRING_AGG(CASE WHEN e.metadata_field_id = {$authorId} THEN e.text_value END, '|' ORDER BY e.text_value) AS author")
            );

        return DataTables::of($query)
            ->filter(function ($instance) use ($title, $dateIssue, $publisherId, $patentNo, $authorId) {

                if (request()->has('search') && request('search')['value'] != '') {

                    $search = strtolower(request('search')['value']);

                    $instance->having(function ($w) use ($search, $title, $dateIssue, $publisherId, $patentNo, $authorId) {

                        $w->orHavingRaw("LOWER(MAX(CASE WHEN e.metadata_field_id = {$title} THEN e.text_value END)) LIKE ?", ["%{$search}%"])
                            ->orHavingRaw("LOWER(MAX(CASE WHEN e.metadata_field_id = {$patentNo} THEN e.text_value END)) LIKE ?", ["%{$search}%"])
                            ->orHavingRaw("LOWER(MAX(CASE WHEN e.metadata_field_id = {$dateIssue} THEN e.text_value END)) LIKE ?", ["%{$search}%"])
                            ->orHavingRaw("LOWER(MAX(CASE WHEN e.metadata_field_id = {$publisherId} THEN e.text_value END)) LIKE ?", ["%{$search}%"])
                            ->orHavingRaw("LOWER(STRING_AGG(CASE WHEN e.metadata_field_id = {$authorId} THEN e.text_value END, '|' ORDER BY e.text_value)) LIKE ?", ["%{$search}%"]);
                    });
                }
            })
            ->make(true);
    }
}
