<?php

namespace App\Http\Controllers\pages;


use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Services\DSpaceApiService;


class PersonsController extends Controller
{

    protected $title;
    protected $email;
    protected $orcid;
    protected $gsid;
    protected $rid;
    protected $jobTitle;
    protected $affiliationName;
    protected $affiliationId;
    protected $gender;
    protected $entityType;
    protected $scopusAuthorId;

    // constructtor
    public function __construct()
    {
        $this->title = DB::table('metadatafieldregistry')
            ->where('element', 'title')
            ->whereNull('qualifier')
            ->where('metadata_schema_id', 1)
            ->value('metadata_field_id');
        $this->email =  DB::table('metadatafieldregistry')
            ->where('element', 'email')
            ->whereNull('qualifier')
            ->limit(1)
            ->value('metadata_field_id');
        $this->orcid = DB::table('metadatafieldregistry')
            ->where('element', 'identifier')
            ->where('qualifier', 'orcid')
            ->limit(1)
            ->value('metadata_field_id');
        $this->gsid = DB::table('metadatafieldregistry')
            ->where('element', 'identifier')
            ->where('qualifier', 'gsid')
            ->limit(1)
            ->value('metadata_field_id');
        $this->rid =  DB::table('metadatafieldregistry')
            ->where('element', 'identifier')
            ->where('qualifier', 'rid')
            ->limit(1)
            ->value('metadata_field_id');
        $this->jobTitle = DB::table('metadatafieldregistry')
            ->where('element', 'jobTitle')
            ->whereNull('qualifier')
            ->limit(1)
            ->value('metadata_field_id');
        $this->affiliationName = DB::table('metadatafieldregistry')
            ->where('element', 'affiliation')
            ->where('qualifier', 'name')
            ->limit(1)
            ->value('metadata_field_id');
        $this->affiliationId = DB::table('metadatafieldregistry')
            ->where('element', 'affiliation')
            ->where('qualifier', 'id')
            ->limit(1)
            ->value('metadata_field_id');
        $this->gender = DB::table('metadatafieldregistry')
            ->where('element', 'person')
            ->where('qualifier', 'gender')
            ->limit(1)
            ->value('metadata_field_id');
        $this->entityType = DB::table('metadatafieldregistry')
            ->where('element', 'entity')
            ->where('qualifier', 'type')
            ->limit(1)
            ->value('metadata_field_id');
        $this->scopusAuthorId = DB::table('metadatafieldregistry')
            ->where('element', 'identifier')
            ->where('qualifier', 'scopus-author-id')
            ->limit(1)
            ->value('metadata_field_id');
    }
    // index function for collection to Item
    public function index($id, $communityid)
    {
        $title = $this->title;

        $affiliationame = $this->affiliationName;

        $email = $this->email;

        $scopusauthorid = $this->scopusAuthorId;

        $entitytype = $this->entityType;

        $gender = $this->gender;

        $affiliationid = $this->affiliationId;

        $jobtitle = $this->jobTitle;

        $gsid = $this->gsid;

        $orcid = $this->orcid;

        $rid = $this->rid;

        $metadataFieldIds = [$title, $affiliationame, $email, $scopusauthorid, $entitytype, $gender, $affiliationid, $jobtitle, $gsid, $orcid, $rid];


        $data = DB::table('metadatavalue as mv_outer')
            ->select(
                'mv_outer.dspace_object_id',
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $title THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as preferred_name"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $affiliationame THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as main_affiliation"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $email THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as email"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $scopusauthorid THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as scopus_author_id"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $entitytype THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as entity_type"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $gender THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as gender"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $affiliationid THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as affiliation_id"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $jobtitle THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as job_title"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $gsid THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as gsid"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $orcid THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as orcid"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $rid THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as rid"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $affiliationame THEN 
                    (SELECT mv_inner.authority 
                    FROM metadatavalue as mv_inner 
                    WHERE mv_inner.metadata_field_id = $affiliationame
                    AND mv_inner.dspace_object_id = mv_outer.dspace_object_id 
                    LIMIT 1) 
                    ELSE '' END) as department")

            )
            ->whereIn('mv_outer.dspace_object_id', function ($query) use ($id) {
                $query->select('c2i.item_id')
                    ->from('collection2item as c2i')
                    ->join('metadatavalue as mv', 'c2i.collection_id', '=', 'mv.dspace_object_id')
                    ->join('collection as col', 'mv.dspace_object_id', '=', 'col.uuid')
                    ->where('mv.metadata_field_id', 7)
                    ->where('mv.text_value', 'Person')
                    ->where('c2i.collection_id', $id);
            })
            ->whereIn('mv_outer.metadata_field_id', $metadataFieldIds)
            ->groupBy('mv_outer.dspace_object_id')
            ->get();

        // Count the results
        $count = $data->count();

        $name = DB::table('metadatavalue')
            ->where('dspace_object_id', $id)
            ->where('metadata_field_id', $this->title)
            ->value('text_value'); // Fetches a single value

        // Pass the data and count to the view (also passing $id if needed)
        return view('content.pages.persons', compact('data', 'count', 'id', 'name', 'communityid'));
    }

    // Delete Person
    public function delete($uuid, DSpaceApiService $apiService)
    {

        if (session()->has('api_token')) {
            $authorizationHeader = session()->get('api_token');

            $response = $apiService->delete('core/items/' . $uuid, $authorizationHeader);
            // Check if the response is successful.
            if ($response->getStatusCode() === 204) {
                return redirect()->back()->with('success', 'Person permanently deleted successfully');
            } else {
                return redirect()->back()->with('error', 'Failed to delete item');
            }
        } else {
            return redirect()->route('auth-login-basic');
        }
    }

    // Display function for sidebar List
    public function displayallpersons()
    {
        $title = $this->title;

        $affiliationame = $this->affiliationName;

        $email = $this->email;

        $scopusauthorid = $this->scopusAuthorId;

        $entitytype = $this->entityType;

        $gender = $this->gender;

        $affiliationid = $this->affiliationId;

        $jobtitle = $this->jobTitle;

        $gsid = $this->gsid;

        $orcid = $this->orcid;

        $rid = $this->rid;

        $metadataFieldIds = [$title, $affiliationame, $email, $scopusauthorid, $entitytype, $gender, $affiliationid, $jobtitle, $gsid, $orcid, $rid];


        // Prepare dynamic metadata field IDs if needed.
        $data = DB::table('metadatavalue as mv_outer')
            ->select(
                'mv_outer.dspace_object_id',
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $title THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as preferred_name"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $affiliationame THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as main_affiliation"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $email THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as email"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $scopusauthorid THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as scopus_author_id"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $entitytype THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as entity_type"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $gender THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as gender"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $affiliationid THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as affiliation_id"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $jobtitle THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as job_title"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $gsid THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as gsid"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $orcid THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as orcid"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id = $rid THEN COALESCE(mv_outer.text_value, '') ELSE '' END) as rid"),
                DB::raw("MAX(CASE WHEN mv_outer.metadata_field_id =$affiliationame  THEN 
                    (SELECT mv_inner.authority 
                    FROM metadatavalue as mv_inner 
                    WHERE mv_inner.metadata_field_id = $affiliationame 
                    AND mv_inner.dspace_object_id = mv_outer.dspace_object_id 
                    LIMIT 1) 
                    ELSE '' END) as department")
            )
            ->whereIn('mv_outer.dspace_object_id', function ($query) {
                $query->select('c2i.item_id')
                    ->from('collection2item as c2i')
                    ->join('metadatavalue as mv', 'c2i.collection_id', '=', 'mv.dspace_object_id')
                    ->join('collection as col', 'mv.dspace_object_id', '=', 'col.uuid')
                    ->where('mv.metadata_field_id', 7)
                    ->where('mv.text_value', 'Person');
            })
            ->whereIn('mv_outer.metadata_field_id', $metadataFieldIds)
            ->groupBy('mv_outer.dspace_object_id')
            ->get();

        // Count the results
        $count = $data->count();

        // Pass the data and count to the view (also passing $id if needed)
        return view('content.pages.personslist', compact('data', 'count'));
    }
}
