<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckApiToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // if (!session()->has('api_token')) { return redirect()->route('auth-login-basic'); } return $next($request); }
        // 1️⃣ User must be logged in (Laravel session check)
        if (!session()->has('api_token')) {
            return redirect()->route('auth-login-basic');
        }

        // 2️⃣ Check if DSpace token expiry exists
        if (!session()->has('dspace_expires_at')) {
            session()->flush();
            return redirect()->route('auth-login-basic')
                ->withErrors(['Invalid session. Please login again.']);
        }

        // 3️⃣ If DSpace session expired → refresh automatically
        if (now()->greaterThan(session('dspace_expires_at'))) {

            try {
                $api = app(\App\Services\DSpaceApiService::class);
                $new = $api->refreshToken();

                session([
                    'api_token' => $new['auth_token'],
                    'xsrf-token' => $new['xsrf_token'],
                    'dspace_expires_at' => now()->addMinutes(15)
                ]);
            } catch (\Exception $e) {
                session()->flush();
                return redirect()->route('auth-login-basic')
                    ->withErrors(['Session expired, please login again.']);
            }
        }

        // 4️⃣ Continue request
        return $next($request);
    }
}
