<?php

namespace App\Services;

use Exception;
use GuzzleHttp\Client;
use GuzzleHttp\Cookie\CookieJar;

class DSpaceApiService
{
  // protected $client;
  // protected $cookieJar;
  // protected $csrfToken;

  // public function __construct()
  // {
  //   $this->cookieJar = new CookieJar();
  //   $this->client = new Client([
  //     'base_uri' => config('services.restAPI.REST_API'),
  //     'cookies' => $this->cookieJar,
  //   ]);
  // }

  // // Fetch fresh CSRF token and store it
  // public function fetchCsrfToken()
  // {
  //   $response = $this->client->get('security/csrf');
  //   $this->csrfToken = $response->getHeaderLine('DSPACE-XSRF-TOKEN');
  //   return $this->csrfToken;
  // }

  // public function login($email, $password)
  // {
  //   $csrfToken = $this->fetchCsrfToken();

  //   $response = $this->client->post('authn/login', [
  //     'form_params' => [
  //       'user' => $email,
  //       'password' => $password,
  //     ],
  //     'headers' => [
  //       'X-XSRF-TOKEN' => $csrfToken,
  //     ],
  //     'cookies' => $this->cookieJar,
  //   ]);

  //   $authToken = $response->getHeader('Authorization')[0] ?? null;

  //   return [
  //     'auth_token' => $authToken,
  //     'xsrf_token' => $csrfToken,
  //     'cookieJar'  => $this->cookieJar,
  //   ];
  // }

  // public function post($uri, $data, $authToken)
  // {
  //   if (!$this->csrfToken) {
  //     $this->csrfToken = $this->fetchCsrfToken();
  //   }

  //   // Remove 'Bearer ' prefix if present
  //   $authToken = preg_replace('/^Bearer\s+/i', '', $authToken);

  //   return $this->client->post($uri, [
  //     'headers' => [
  //       'Authorization' => 'Bearer ' . $authToken,
  //       'X-XSRF-TOKEN' => $this->csrfToken,
  //       'Content-Type' => 'application/json',
  //     ],
  //     'json' => $data,
  //   ]);
  // }

  // public function delete($uri, $authToken)
  // {
  //   if (!$this->csrfToken) {
  //     $this->fetchCsrfToken();
  //   }

  //   $authToken = preg_replace('/^Bearer\s+/i', '', $authToken);

  //   return $this->client->delete($uri, [
  //     'headers' => [
  //       'Authorization' => 'Bearer ' . $authToken,
  //       'X-XSRF-TOKEN' => $this->csrfToken,
  //       'Content-Type' => 'application/json',
  //     ]
  //   ]);
  // }

  protected $client;
  protected $cookieJar;
  protected $csrfToken;
  protected $baseUrl;

  public function __construct()
  {
    $this->baseUrl = config('services.restAPI.REST_API');

    $this->cookieJar = new CookieJar();
    $this->client = new Client([
      'base_uri' => $this->baseUrl,
      'cookies'  => $this->cookieJar,
    ]);
  }

  // ------------------------------------------
  // GET CSRF TOKEN
  // ------------------------------------------
  public function fetchCsrfToken()
  {
    $response = $this->client->get('security/csrf');
    $this->csrfToken = $response->getHeaderLine('DSPACE-XSRF-TOKEN');
    return $this->csrfToken;
  }

  // ------------------------------------------
  // LOGIN (USED DURING USER LOGIN)
  // ------------------------------------------
  public function login($email, $password)
  {
    $csrfToken = $this->fetchCsrfToken();

    $response = $this->client->post('authn/login', [
      'form_params' => [
        'user' => $email,
        'password' => $password,
      ],
      'headers' => [
        'X-XSRF-TOKEN' => $csrfToken,
      ]
    ]);

    $authToken = $response->getHeader('Authorization')[0] ?? null;

    return [
      'auth_token' => $authToken,
      'xsrf_token' => $csrfToken
    ];
  }

  // ------------------------------------------
  // AUTO REFRESH TOKEN WHEN EXPIRED
  // ------------------------------------------
  public function refreshToken()
  {
    $email = session('email');
    $password = decrypt(session('encrypted_password'));


    if (!$email || !$password) {
      throw new Exception("Cannot refresh token: email/password missing in session");
    }

    $csrfToken = $this->fetchCsrfToken();

    $response = $this->client->post('authn/login', [
      'form_params' => [
        'user' => $email,
        'password' => $password,
      ],
      'headers' => [
        'X-XSRF-TOKEN' => $csrfToken,
      ]
    ]);

    $newToken = $response->getHeader('Authorization')[0] ?? null;

    if (!$newToken) {
      throw new Exception("Failed to refresh DSpace token");
    }

    return [
      'auth_token' => $newToken,
      'xsrf_token' => $csrfToken
    ];
  }

  // ------------------------------------------
  // POST REQUEST
  // ------------------------------------------
  public function post($uri, $data, $authToken)
  {
    if (!$this->csrfToken) {
      $this->csrfToken = $this->fetchCsrfToken();
    }

    $authToken = preg_replace('/^Bearer\s+/i', '', $authToken);

    return $this->client->post($uri, [
      'headers' => [
        'Authorization' => 'Bearer ' . $authToken,
        'X-XSRF-TOKEN' => $this->csrfToken,
        'Content-Type' => 'application/json',
      ],
      'json' => $data,
    ]);
  }

  public function delete($uri, $authToken)
  {
    if (!$this->csrfToken) {
      $this->fetchCsrfToken();
    }

    $authToken = preg_replace('/^Bearer\s+/i', '', $authToken);

    return $this->client->delete($uri, [
      'headers' => [
        'Authorization' => 'Bearer ' . $authToken,
        'X-XSRF-TOKEN' => $this->csrfToken,
        'Content-Type' => 'application/json',
      ]
    ]);
  }
}
