/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface ChoiceOptions extends ValidateOptions {
    max?: number;
    min?: number;
}
export interface ChoiceLocalization extends Localization {
    choice: {
        between: string;
        default: string;
        less: string;
        more: string;
    };
}

export function choice(): ValidateFunctionInterface<ChoiceOptions, ValidateResult>;
