/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface IbanOptions extends ValidateOptions {
    // The ISO 3166-1 country code. It can be
    // - A country code
    // - Name of field which its value defines the country code
    // - Name of callback function that returns the country code
    // - A callback function that returns the country code
    country?: string;
    // Set it to true (false) to indicate that the IBAN number must be (not be) from SEPA countries
    sepa?: boolean | string;
}
export interface IbanLocalization extends Localization {
    iban: {
        countries: {
            [countryCode: string]: string;
        };
        country: string;
        default: string;
    };
}

export function iban(): ValidateFunctionInterface<IbanOptions, ValidateResult>;
