@php
    $customizerHidden = 'customizer-hide';
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Login')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/@form-validation/form-validation.scss'])
@endsection

@section('page-style')
    @vite(['resources/assets/vendor/scss/pages/page-auth.scss'])
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js'])
@endsection

@section('page-script')
    @vite(['resources/assets/js/pages-auth.js'])
@endsection

{{-- Toaster --}}
@section('vendor-style')
    @vite(['resources/assets/vendor/libs/toastr/toastr.scss', 'resources/assets/vendor/libs/animate-css/animate.scss'])
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/toastr/toastr.js'])
@endsection

@section('content')
    {{-- It is used for showing success message of login -- Toast bar --}}
    @if (session()->has('success'))
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.querySelectorAll('.bs-toast').forEach(function(toastEl) {
                    new bootstrap.Toast(toastEl).show();
                });
            });
        </script>
        <div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 1100;">
            <div class="toast align-items-center text-bg-success border-0 py-3 bs-toast" role="alert" aria-live="assertive"
                aria-atomic="true" data-bs-delay="2000">
                <div class="d-flex">
                    <div class="toast-body d-flex align-items-center">
                        <!-- Icon and text -->
                        <i class="ti ti-check ti-lg me-3"></i>
                        <p class="fs-6 mb-0" style="font-size: 1.25rem;"> <!-- Adjusted font size here -->
                            {{ session('success') ?? 'Operation performed Successfully' }}
                        </p>
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                        aria-label="Close"></button>
                </div>
            </div>
        </div>
    @endif

    {{-- It is used for showing Error message-- Toast bar --}}
    @if (session()->has('error'))
        <script>
            document.addEventListener('DOMContentLoaded', function() {

                document.querySelectorAll('.bs-toast').forEach(function(toastEl) {
                    new bootstrap.Toast(toastEl).show();
                });

            });
        </script>

        <div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 1100;">
            <div class="toast align-items-center text-bg-danger border-0 py-3 bs-toast" role="alert" aria-live="assertive"
                aria-atomic="true" data-bs-delay="3000">
                <div class="d-flex">
                    <div class="toast-body d-flex align-items-center">
                        <!-- Icon and text -->
                        <span class="me-3">X</span>
                        <p class="fs-6 mb-0" style="font-size: 1.25rem;"> <!-- Adjusted font size here -->
                            {{ session('error') ?? 'Error Occurred while performing an operation' }}
                        </p>
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                        aria-label="Close"></button>
                </div>
            </div>
        </div>
    @endif
    <div class="container-xxl">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner py-6">
                <!-- Login -->
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <div class="app-brand justify-content-center mb-6">
                            <img src="{{ asset('assets/img/logo/IRINS.png') }}" alt="IRINS Logo" />
                        </div>
                        {{-- It is used for showing success message of login -- Toast bar --}}
                        @if ($errors->has('Unauthorizes'))
                            <script>
                                document.addEventListener('DOMContentLoaded', function() {
                                    const toastElement = document.querySelector('.bs-toast');
                                    if (toastElement) {
                                        const toast = new bootstrap.Toast(toastElement);
                                        toast.show();
                                    }
                                });
                            </script>
                            <div class="position-fixed top-0 end-0 p-3" style="z-index: 1050;">
                                <div class="bs-toast toast animate__animated animate__fadeIn show" role="alert"
                                    aria-live="assertive" aria-atomic="true" data-bs-delay="3000">
                                    <div class="toast-header">
                                        <i class="ti ti-x ti-xs me-2 text-danger"></i>
                                        <strong class="me-auto text-danger">Error!</strong>
                                        <button type="button" class="btn-close" data-bs-dismiss="toast"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="toast-body " style="font-weight: bold;">
                                        {{ $errors->first('Unauthorizes') }}
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if ($errors->has('error'))
                            <script>
                                document.addEventListener('DOMContentLoaded', function() {
                                    const toastElement = document.querySelector('.bs-toast');
                                    if (toastElement) {
                                        const toast = new bootstrap.Toast(toastElement);
                                        toast.show();
                                    }
                                });
                            </script>
                            <div class="position-fixed top-0 end-0 p-3" style="z-index: 1050;">
                                <div class="bs-toast toast animate__animated animate__fadeIn show" role="alert"
                                    aria-live="assertive" aria-atomic="true" data-bs-delay="3000">
                                    <div class="toast-header">
                                        <i class="ti ti-x ti-xs me-2 text-danger"></i>
                                        <strong class="me-auto text-danger">Error!</strong>
                                        <button type="button" class="btn-close" data-bs-dismiss="toast"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="toast-body" style="font-weight: bold;">
                                        {{ $errors->first('error') }}
                                    </div>
                                </div>
                            </div>
                        @endif
                        <!-- /Logo -->
                        <h4 class="mb-1">Welcome to {{ config('variables.templateName') }}! </h4>
                        <p class="mb-6">Please sign-in to your account and start the adventure</p>

                        <form id="formAuthentication" class="mb-4" action="{{ route('auth-login-basic') }}"
                            method="POST">
                            @csrf
                            <div class="mb-6">
                                <label for="email" class="form-label">Email or Username</label>
                                <input type="text" class="form-control" id="email" name="email-username"
                                    placeholder="Enter your email or username" autofocus>
                            </div>
                            <div class="mb-6 form-password-toggle">
                                <label class="form-label" for="password">Password</label>
                                <div class="input-group input-group-merge">
                                    <input type="password" id="password" class="form-control" name="password"
                                        placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                        aria-describedby="password" />
                                    <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                                </div>
                            </div>
                            <div class="my-8">
                                <div class="d-flex justify-content-between">
                                    <div class="form-check mb-0 ms-2">
                                        <input class="form-check-input" type="checkbox" id="remember-me">
                                        <label class="form-check-label" for="remember-me">
                                            Remember Me
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-6">
                                <button class="btn btn-primary d-grid w-100" type="submit">Login</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
