@php
    $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Edit Collection to Community')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss'])
@endsection

@section('page-style')
    @vite('resources/assets/vendor/scss/pages/app-logistics-dashboard.scss')
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'])
@endsection

@section('page-script')
    @vite('resources/assets/js/app-logistics-dashboard.js')
    <script>
        document.getElementById("submitButton").disabled = true; // Initially disable the button
        // 🟢 Data submit karne ka function
        document.getElementById("submitButton").addEventListener("click", function() {
            event.preventDefault();

            let selectedItems = document.querySelectorAll("#rightList div.selected");

            // Start the spinner
            var spinIcon = document.getElementById('spinIcon');
            spinIcon.classList.add('fa-spin');


            let box2Items = document.querySelectorAll("#rightList div");
            let box4Items = document.querySelectorAll("#rightList2 div");

            let box2Data = [];
            let box4Data = [];

            box2Items.forEach(item => {
                box2Data.push({
                    text_value: item.innerText.trim(),
                    dspace_object_id: item.getAttribute("data-id")
                });
            });

            box4Items.forEach(item => {
                box4Data.push({
                    text_value: item.innerText.trim(),
                    dspace_object_id: item.getAttribute("data-id")
                });
            });

            // 🟢 AJAX Request to Laravel Controller
            fetch("{{ route('community2collection.store') }}", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute(
                            "content")
                    },
                    body: JSON.stringify({
                        box2Data,
                        box4Data
                    })
                })
                .then(response => response.json())
                .then(data => {

                    spinIcon.classList.remove('fa-spin');
                    // console.log("Server Response:", data);
                    if (data.success) {
                        // ✅ Page refresh karna
                        window.location.reload();
                    } else {
                        console.log("Error:", data.error || "Unknown error");
                    }

                })
                .catch(error => {
                    console.error('Error:', error);
                    spinIcon.classList.remove('fa-spin');
                });
        });


        document.addEventListener("DOMContentLoaded", function() {
            let lists = document.querySelectorAll(".list-box");
            let draggedItem = null;

            lists.forEach(list => {
                list.addEventListener("dragstart", function(event) {
                    // if (event.target.parentElement.id === "rightList") {
                    //     event.preventDefault();
                    //     return;
                    // }

                    draggedItem = event.target;
                    event.target.classList.add("dragging");
                });

                list.addEventListener("dragend", function(event) {
                    event.target.classList.remove("dragging");
                    draggedItem = null;
                });

                list.addEventListener("dragover", function(event) {
                    // if (this.id === "rightList" && this.children.length >= 1) {
                    //     event.preventDefault();
                    //     return;
                    // }
                    event.preventDefault();
                });

                list.addEventListener("drop", function(event) {
                    event.preventDefault();
                    if (this.id === "rightList" && this.children.length >= 1) {
                        return;
                    }

                    if (draggedItem && draggedItem !== event.target && draggedItem.parentElement !==
                        this) {
                        this.appendChild(draggedItem);
                        draggedItem.classList.remove("selected");

                        if (this.id === "rightList") {
                            draggedItem.setAttribute("draggable", "true");
                        } else if (this.id === "leftList") {
                            draggedItem.setAttribute("draggable", "true");
                        }



                        // ✅ Make sure dragging is enabled when moving back to Box 1
                        // draggedItem.setAttribute("draggable", this.id === "leftList");

                        updateButtons();
                    }
                });
            });
        });







        function selectItem(event) {
            if (event.target.tagName === "DIV" && event.target.classList.contains("list-box") === false) {
                document.querySelectorAll(".list-box div").forEach(item => {
                    item.classList.remove("selected");
                });

                event.target.classList.add("selected");
                updateButtons();
            }
        }

        function moveItem(fromId, toId) {
            let fromList = document.getElementById(fromId);
            let toList = document.getElementById(toId);
            let selectedItems = fromList.querySelectorAll(".selected"); // Multiple items select hone ke liye

            if (!selectedItems.length) {
                if (fromId === "leftList" && toId === "rightList") {
                    alert("Please select the Community Name.");
                } else if ((fromId === "rightList2") || (fromId === "leftList2")) {
                    alert("Please select the Collection Name.");
                }
                return;
            }

            if (toId === "rightList2") {
                selectedItems.forEach(selectedItem => {
                    toList.appendChild(selectedItem);
                    selectedItem.classList.remove("selected");
                    selectedItem.setAttribute("draggable", "false"); // Box 4 ke liye draggable disable

                    // **Direct Console Output for Each Moved Item**
                    // console.log(`Moved to ${toId}:`, {
                    //     text_value: selectedItem.innerText.trim(),
                    //     dspace_object_id: selectedItem.getAttribute("data-id")
                    // });
                });
            } else {
                let selectedItem = selectedItems[0];

                if (toId === "rightList" && toList.children.length >= 1) {
                    return;
                }

                toList.appendChild(selectedItem);
                selectedItem.classList.remove("selected");

                // console.log(`Moved to ${toId}:`, {
                //     text_value: selectedItem.innerText.trim(),
                //     dspace_object_id: selectedItem.getAttribute("data-id")
                // });

                selectedItem.setAttribute("draggable", toId === "rightList" ? "false" : "true");
            }

            updateButtons();
        }



        function updateButtons() {
            let rightList = document.getElementById("rightList"); //BOx2
            let rightList2 = document.getElementById("rightList2"); // Box 4
            let moveRightButton = document.querySelector("[onclick=\"moveItem('leftList', 'rightList')\"]");
            let moveLeftButton = document.querySelector("[onclick=\"moveItem('rightList', 'leftList')\"]");

            moveRightButton.disabled = rightList.children.length >= 1;

            // Enable Move Left button if there is a selected item in Box 2
            // let selectedInRightList = rightList.querySelector(".selected");
            // moveLeftButton.disabled = !selectedInRightList;

            // ✅ NEW: Enable Move Left button if Box 2 has at least one item
            moveLeftButton.disabled = rightList.children.length === 0;

            // ✅ New Condition: Enable Submit Button if both Box 2 and Box 4 have at least one item
            if (rightList.children.length > 0 && rightList2.children.length > 0) {
                submitButton.disabled = false;
            } else {
                submitButton.disabled = true;
            }

        }

        document.getElementById("leftList").addEventListener("click", selectItem);
        document.getElementById("rightList").addEventListener("click", selectItem);

        updateButtons();

        document.getElementById("submitButton").addEventListener("click", function() {
            let selectedItems = document.querySelectorAll("#rightList div");
            let selectedData = [];

            selectedItems.forEach(item => {
                selectedData.push({
                    text_value: item.innerText.trim(),
                    dspace_object_id: item.getAttribute("data-id")
                });
            });
        });

        function moveAllItems(fromId, toId) {
            let fromList = document.getElementById(fromId);
            let toList = document.getElementById(toId);

            while (fromList.firstChild) {
                toList.appendChild(fromList.firstChild);
            }
        }
    </script>

    <style>
        .selected {
            background-color: rgb(147, 153, 251) !important;
            color: white;
            transition: background-color 0.2s ease-in-out;
        }

        .list-box {
            max-height: 210px;
            min-height: 210px;
            overflow-y: auto;
            display: flex;
            flex-direction: column;
            background-color: white !important;

        }



        .dragging {
            opacity: 0.5;
        }
    </style>
@endsection

@section('content')
    {{-- <div class="content-header row">
        <h2>Edit Collection to Community</h2>
    </div> --}}
    <div class="content-header row d-flex align-items-center">
        <div class="d-flex align-items-center">
            <i class="fa fa-edit fa-2x text-primary me-3"></i>
            <h2 class="mb-0">Edit Collection to Community</h2>
        </div>
    </div>

    {{-- <div class="container"> --}}
    <div class="row justify-content-center mt-5">
        <div class="col-md-4">
            <div id="leftList" class="p-3 bg-white border rounded shadow list-box" onclick="selectItem(event)">
                @foreach ($communityData as $item)
                    <div class="p-2 bg-light border rounded mb-2" draggable="true" data-id="{{ $item->dspace_object_id }}">
                        {{ $item->text_value }}
                    </div>
                @endforeach
            </div>
        </div>
        <div class="col-md-2 d-flex flex-column align-items-center justify-content-center gap-2">
            <button class="btn btn-primary w-100" onclick="moveItem('rightList', 'leftList')">&lt;- Move
                Left</button>
            <button class="btn btn-primary w-100" onclick="moveItem('leftList', 'rightList')">Move Right
                -&gt;</button>
        </div>
        <div class="col-md-4">
            <div id="rightList" class="p-3 bg-white border rounded shadow list-box" onclick="selectItem(event)">
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-7">
        <div class="col-md-4">
            <div id="leftList2" class="p-3 bg-white border rounded shadow list-box" onclick="selectItem(event)">
                @foreach ($data as $item)
                    <div class="p-2 bg-light border rounded mb-2" draggable="true" data-id="{{ $item->dspace_object_id }}">
                        {{ $item->text_value }}
                    </div>
                @endforeach
            </div>
        </div>
        <div class="col-md-2 d-flex flex-column align-items-center justify-content-center gap-2">
            <button class="btn btn-primary w-100" onclick="moveItem('rightList2', 'leftList2')">&lt;- Move
                Left</button>
            <button class="btn btn-primary w-100" onclick="moveItem('leftList2', 'rightList2')">Move Right
                -&gt;</button>
            <button class="btn btn-primary w-100" onclick="moveAllItems('rightList2', 'leftList2')">&lt;&lt; Move
                All
                Left</button>
            <button class="btn btn-primary w-100" onclick="moveAllItems('leftList2', 'rightList2')">Move All Right
                &gt;&gt;</button>
        </div>
        <div class="col-md-4">
            <div id="rightList2" class="p-3 bg-white border rounded shadow list-box" onclick="selectItem(event)">

            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-2 offset-md-10 d-flex">
            <button class="btn btn-primary rounded-pill ms-n10" id="submitButton">
                <i class="fas fa-refresh me-2" id="spinIcon"></i> Update
            </button>
        </div>
    </div>

    {{-- </div> --}}
@endsection
