@php
    $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Community List')

<!-- Vendor Styles -->
@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js'])
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
@section('content')
    <div class="content-header row mb-3">
        <div class="col-12 d-flex align-items-center justify-content-between">
            <!-- Header Title -->
            <h2 class="content-header-title mb-0">
                Community List
            </h2>

            <!-- Add Community Button -->
            <button type="button" class="btn btn-primary rounded-pill d-flex align-items-center" data-bs-toggle="modal"
                data-bs-target="#addCommunityModal">
                <i class="fas fa-plus me-2"></i> Add Community
            </button>
        </div>
        <!-- Community Creation Modal -->
        <div class="modal fade" id="addCommunityModal" tabindex="-1" aria-labelledby="addCommunityModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addCommunityModalLabel">Create Community</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="{{ route('community.add') }}" method="POST">
                            @csrf
                            <div class="mb-3">
                                <label for="name" class="form-label">Community Name:</label>
                                <input type="text" id="name" name="name" class="form-control" required>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Add</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-3 ">
        <div class="card">
            <div class="d-flex align-items-end row">
                <div class="col-7">
                    <div class="card-body text-nowrap d-flex flex-column align-items-start">
                        <!-- File Icon with Space -->
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-list fa-2x text-primary me-3"></i>
                            <!-- Number Text -->
                            <h5 class="card-title mb-0"> <span id="recordsTotal"></span></h5>
                        </div>
                        <!-- Total Publication Text Below Icon -->
                        <p class="mb-2">Total Communities</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
        <div class="col-12">
            <div class="card p-5 mt-5">
                <!-- Added margin-top for space -->
                <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                    <div class="row dt-row">
                        <div class="col-sm-12">
                            <table class="user-list table dataTable no-footer table-hover" id="DataTables_Table_0"
                                aria-describedby="DataTables_Table_0_info">
                                <thead>
                                    <tr>
                                        <th class="sorting w-50" tabindex="0" aria-controls="DataTables_Table_0"
                                            rowspan="1" colspan="1">NAME</th>
                                        <th class="sorting w-50" tabindex="0" aria-controls="DataTables_Table_0"
                                            rowspan="1" colspan="1">
                                            ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Dynamic rows generated by DataTables server-side processing -->
                                </tbody>
                            </table>
                        </div>
                    </div>


                    <!--View Modal -->
                    <div class="modal fade" id="backDropModal" tabindex="-1">
                        <div class="modal-dialog" style="max-width: 800px;">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="backDropModalTitle">Processes data</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                </div>
                                <div class="modal-footer">
                                    {{-- <button type="submit" class="btn btn-info" id="viewButton">View </button> --}}
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p id="deleteMessage">Are you sure you want to delete this community?</p>
                    </div>
                    <div class="modal-footer">
                        <!-- Hidden form with delete button -->
                        {{-- <form id="deleteForm" method="POST" action=""> --}}
                        <form id="deleteForm" method="POST"
                            action="{{ route('community.delete', ['id' => '__ID__']) }}">
                            @csrf
                            @method('DELETE')
                            <input type="hidden" name="community_id" id="community_id">
                            <button type="submit" class="btn btn-danger" id="deleteButton">Delete</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        {{-- Edit Model --}}
        <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editModalLabel">Edit Community</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="editForm" method="POST" action="{{ route('community.edit') }}">
                            @csrf
                            <input type="hidden" name="id" id="communityId">
                            <div class="mb-3">
                                <label for="communityName" class="form-label">Community Name</label>
                                <input type="text" class="form-control" id="communityName" name="community_name"
                                    placeholder="Enter community name" value="">
                                <!-- Error message will be displayed here -->
                                <span id="errorMessage" style="color: red; display: block;"></span>
                            </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" form="editForm" class="btn btn-primary">Update</button>
                        </form>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </div>
        </div>

        <script>
             const collectionUrlTemplate = @json(route('collection.index', ['id' => '__ID__']));
            $(document).ready(function() {
                let metadataValues = @json($data);
                let count = @json($count);

                $('#recordsTotal').text(count);

                $('#DataTables_Table_0').DataTable({
                    data: metadataValues, // Use the data directly
                    columns: [
                        // {
                        //         data: null,
                        //         orderable: false,
                        //         searchable: false,
                        //         render: function(data, type, row) {
                        //             return `<input type="checkbox" class="form-check-input">`;
                        //         }
                        //     }, // Checkbox column
                        // {
                        //     data: 'dspace_object_id',
                        //     name: 'id',
                        //     // render: function(data, type, row) {
                        //     //     return `<a href="/collection/${row.dspace_object_id}" class="text-primary">${data}</a>`;
                        //     // }
                        // },
                        {
                            data: 'text_value',
                            name: 'community_name',
                            render: function(data, type, row) {
                                const collectionUrl = collectionUrlTemplate.replace('__ID__', row.dspace_object_id);
                                return `<a href="${collectionUrl}" class="text-primary">${data}</a>`;
                            }
                        },
                        {
                            data: null,
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row) {
                                return `
                                <div class="d-flex justify-content-start">
                                   <a href="#" class="btn btn-warning btn-sm me-2" onclick="editCommunity('${row.dspace_object_id}','${row.text_value}');">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit font-medium-4">
                                            <path d="M11 2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V6l-7-4z"></path>
                                            <path d="M18 3l3 3-10 10-3-3L18 3z"></path>
                                        </svg>
                                    </a>
                                    <a href="#" class="btn btn-danger btn-sm waves-effect waves-float waves-light" onclick="confirmDelete('${row.dspace_object_id}','${row.text_value}');">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash font-medium-4">
                                            <polyline points="3 6 5 6 21 6"></polyline>
                                            <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                        </svg>
                                    </a>
                                </div>`;
                            }
                        } // Action buttons
                    ],
                    order: [
                        [0, 'desc']
                    ],
                    pageLength: 10, // Default page length
                    scrollX: true,
                    // responsive: true // Make table responsive
                });
            });

            // confirm delete
            // function confirmDelete(communityID, communityName) {
            //     // Find the selected process based on `processId`
            //     const communityId = communityID;
            //     const name = communityName;
            //     // console.log(communityName);
            //     if (communityId) {
            //         // Update the modal message with the selected process ID
            //         document.getElementById('deleteMessage').innerText =
            //             `Are you sure you want to delete community with Name: ${name}?`;
            //         // Show the modal
            //         const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
            //         deleteModal.show();

            //         // Set the form action and pass processId
            //         document.getElementById('deleteButton').onclick = function() {
            //             document.getElementById('community_id').value = communityId;
            //             document.getElementById('deleteForm').action = `/community/delete/${communityId}`;
            //             document.getElementById('deleteForm').submit();
            //         };

            //     } else {
            //         alert('Process not found!');
            //     }
            // }

            function confirmDelete(communityID, communityName) {
                const name = communityName;

                if (communityID) {
                    // Set modal message
                    document.getElementById('deleteMessage').innerText =
                        `Are you sure you want to delete community with Name: ${name}?`;

                    // Show modal
                    const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
                    deleteModal.show();

                    // Replace the action dynamically using the template
                    const deleteForm = document.getElementById('deleteForm');
                    const actionTemplate = deleteForm.getAttribute('action'); // this will be like /community/delete/__ID__
                    const newAction = actionTemplate.replace('__ID__', communityID);

                    document.getElementById('deleteButton').onclick = function() {
                        document.getElementById('community_id').value = communityID;
                        deleteForm.setAttribute('action', newAction);
                        deleteForm.submit();
                    };
                } else {
                    alert('Community not found!');
                }
            }


            // Edit Script
            function editCommunity(communityID, communityName) {
                if (communityID) {
                    // Ensure the modal element exists before showing
                    const editModalElement = document.getElementById('editModal');
                    if (editModalElement) {
                        const editModal = new bootstrap.Modal(editModalElement);
                        editModal.show();

                        // Set the hidden field with the community ID
                        document.getElementById("communityId").value = communityID;

                        // Get the input field and set its value
                        const inputField = document.getElementById("communityName");

                        // Clear any previous error messages
                        const errorMessageElement = document.getElementById("errorMessage");
                        if (errorMessageElement) {
                            errorMessageElement.innerHTML = ""; // Clear previous errors
                        }

                        // Set community name or fallback to default if empty
                        if (communityName && communityName.trim() !== "") {
                            inputField.value = communityName;
                        } else {
                            inputField.value = "Unnamed Community"; // Default fallback if the name is empty
                        }
                        // Add validation to ensure the name cannot be empty
                        document.getElementById("editForm").onsubmit = function(event) {
                            if (inputField.value.trim() === "" || inputField.value.trim() === "Unnamed Community") {
                                event.preventDefault(); // Prevent form submission
                                const errorMessageElement = document.getElementById("errorMessage");
                                if (errorMessageElement) {
                                    errorMessageElement.innerHTML =
                                        "Community name cannot be empty!"; // Display error message
                                    errorMessageElement.style.color = "red"; // Optional: Add color for the error message
                                }
                            }
                        };
                    } else {
                        console.error("Modal element not found!");
                    }
                } else {
                    alert('Community not found!');
                }
            }
        </script>
@endsection
