@php
    $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Data Integration')

@section('content')

@section('title', 'eCommerce Dashboard - Apps')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss'])
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'])
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

@section('content')
    <div class="content-header row d-flex align-items-center">
        <div class="d-flex align-items-center">
            <i class="fa fa-link fa-2x text-primary me-3"></i>
            <h2 class="mb-0">Data Integration</h2>
        </div>
    </div>


    <div class="row">
        <div class="col-12">
            <div class="card p-5 mt-3"> <!-- Added margin-top for space -->
                <h4>Sherpa URL</h4>
                <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer table-responsive">

                    <table class="user-list table dataTable no-footer" id="DataTables_Table_0"
                        aria-describedby="DataTables_Table_0_info">
                        <thead>
                            <tr>
                                <th class="sorting col-4" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                    colspan="1">Name</th>
                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                    colspan="1">Counts</th>
                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                    colspan="1">Date</th>
                                <th class="sorting col-2" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                    colspan="1">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Update Sherpa URL</td>
                                <td>{{ optional($publications->where('text_value', 'Update_Sherpa_URL')->first())->updated_count ?? 0 }}
                                </td>
                                <td>{{ optional($publications->where('text_value', 'Update_Sherpa_URL')->first())->last_date ?? '-' }}
                                </td>
                                <td class="d-flex align-items-center">
                                    <form action="{{ route('data-inte-sherpaUrl') }}" method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                            id="update-sherpa-url" data-update
                                            data-update-url="{{ route('data-inte-sherpaUrl') }}"
                                            data-redirect-url="{{ route('data-integration.index') }}"
                                            data-spin-icon="spinIcon">
                                            <i class="fas fa-refresh me-2" id="spinIcon"></i> Update
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <div>
                    </div>



                </div>
            </div>
            <div class="card p-5 mt-2">
                <div class="d-flex align-items-center justify-content-between">
                    <h4 class="card-title"><span><img src="{{ asset('assets/img/logo/scopus.png') }}" alt=""
                                height="40" width="auto"></span> Scopus</h4>
                </div>
                <div class="card-body card-dashboard pt-2 pb-2">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th class="sorting col-4" tabindex="0" aria-controls="DataTables_Table_0"
                                        rowspan="1" colspan="1">Name</th>
                                    <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                        colspan="1">Counts</th>
                                    <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                        colspan="1">Date</th>
                                    <th class="sorting col-2" tabindex="0" aria-controls="DataTables_Table_0"
                                        rowspan="1" colspan="1">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                {{-- <tr>
                                <td>Import/Update Scopus Citation</td>
                                <td>{{ optional($publications->where('text_value', 'Import_Scopus_Citation')->first())->updated_count ?? 0 }}
                                </td>
                                <td>{{ optional($publications->where('text_value', 'Import_Scopus_Citation')->first())->last_date ?? '-' }}
                                </td>
                                <td>
                                    <form action="{{ route('data-inte-import-scopus-citation') }}" method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                            id="import-scopus-citation" data-update
                                            data-update-url="{{ route('data-inte-import-scopus-citation') }}"
                                            data-redirect-url="{{ route('data-integration.index') }}"
                                            data-spin-icon="spinIcon4">
                                            <i class="fas fa-refresh me-2" id="spinIcon4"></i> Import
                                        </button>
                                    </form>
                                </td>
                            </tr> --}}
                                <tr>
                                    <td>Import/Update Scopus Citation</td>
                                    <td>{{ optional($publications->where('text_value', 'import_update_scopus_publications_citation')->first())->updated_count ?? 0 }}
                                    </td>
                                    <td>{{ optional($publications->where('text_value', 'import_update_scopus_publications_citation')->first())->last_date ?? '-' }}
                                    </td>
                                    <td>
                                        <form action="{{ route('data-inte-update-scopus-citation') }}" method="POST">
                                            @csrf
                                            <button type="submit"
                                                class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                                id="update-scopus-citation" data-update
                                                data-update-url="{{ route('data-inte-update-scopus-citation') }}"
                                                data-redirect-url="{{ route('data-integration.index') }}"
                                                data-spin-icon="spinIcon5">
                                                <i class="fas fa-refresh me-2" id="spinIcon5"></i> Update
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-12 col-md-5 col-lg-5">
            <div class="card p-5 mt-3"> <!-- Added margin-top for space -->
                <h4>Update Citations & H-index of Person based on ScopusID</h4>
                <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer table-responsive">
                    <table class="user-list table dataTable no-footer" id="DataTables_Table_0"
                        aria-describedby="DataTables_Table_0_info">
                        <thead>
                            <tr>
                                <th class="sorting col-4" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                    colspan="1">Name</th>
                                <th class="sorting col-2" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                    colspan="1">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Update H-index</td>
                                <td class="d-flex align-items-center">
                                    <form action="{{ route('update.hindex') }}" method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                            id="updateButton" data-update data-update-url="{{ route('update.hindex') }}"
                                            data-redirect-url="{{ route('data-integration.index') }}"
                                            data-spin-icon="spinIcon7">
                                            <i class="fas fa-refresh me-2" id="spinIcon7"></i> Update
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <tr>
                                <td>Update Documentes</td>
                                <td class="d-flex align-items-center">
                                    <form action="{{ route('update.documentes') }}" method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                            id="update-documentes" data-update
                                            data-update-url="{{ route('update.documentes') }}"
                                            data-redirect-url="{{ route('data-integration.index') }}"
                                            data-spin-icon="spinIcon10">
                                            <i class="fas fa-refresh me-2" id="spinIcon10"></i> Update
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <tr>
                                <td>Update Cited</td>
                                <td class="d-flex align-items-center">
                                    <form action="{{ route('update.cited') }}" method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                            id="update-cited" data-update data-update-url="{{ route('update.cited') }}"
                                            data-redirect-url="{{ route('data-integration.index') }}"
                                            data-spin-icon="spinIcon11">
                                            <i class="fas fa-refresh me-2" id="spinIcon11"></i> Update
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <tr>
                                <td>Update Citation</td>
                                <td class="d-flex align-items-center">
                                    <form action="{{ route('update.citation') }}" method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                            id="update-crossref-citation" data-update
                                            data-update-url="{{ route('update.citation') }}"
                                            data-redirect-url="{{ route('data-integration.index') }}"
                                            data-spin-icon="spinIcon8">
                                            <i class="fas fa-refresh me-2" id="spinIcon8"></i> Update
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            <tr>
                                <td>Update Co-author</td>
                                <td class="d-flex align-items-center">
                                    <form action="{{ route('update.coauthor') }}" method="POST">
                                        @csrf
                                        <button type="submit"
                                            class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                            id="update-co-author-hindex" data-update
                                            data-update-url="{{ route('update.coauthor') }}"
                                            data-redirect-url="{{ route('data-integration.index') }}"
                                            data-spin-icon="spinIcon9">
                                            <i class="fas fa-refresh me-2" id="spinIcon9"></i> Update
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>


            </div>
        </div>

        <div class="col">
            <div class="row">
                <div class="col-12 col-sm-6 col-lg-6 mt-3 ">
                    <div class="card mb-3">
                        <div class="card-header d-flex align-items-center justify-content-between">

                            <img src="{{ asset('assets/img/logo/base.png') }}" alt="Solr" height="40">
                        </div>
                        <div class="card-body card-dashboard">
                            <div class="table-responsive ">

                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Update unpaywall</td>
                                            <td>
                                                <form action="{{ route('data-inte-unpaywall') }}" method="POST">
                                                    @csrf
                                                    <button type="submit"
                                                        class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                                        id="update-unpaywall" data-update
                                                        data-update-url="{{ route('data-inte-unpaywall') }}"
                                                        data-redirect-url="{{ route('data-integration.index') }}"
                                                        data-spin-icon="spinIcon2">
                                                        <i class="fas fa-refresh me-2" id="spinIcon2"></i> Update
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-sm-6 col-lg-6 mt-3 ">
                    <div class="card mb-4 ">
                        <div class="card-header d-flex align-items-center justify-content-between">

                            <img src="{{ asset('assets/img/logo/solr.png') }}" alt="Solr" height="40">
                        </div>
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">

                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Solr Indexing</td>
                                            <td>
                                                <form action="{{ route('update.solr.index') }}" method="POST">
                                                    @csrf
                                                    <button type="submit"
                                                        class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                                        id="update-solr-index" data-update
                                                        data-update-url="{{ route('update.solr.index') }}"
                                                        data-redirect-url="{{ route('data-integration.index') }}"
                                                        data-spin-icon="spinIcon6">
                                                        <i class="fas fa-refresh me-2" id="spinIcon6"></i> Update
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12 col-sm-6 col-lg-6 mt-3">
                    <div class="card mb-4">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h4 class="card-title">Mapping</h4>
                            {{-- <h4 class="card-title"><span><img src="{{ asset('assets/img/logo/scopus.png') }}"
                        alt="" height="40" width="auto"></span> Scopus</h4> --}}

                        </div>
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">

                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Person With Department</td>
                                            <td>
                                                <form action="{{ route('mapPersonwithDept') }}" method="POST">
                                                    @csrf
                                                    <button type="button"
                                                        class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                                        data-update data-update-url="{{ route('mapPersonwithDept') }}"
                                                        data-redirect-url="{{ route('data-integration.index') }}"
                                                        data-spin-icon="spinIcon12">
                                                        <i class="fas fa-refresh me-2" id="spinIcon12"></i> Update
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Publication with Author(ScopusID)</td>
                                            <td>
                                                <form action="{{ route('mapPubwithPersonScopusId') }}" method="POST">
                                                    @csrf
                                                    <button type="submit"
                                                        class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                                        id="update-scopus-citation" data-update
                                                        data-update-url="{{ route('mapPubwithPersonScopusId') }}"
                                                        data-redirect-url="{{ route('data-integration.index') }}"
                                                        data-spin-icon="spinIcon13">
                                                        <i class="fas fa-refresh me-2" id="spinIcon13"></i> Update
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                        {{-- <tr>
                                            <td>Publication with Author(ResecherId)</td>
                                            <td>
                                                <form action="{{ route('mapPubwithPersonResearchId') }}" method="POST">
                                    @csrf
                                    <button type="submit"
                                        class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                        id="update-scopus-citation" data-update
                                        data-update-url="{{ route('mapPubwithPersonResearchId') }}"
                                        data-redirect-url="{{ route('data-integration.index') }}"
                                        data-spin-icon="spinIcon14">
                                        <i class="fas fa-refresh me-2" id="spinIcon14"></i> Update
                                    </button>
                                    </form>
                                    </td>
                                    </tr> --}}
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-sm-6 col-lg-6 mt-3 ">
                    <div class="card mb-4">
                        <div class="card-header d-flex align-items-center justify-content-between">

                            <h4 class="card-title"><span><img src="{{ asset('assets/img/logo/crossref.png') }}"
                                        alt="" height="40" width="auto"></span> Crossref</h4>
                        </div>
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">

                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Update Crossref Citation</td>
                                            <td>
                                                <form action="{{ route('data-inte-crossref-citation') }}" method="POST">
                                                    @csrf
                                                    <button type="submit"
                                                        class="btn btn-primary rounded-pill d-flex align-items-center text-white"
                                                        id="update-crossref-citation" data-update
                                                        data-update-url="{{ route('data-inte-crossref-citation') }}"
                                                        data-redirect-url="{{ route('data-integration.index') }}"
                                                        data-spin-icon="spinIcon3">
                                                        <i class="fas fa-refresh me-2" id="spinIcon3"></i> Update
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Find all buttons with the data-update attribute
            document.querySelectorAll('[data-update]').forEach(button => {
                button.addEventListener('click', function(event) {
                    event.preventDefault();

                    // Get configuration from data attributes
                    const updateUrl = this.getAttribute('data-update-url');
                    const redirectUrl = this.getAttribute('data-redirect-url');
                    const spinIconId = this.getAttribute('data-spin-icon');

                    // Get the spinner
                    const spinIcon = document.getElementById(spinIconId);
                    if (spinIcon) {
                        spinIcon.classList.add('fa-spin');
                    }

                    // Get the CSRF token
                    const csrfToken = document.querySelector('input[name="_token"]').value;

                    // Perform the AJAX request
                    fetch(updateUrl, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': csrfToken
                            }
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (spinIcon) {
                                spinIcon.classList.remove('fa-spin');
                            }

                            if (data.success && redirectUrl) {
                                window.location.href = redirectUrl;
                            } else {
                                console.log("Error:", data.error);
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            if (spinIcon) {
                                spinIcon.classList.remove('fa-spin');
                            }
                        });
                });
            });
        });
    </script>
@endsection
