@extends('layouts/layoutMaster')

@section('title', 'Department Counts')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss'])
@endsection

@section('page-style')
    @vite('resources/assets/vendor/scss/pages/app-logistics-dashboard.scss')
@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'])
@endsection

@section('page-script')
    @vite('resources/assets/js/app-logistics-dashboard.js')
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
@section('content')
    <div class="col-12 d-flex align-items-center justify-content-between">
        <!-- Header Title -->
        <h2 class="content-header-title mb-0">
            Departments
        </h2>
        <!-- Add Community Button -->
        <a href="{{ route('departments.update') }}" id="updateButton"
            class="btn btn-primary rounded-pill d-flex align-items-center waves-effect waves-light">
            <i class="fas fa-refresh me-2" id="spinIcon"></i> Update
        </a>
    </div>
    <script>
        document.getElementById('updateButton').addEventListener('click', function(event) {
            event.preventDefault(); // Prevents default behavior (page reload)

            // Start the spinner
            var spinIcon = document.getElementById('spinIcon');
            spinIcon.classList.add('fa-spin');

            // Perform the AJAX requestF

            fetch("{{ route('departments.update') }}")
                .then(response => response.json())
                .then(data => {
                    spinIcon.classList.remove('fa-spin'); // Stop the spinner

                    if (data.success) {
                        // console.log("Session Success Message:", data.success);
                        window.location.href = "{{ route('departments.index') }}";
                    } else {
                        console.log("Error:", data.error);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    spinIcon.classList.remove('fa-spin'); // Stop the spinner
                    // document.getElementById('errorMessage').textContent =
                });
        });
    </script>
    <div id="loader"
        style="display:none; position:absolute; top:50%; left:50%; transform:translate(-50%, -50%); z-index:9999;">
        <div class="spinner-border text-primary" style="width: 4rem; height: 4rem;"></div>
    </div>

    <div class="col-12">
        <div class="card p-5 mt-3">
            <div class="row mb-3">
                <div class="col-md-3">
                    <label for="yearFrom">Year From</label>
                    <input type="number" id="yearFrom" class="form-control" placeholder="1997">
                    <small id="yearFromError" class="text-danger"></small>
                </div>
                <div class="col-md-3">
                    <label for="yearTo">Year To</label>
                    <input type="number" id="yearTo" class="form-control" placeholder="2025">
                    <small id="yearToError" class="text-danger"></small>
                </div>
                <div class="col-md-3 mt-5">
                    <button id="applyYearFilter" class="btn btn-primary">Apply</button>
                    <button id="reset" class="btn btn-primary">Reset</button>
                </div>
            </div>
            <div class="dataTables_wrapper dt-bootstrap5 no-footer">
                <div class="row dt-row">
                    <div class="col-sm-12">
                        <table class="datatables-departments table table-hover dataTable no-footer w-100">
                            <thead>
                                <tr>
                                    <th>Department</th>
                                    <th>Publications</th>
                                    <th>Publications Citation</th>
                                    <th>Open Access</th>
                                    <th>Open Access Citation</th>
                                    <th>Scopus</th>
                                    <th>Scopus Citation</th>
                                    <th>WOS</th>
                                    <th>WOS Citation</th>
                                    <th>Not Indexed</th>
                                    <th>Not Indexed Citation</th>
                                    <th>Scopus Eng</th>
                                    <th>Scopus Eng Citation</th>
                                    <th>WOS Eng</th>
                                    <th>WOS Eng Citation</th>
                                    <th>E-Print</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- DataTables will inject rows here -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

<script>
    let dt;
    $(function() {
        dt = $('.datatables-departments')
            .on('preXhr.dt', function() {
                // Show loader before DataTables sends AJAX request
                $('#loader').show();
            })
            .on('xhr.dt', function() {
                // Hide loader after data received
                $('#loader').hide();
            }).DataTable({
                ajax: {
                    url: '{{ route('departments.data') }}',
                    data: function(d) {
                        d.year_from = $('#yearFrom').val();
                        d.year_to = $('#yearTo').val();
                    }
                },
                scrollX: true,
                columns: [{
                        data: 'department_name'
                    },
                    {
                        data: 'total_publications'
                    },
                    {
                        data: 'total_publication_citations'
                    },
                    {
                        data: 'open_access_publications'
                    },
                    {
                        data: 'open_access_citations'
                    },
                    {
                        data: 'scopus_publications'
                    },
                    {
                        data: 'scopus_citations'
                    },
                    {
                        data: 'wos_publications'
                    },
                    {
                        data: 'wos_citations'
                    },
                    {
                        data: 'not_indexed_publications'
                    },
                    {
                        data: 'not_indexed_citations'
                    },
                    {
                        data: 'scopus_eng_publications'
                    },
                    {
                        data: 'scopus_eng_citations'
                    },
                    {
                        data: 'wos_eng_publications'
                    },
                    {
                        data: 'wos_eng_citations'
                    },
                    {
                        data: 'eprint_publications'
                    }
                ],
                pageLength: 25,
                dom: '<"row mb-3"' +
                    '<"col-sm-12 col-md-6"l>' +
                    '<"col-sm-12 col-md-6 d-flex justify-content-end align-items-center"fB>' +
                    '>' +
                    't' +
                    '<"row mt-3"' +
                    '<"col-sm-12 col-md-6"i>' +
                    '<"col-sm-12 col-md-6"p>' +
                    '>',
                buttons: [{
                    extend: 'collection',
                    className: 'btn btn-label-primary dropdown-toggle ms-2 waves-effect waves-light border-none',
                    text: '<i class="ti ti-file-export ti-xs me-sm-1"></i> <span class="d-none d-sm-inline-block">Export</span>',
                    buttons: [{
                            extend: 'print',
                            text: '<i class="ti ti-printer me-1"></i>Print',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
                            }
                        },
                        {
                            extend: 'csv',
                            text: '<i class="ti ti-file-text me-1"></i>Csv',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
                            }
                        },
                        {
                            extend: 'excel',
                            text: '<i class="ti ti-file-spreadsheet me-1"></i>Excel',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
                            }
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="ti ti-file-description me-1"></i>Pdf',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
                            }
                        },
                        {
                            extend: 'copy',
                            text: '<i class="ti ti-copy me-1"></i>Copy',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
                            }
                        }
                    ]
                }],
                order: [
                    [0, 'asc']
                ],
                language: {
                    paginate: {
                        next: '<i class="ti ti-chevron-right ti-sm"></i>',
                        previous: '<i class="ti ti-chevron-left ti-sm"></i>'
                    }
                }
            });
        // LIVE validation - remove error while typing
        $('#yearFrom, #yearTo').on('input', function() {

            const id = $(this).attr('id');
            const value = $(this).val();
            const errorSpan = $('#' + id + 'Error');

            // Remove error instantly while typing
            $(this).removeClass('is-invalid');
            errorSpan.text('');

            // Allow only 4 digits
            if (value && (value.length > 4 || value < 1000)) {
                $(this).addClass('is-invalid');
                errorSpan.text('Enter a valid year (4 digits)');
            }

        });
        // $('#applyYearFilter').on('click', function() {
        //     dt.ajax.reload();
        // });
        $('#applyYearFilter').on('click', function() {

            let from = $('#yearFrom').val();
            let to = $('#yearTo').val();

            // Reset errors
            $('#yearFromError').text('');
            $('#yearToError').text('');
            $('#yearFrom').removeClass('is-invalid');
            $('#yearTo').removeClass('is-invalid');

            let hasError = false;

            if (!from) {
                $('#yearFromError').text('Please enter From year');
                $('#yearFrom').addClass('is-invalid');
                hasError = true;
            }

            if (!to) {
                $('#yearToError').text('Please enter To year');
                $('#yearTo').addClass('is-invalid');
                hasError = true;
            }

            if (from && to) {
                from = parseInt(from);
                to = parseInt(to);

                if (from > to) {
                    $('#yearToError').text('To year must be greater than or equal to From year');
                    $('#yearTo').addClass('is-invalid');
                    $('#yearFrom').addClass('is-invalid');
                    hasError = true;
                }
            }

            if (hasError) return;

            dt.ajax.reload();
        });
        $('#reset').on('click', function() {
            $('#yearFrom').val('');
            $('#yearTo').val('');

            $('#yearFromError').text('');
            $('#yearToError').text('');

            $('#yearFrom').removeClass('is-invalid');
            $('#yearTo').removeClass('is-invalid');

            dt.ajax.reload();
        });

    });
</script>
