@php
    $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Orgunit List')

<!-- Vendor Styles -->
@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js'])
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
@section('content')
    <div class="content-header row mb-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="{{ route('community.index') }}">Community</a>
                </li>
                <li class="breadcrumb-item">
                     <a href="{{ route('collection.index', ['id' => $communityId]) }}">Collection</a>
                </li>
                <li class="breadcrumb-item active">
                    Orgunit Items
                </li>
            </ol>
        </nav>
        <div class="col-12 d-flex align-items-center justify-content-between">
            <!-- Header Title -->
            <h2 class="content-header-title mb-0">
                {{ $name }}
            </h2>
            {{-- @if (session()->has('api_token'))
                <p>Your API Token: {{ session('api_token') }}</p>
            @endif --}}

            <div class="d-flex">
                <form action="{{ route('export.metadata') }}" method="POST">
                    @csrf
                    <input type="hidden" name="id" value="{{ $id }}">
                    <button type="submit" class="btn btn-primary rounded-pill d-flex align-items-center">
                        <i class="fa fa-file me-2"></i>Export CSV
                    </button>
                </form>
                {{-- <button type="button" class="btn btn-primary rounded-pill d-flex align-items-center me-2"
                data-bs-toggle="modal" data-bs-target="#addCommunityModal">
                <i class="fas fa-plus me-2"></i> Add Persons
            </button>
            <button type="button" class="btn btn-primary rounded-pill d-flex align-items-center" data-bs-toggle="modal"
                data-bs-target="#updateCommunityModal">
                <i class="fas fa-refresh me-2"></i> Update Persons
            </button> --}}
            </div>
        </div>
    </div>
    <section id="orgunit" class="">
        <div class="col-xl-3">
            <h4>OrgUnit List</h4>
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-7">
                        <div class="card-body text-nowrap d-flex flex-column align-items-start">
                            <!-- File Icon with Space -->
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-building fa-2x text-primary me-3"></i>
                                <!-- Number Text -->
                                <h5 class="card-title mb-0"> <span id="recordsTotal"></span></h5>
                            </div>
                            <!-- Total OrgUnit Text Below Icon -->
                            <p class="mb-2">Total OrgUnit</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card p-5 mt-3">
                    <!-- Added margin-top for space -->
                    <div id="DataTables_Table_0_wrapper"
                        class="dataTables_wrapper dt-bootstrap5 no-footer table-responsive">
                        <div class="row dt-row">
                            <div class="col-sm-12">
                                <table class="user-list table table-striped dataTable no-footer" id="DataTables_Table_0"
                                    aria-describedby="DataTables_Table_0_info">
                                    <thead>
                                        <tr>
                                            {{-- <th class="sorting_disabled dt-checkboxes-cell dt-checkboxes-select-all"
                                            rowspan="1" colspan="1" style="width: 18px;" data-col="1"
                                            aria-label=""> --}}
                                            {{-- <input type="checkbox" class="form-check-input"> --}}
                                            {{-- </th> --}}
                                            <th class="sorting sorting_asc text-nowrap col-5" tabindex="0"
                                                aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                                aria-sort="ascending">
                                                ID</th>
                                            <th class="sorting col-4" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">NAME</th>
                                            <th class="sorting col-4" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">
                                                ACTION</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Dynamic rows generated by DataTables server-side processing -->
                                    </tbody>
                                </table>
                            </div>
                        </div>


                        <!--View Modal -->
                        <div class="modal fade" id="backDropModal" tabindex="-1">
                            <div class="modal-dialog" style="max-width: 800px;">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="backDropModalTitle">Processes data</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                    </div>
                                    <div class="modal-footer">
                                        {{-- <button type="submit" class="btn btn-info" id="viewButton">View </button> --}}
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p id="deleteMessage">Are you sure you want to delete this Organization?</p>
                        </div>
                        <div class="modal-footer">
                            <!-- Hidden form with delete button -->
                            <form id="deleteForm" method="POST"
                                action="{{ route('orgunit.delete', ['uuid' => '__UUID__']) }}">
                                @csrf
                                @method('DELETE')
                                <input type="hidden" name="orgunit_id" id="orgunit_id">
                                <button type="submit" class="btn btn-danger" id="deleteButton">Delete</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Edit Model --}}
            <div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="editModalLabel">Edit Organization</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form id="editForm" method="POST" action="{{ route('orgunit.edit') }}">
                                @csrf
                                <input type="hidden" name="id" id="orgunitId">
                                <div class="mb-3">
                                    <label for="orgunitName" class="form-label">Organization Name</label>
                                    <input type="text" class="form-control" id="orgunitName" name="orgunit_name"
                                        placeholder="Enter orgunit name" value="">
                                    <!-- Error message will be displayed here -->
                                    <span id="errorMessage" style="color: red; display: block;"></span>
                                </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" form="editForm" class="btn btn-primary">Update</button>
                            </form>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>
    </section>
    <!-- Empty State Message -->
    <div id="empty-state" class="text-center p-5 d-none">
        <div class="mb-4">
            <i class="fas fa-box-open text-muted" style="font-size: 5rem;"></i>
        </div>
        <h4 class="text-muted">No Data Available</h4>
        <p class="text-muted">There are no OrgUnit available in the database.</p>
    </div>
    <script>
        $(document).ready(function() {
            let metadataValues = @json($data);
            let recordsCount = metadataValues.length;

            // Reference elements
            let emptyState = $('#empty-state');
            let dataTableContainer = $('#DataTables_Table_0');
            let section = $('#orgunit');

            function checkEmptyState() {
                if (recordsCount === 0) {
                    emptyState.removeClass("d-none"); // Show "No Data Available" message
                    dataTableContainer.hide();
                    section.hide(); // Use .hide() to prevent the brief flash
                } else {
                    emptyState.addClass("d-none"); // Hide the message
                    dataTableContainer.show();
                    section.show(); // Use .show() instead of removing d-none
                }
            }

            // Call function to check the state initially
            checkEmptyState();

            if (recordsCount > 0) {
                $('#recordsTotal').text(recordsCount);

                $('#DataTables_Table_0').DataTable({
                    data: metadataValues, // Use the data directly
                    columns: [{
                            data: 'dspace_object_id',
                            name: 'id',
                        },
                        {
                            data: 'text_value',
                            name: 'orgunit_name',
                            render: function(data, type, row) {
                                return `<a href="/orgunit/item/${row.dspace_object_id}" class="text-primary">${data}</a>`;
                            }
                        },
                        {
                            data: null,
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row) {
                                return `
                        <div class="d-flex justify-content-start">
                            <a href="#" class="btn btn-warning btn-sm me-2" onclick="editOrgUnit('${row.dspace_object_id}', '${row.text_value}');">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit font-medium-4">
                                    <path d="M11 2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V6l-7-4z"></path>
                                    <path d="M18 3l3 3-10 10-3-3L18 3z"></path>
                                </svg>
                            </a>
                            <a href="#" class="btn btn-danger btn-sm" onclick="confirmDelete('${row.dspace_object_id}', '${row.text_value}');">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash font-medium-4">
                                    <polyline points="3 6 5 6 21 6"></polyline>
                                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                </svg>
                            </a>
                        </div>`;
                            }
                        }
                    ],
                    order: [
                        [0, 'desc']
                    ],
                    pageLength: 10,
                    scrollX: true,
                });
            }
        });

        // confirm delete
        // function confirmDelete(orgunitID, orgunitName) {
        //     // Find the selected process based on `processId`
        //     const orgunitId = orgunitID;
        //     const name = orgunitName;
        //     // console.log(orgunitName);
        //     if (orgunitId) {
        //         // Update the modal message with the selected process ID
        //         document.getElementById('deleteMessage').innerText =
        //             `Are you sure you want to delete Organization with Name: ${name}?`;
        //         // Show the modal
        //         const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
        //         deleteModal.show();

        //         // Set the form action and pass processId
        //         document.getElementById('deleteButton').onclick = function() {
        //             document.getElementById('orgunit_id').value = orgunitId;
        //             document.getElementById('deleteForm').action = `/orgunit/delete/${orgunitId}`;
        //             document.getElementById('deleteForm').submit();
        //         };

        //     } else {
        //         alert('Process not found!');
        //     }
        // }

        function confirmDelete(orgunitID, orgunitName) {
            if (orgunitID) {
                document.getElementById('deleteMessage').innerText =
                    `Are you sure you want to delete Organization with Name: ${orgunitName}?`;

                const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
                deleteModal.show();

                const deleteForm = document.getElementById('deleteForm');
                const originalAction = deleteForm.getAttribute('action'); // has __UUID__
                const newAction = originalAction.replace('__UUID__', orgunitID);

                // Set hidden input and updated action
                document.getElementById('orgunit_id').value = orgunitID;
                deleteForm.setAttribute('action', newAction);

                // Submit on delete button click
                document.getElementById('deleteButton').onclick = function() {
                    deleteForm.submit();
                };
            } else {
                alert('Organization not found!');
            }
        }


        // Edit Script
        function editOrgUnit(orgunitID, orgunitName) {
            if (orgunitID) {
                // Ensure the modal element exists before showing
                const editModalElement = document.getElementById('editModal');
                if (editModalElement) {
                    const editModal = new bootstrap.Modal(editModalElement);
                    editModal.show();

                    // Set the hidden field with the orgunit ID
                    document.getElementById("orgunitId").value = orgunitID;

                    // Get the input field and set its value
                    const inputField = document.getElementById("orgunitName");

                    // Clear any previous error messages
                    const errorMessageElement = document.getElementById("errorMessage");
                    if (errorMessageElement) {
                        errorMessageElement.innerHTML = ""; // Clear previous errors
                    }

                    // Set orgunit name or fallback to default if empty
                    if (orgunitName && orgunitName.trim() !== "") {
                        inputField.value = orgunitName;
                    } else {
                        inputField.value = "Unnamed Organization"; // Default fallback if the name is empty
                    }
                    // Add validation to ensure the name cannot be empty
                    document.getElementById("editForm").onsubmit = function(event) {
                        if (inputField.value.trim() === "" || inputField.value.trim() === "Unnamed Organization") {
                            event.preventDefault(); // Prevent form submission
                            const errorMessageElement = document.getElementById("errorMessage");
                            if (errorMessageElement) {
                                errorMessageElement.innerHTML =
                                    "Organization name cannot be empty!"; // Display error message
                                errorMessageElement.style.color = "red"; // Optional: Add color for the error message
                            }
                        }
                    };
                } else {
                    console.error("Modal element not found!");
                }
            } else {
                alert('Organization not found!');
            }
        }
    </script>

    </div>
@endsection
