@php
    $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'OrgUnit Item')

<!-- Vendor Styles -->
@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js'])
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
@section('content')
    <div class="content-header row mb-3">
        <!-- Title Section -->
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h2 class="mb-0">
                    {{ $name }}
                </h2>


                <form action="{{ route('export.org.publication') }}" method="POST" class="mb-0 " id="exportForm">
                    @csrf
                    <input type="hidden" value="{{ $name }}" name="orgname" id="orgname">
                    <input type="hidden" value="{{ $id }}" name="orgid" id="orgid">
                    <button type="submit" class="btn btn-primary rounded-pill d-flex align-items-center">
                        <i class="fas fa-file-csv me-2" id="exportIcon"></i> Export CSV
                    </button>
                </form>

            </div>

            <div class="col-xl-2 mt-1">
                <label for="itemTypeSelector" class="form-label fw-semibold">Select Item Type</label>
                <select id="itemTypeSelector" class="form-select" onchange="updateCount()">
                    <option value="publication">Publication</option>
                    <option value="person">Person</option>
                </select>
            </div>
        </div>


        <!-- Card Section -->
        <div class="col-xl-3 mt-3">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-12">
                        <div class="card-body text-nowrap d-flex flex-column align-items-start">
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-list icon fa-2x text-primary me-3"></i>
                                <h5 class="card-title mb-0" id="itemCount">
                                    {{ $publicationcount }}
                                </h5>
                            </div>
                            <p class="mb-0">Total Item</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section id="publication" class="">
        <!-- Publications List -->
        <div id="publications-container" class="mt-4">
            <div class="card mb-4">
                <div class="row mt-4 mb-2 px-4">
                    <!-- Search and Filter -->
                    @php
                        $selectedPerPage = request('perPage', 10);
                        $searchQuery = request('search', '');
                    @endphp
                    <div class="col-md-4 mt-3 mt-md-0 d-flex align-items-center gap-2">
                        <span>Show</span>
                        <select class="form-select form-select-sm w-auto" id="page-size">
                            <option value="10" {{ $selectedPerPage == 10 ? 'selected' : '' }}>10</option>
                            <option value="25" {{ $selectedPerPage == 25 ? 'selected' : '' }}>25</option>
                            <option value="50" {{ $selectedPerPage == 50 ? 'selected' : '' }}>50</option>
                            <option value="100" {{ $selectedPerPage == 100 ? 'selected' : '' }}>100</option>
                        </select>
                        <span>entries</span>
                    </div>

                    @php
                        $fromYearSelected = request('from_year');
                        $toYearSelected = request('to_year');
                    @endphp


                    <div class="col-md-4 mt-3 mt-md-0 d-flex align-items-center gap-2">
                        <label for="from-year">From:</label>
                        <select id="from-year" class="form-select form-select-sm w-auto"></select>

                        <label for="to-year">To:</label>
                        <select id="to-year" class="form-select form-select-sm w-auto"></select>
                    </div>

                    {{-- <div class="col-2"></div> --}}
                    <div class="col-md-4 justify-content-end">
                        <div class="input-group mt-3 mt-md-0">
                            <input type="text" id="search-input" class="form-control"
                                placeholder="Search publications..." value="{{ $searchQuery }}">
                            <button class="btn btn-primary" type="button" id="search-button">
                                <i class="fas fa-search"></i> Search
                            </button>
                        </div>
                    </div>
                </div>

                @if (count($publications) > 0)
                    @foreach ($publications as $publication)
                        <div class="row px-4 pt-5">
                            <!-- Publication Details -->
                            <div class="col-md-10">
                                <span class="badge bg-primary text-white badge-sm">
                                    {{ $publication['publication_type'] ?? 'No Type' }}
                                </span>
                                <h5 class="card-title mb-1">{{ $publication['title'] ?? 'No Title' }}</h5>
                                <p class="text-muted mb-1">{{ $publication['authors'] ?? 'Unknown Authors' }}</p>
                                <p class="mb-1">
                                    <em>
                                        {{ $publication['journal'] ?? '' }}
                                        {!! $publication['date_issued']
                                            ? '<b>Year: </b>' . \Carbon\Carbon::parse($publication['date_issued'])->format('Y')
                                            : '' !!}
                                        {!! $publication['volume'] ? ', <b>Volume:</b> ' . $publication['volume'] : '' !!}
                                    </em>
                                </p>
                                @if (!empty($publication['doi']))
                                    <a href="https://doi.org/{{ $publication['doi'] }}" target="_blank"
                                        class="text-decoration-none">
                                        {{ $publication['doi'] }}
                                    </a>
                                @endif

                            </div>

                            <!-- Action Buttons -->
                            <div class="col-md-2 d-flex flex-column align-items-start justify-content-start">
                                <!-- Button group at the top -->
                                <div class="mb-5">
                                    <button type="button" class="btn btn-info btn-sm me-2"
                                        onclick="viewPublication('{{ $publication['uuid'] }}')">
                                        <i class="fas fa-eye"></i>
                                    </button>

                                    <button type="button" class="btn btn-danger btn-sm"
                                        onclick="confirmDeletePublication('{{ $publication['uuid'] }}');">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>

                                <div class="mb-5 d-flex align-items-center">
                                    @if ($publication['crossref_citation'] > 0)
                                        <div class="d-flex align-items-center me-3">
                                            <img src="{{ asset('assets/img/logo/crossref.png') }}" alt="Crossref"
                                                height="20" class="me-1">
                                            <span>{{ $publication['crossref_citation'] ?? 0 }}</span>
                                        </div>
                                    @endif

                                    @if ($publication['scopus_citation'] > 0)
                                        <div class="d-flex align-items-center">
                                            <img src="{{ asset('assets/img/logo/scopus.png') }}" alt="Scopus"
                                                height="20" class="me-1">
                                            <span>{{ $publication['scopus_citation'] ?? 0 }}</span>
                                        </div>
                                    @endif

                                    @php
                                        $unpaywall = $publication['unpaywall'] ?? 'closed';
                                        $upurl = $publication['upurl'] ?? null;
                                        $doi = $publication['doi'] ?? null;
                                        $icon = '<i class="fa fa-lock"></i>';
                                        $color = 'grey';

                                        if ($unpaywall === 'gold') {
                                            $color = '#FFC300';
                                        } elseif ($unpaywall === 'green') {
                                            $color = 'green';
                                        } elseif (in_array($unpaywall, ['hybrid', 'bronze'])) {
                                            $color = '#CD7F32';
                                        }

                                        // Safe HTML for DOI popover
                                        $doiUrl = 'https://doi.org/' . urlencode($doi);
                                        $doiLink = "<a href=\"{$doiUrl}\" target=\"_blank\" class=\"text-decoration-none\">{$doi}</a>";

                                    @endphp

                                    @if ($unpaywall !== 'closed' && !empty($upurl) && $upurl !== 'null' && $upurl !== 'undefined')
                                        <span class="ms-3 unpaywall-popover"
                                            style="color: {{ $color }}; cursor: pointer;" tabindex="0"
                                            role="button" data-bs-toggle="popover" data-bs-trigger="focus hover"
                                            data-bs-html="true"
                                            data-bs-content="<a href='{{ $upurl }}' target='_blank' style='color:black; text-decoration:underline;'>{{ $upurl }}</a>">
                                            {!! $icon !!}
                                        </span>
                                    @elseif (!empty($doi))
                                        <span class="ms-3 unpaywall-popover"
                                            style="color: {{ $color }}; cursor: pointer;" tabindex="0"
                                            role="button" data-bs-toggle="popover" data-bs-trigger="focus hover"
                                            data-bs-html="true" data-bs-content="{{ $doiLink }}">
                                            {!! $icon !!}
                                        </span>
                                    @endif

                                </div>

                            </div>

                        </div>
                        <hr>
                    @endforeach
                @else
                    <div class="alert alert-info mx-4 my-4">No publications found.</div>
                @endif

                <!-- Combined pagination info and links -->
                <div class="pagination-container px-4">
                    <div class="d-flex justify-content-between align-items-center pb-3 flex-wrap">
                        <!-- Pagination Information -->
                        <div class="pagination-info">
                            <p class="mb-0">
                                Showing {{ $publications->firstItem() ?? 0 }} to {{ $publications->lastItem() ?? 0 }} of
                                {{ $publications->total() }} entries
                                @if (request('search') | request('from_year') || (request('to_year') && $totalCount > $publications->total()))
                                    (filtered from {{ $publicationcount }} total entries)
                                @endif
                            </p>
                        </div>

                        <!-- Pagination Links -->
                        <div class="pagination-links">
                            {{ $publications->links('vendor.pagination.bootstrap-4') }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- View Publication Modal -->
        <div class="modal fade" id="viewPublicationModal" tabindex="-1" aria-labelledby="viewPublicationModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="viewPublicationModalLabel">Publication Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <!-- Publication details table -->
                        <table class="table table-borderless">
                            <thead>
                                <tr class="border-bottom">
                                    <th scope="col"><b>Fields</b></th>
                                    <th scope="col"><b>Details</b></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="border-bottom">
                                    <th>UUID</th>
                                    <td id="v_uuid"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Title</th>
                                    <td id="v_title"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Type</th>
                                    <td id="v_publication_type"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Abstract</th>
                                    <td id="v_abstract"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Authors</th>
                                    <td id="v_authors"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>SOPUS-AUTHOR-ID</th>
                                    <td id="v_scopus_author_id"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Journal</th>
                                    <td id="v_journal"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>DOI</th>
                                    <td id="v_doi"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>EID</th>
                                    <td id="v_eid"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Scopus Citation</th>
                                    <td id="v_scopus_citation"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>CrossRef Citation</th>
                                    <td id="v_crossref_citation"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Volume</th>
                                    <td id="v_volume"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>ISSN</th>
                                    <td id="v_issn"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>ISBN</th>
                                    <td id="v_isbn"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Date Issued</th>
                                    <td id="v_date_issued"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Sherpa URL</th>
                                    <td id="v_sherpa_url"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Unpaywall</th>
                                    <td id="v_unpaywall"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Metrics</th>
                                    <td id="v_metrics"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Delete Modal -->
        <div class="modal fade" id="deletePublicationModal" tabindex="-1" aria-labelledby="deletePublicationModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <p id="deletePublicationMessage">Are you sure you want to delete this publication?</p>
                    </div>
                    <div class="modal-footer">
                        <form id="deletePublicationForm" method="POST"
                            action="{{ route('publicationlist.delete', ['uuid' => '__UUID__']) }}">
                            @csrf
                            @method('DELETE')
                            <input type="hidden" name="publication_id" id="publication_id">
                            <button type="submit" class="btn btn-danger">Delete</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section id="person" class="d-none">
        <div class="row">
            <div class="col-12">
                <div class="card p-5 mt-3">
                    <!-- Added margin-top for space -->
                    <div id="DataTables_Table_0_wrapper"
                        class="dataTables_wrapper dt-bootstrap5 no-footer table-responsive">
                        <div class="row dt-row">
                            <div class="col-sm-12">
                                <table class="user-list table table-hover dataTable no-footer" id="DataTables_Table_0"
                                    aria-describedby="DataTables_Table_0_info">
                                    <thead>
                                        <tr>
                                            <th class="sorting sorting_asc text-nowrap col-5 px-2">Preferred name</th>
                                            <th class="sorting col-4 text-nowrap px-2">Main Affiliation</th>
                                            <th class="sorting col-4 text-nowrap px-2">Email</th>
                                            <th class="sorting col-4 text-nowrap px-2">Scopus Author ID</th>
                                            <th class="sorting col-4 text-nowrap px-2">GSID</th>
                                            <th class="sorting col-4 text-nowrap px-2">ORCID</th>
                                            <th class="sorting col-4 text-nowrap px-2">RID</th>
                                            <th class="sorting col-4 text-nowrap px-2">ACTION</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- View Modal -->
                        <div class="modal fade" id="viewPersonModal" tabindex="-1"
                            aria-labelledby="viewPersonModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg"> <!-- modal-lg for larger modal if needed -->
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="viewPersonModalLabel">Person Details</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        <!-- Person details table -->
                                        <table class="table table-borderless">
                                            <thead>
                                                <tr class="border-bottom">
                                                    <th scope="col"><b>Fields</b></th>
                                                    <th scope="col"><b>Details</b></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr id="row_preferred_name" class="border-bottom">
                                                    <th>Preferred name</th>
                                                    <td id="v_preferred_name"></td>
                                                </tr>
                                                <tr id="row_main_affiliation" class="border-bottom">
                                                    <th>Main Affiliation</th>
                                                    <a href="/orgunit/item/${row.department}" target="_self">${data}<td
                                                            id="v_main_affiliation"></td></a>
                                                </tr>
                                                <tr id="row_email" class="border-bottom">
                                                    <th>Email</th>
                                                    <td id="v_email"></td>
                                                </tr>
                                                <tr id="row_scopus_author_id" class="border-bottom">
                                                    <th>Scopus Author ID</th>
                                                    <td id="p_scopus_author_id"></td>
                                                </tr>
                                                <tr id="row_entity_type" class="border-bottom">
                                                    <th>Entity Type</th>
                                                    <td id="v_entity_type"></td>
                                                </tr>
                                                <tr id="row_gender" class="border-bottom">
                                                    <th>Gender</th>
                                                    <td id="v_gender"></td>
                                                </tr>
                                                <tr id="row_affiliation_id" class="border-bottom">
                                                    <th>Affiliation Id</th>
                                                    <td id="v_affiliation_id"></td>
                                                </tr>
                                                <tr id="row_job_title" class="border-bottom">
                                                    <th>Job Title</th>
                                                    <td id="v_job_title"></td>
                                                </tr>
                                                <tr id="row_gsid" class="border-bottom">
                                                    <th>GSID</th>
                                                    <td id="v_gsid"></td>
                                                </tr>
                                                <tr id="row_orcid" class="border-bottom">
                                                    <th>ORCID</th>
                                                    <td id="v_orcid"></td>
                                                </tr>
                                                <tr id="row_rid" class="border-bottom">
                                                    <th>RID</th>
                                                    <td id="v_rid"></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </div>

            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <!-- We will insert the person's name dynamically into the following paragraph -->
                            <p id="deleteMessage">Are you sure you want to delete this person?</p>
                        </div>
                        <div class="modal-footer">
                            <!-- Hidden form with delete button -->
                            <form id="deleteForm" method="POST"
                                action="{{ route('person.delete', ['uuid' => '__UUID__']) }}">
                                @csrf
                                @method('DELETE')
                                <!-- We'll store the person's id (uuid) here -->
                                <input type="hidden" name="person_id" id="person_id">
                                <button type="submit" class="btn btn-danger" id="deleteButton">Delete</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Empty State Message -->
    <div id="empty-state" class="text-center p-5 d-none">
        <div class="mb-4">
            <i class="fas fa-box-open text-muted" style="font-size: 5rem;"></i>
        </div>
        <h4 class="text-muted">No Data Available</h4>
        <p class="text-muted">There are no Data available in the database.</p>
    </div>

    <script>
        const publicationCount = {{ $publicationcount }};
        const personCount = {{ $personcount }};
        let emptyState = $('#empty-state');
        let publication = $('#publication');

        $(document).ready(function() {

            initUnpaywallPopovers();

            $('#page-size').change(function() {
                let pageSize = $(this).val();
                let currentParams = new URLSearchParams(window.location.search);

                currentParams.set('perPage', pageSize);
                currentParams.set('page', 1); // reset to first page

                window.location.href = '?' + currentParams.toString();
            });

            var personsRaw = @json($person);
            let dataTableContainer = $('#DataTables_Table_0');
            let publicationsRaw = @json($publications) || [];
            window.publicationsData = @json($publications->all());
            let recordsCount = publicationCount + personCount;
            if (personCount > 0) {
                var persons = personsRaw.map(function(person) {
                    return {
                        uuid: person.dspace_object_id,
                        preferred_name: person.preferred_name || '',
                        main_affiliation: person.main_affiliation || '',
                        email: person.email || '',
                        scopus_author_id: person.scopus_author_id || '',
                        entity_type: person.entity_type || '',
                        gender: person.gender || '',
                        affiliation_id: person.affiliation_id || '',
                        job_title: person.job_title || '',
                        department: person.department || '',
                        gsid: person.gsid || '',
                        orcid: person.orcid || '',
                        rid: person.rid || '',
                    };
                });
            }
            window.personsData = persons;
            $('#DataTables_Table_0').DataTable({
                data: persons,
                columns: [{
                        data: 'preferred_name',
                        name: 'Preferred name'
                    },
                    {
                        data: 'main_affiliation',
                        dept: 'department',
                        name: 'Main Affiliation',
                        render: function(data, type, row) {
                            return data && row.department ?
                                `<a href="/orgunit/item/${row.department}" target="_self">${data}</a>` :
                                '';
                        }

                    },
                    {
                        data: 'email',
                        name: 'Email'
                    },
                    {
                        data: 'scopus_author_id',
                        name: 'Scopus Author ID',
                        render: function(data, type, row) {
                            return data ?
                                `<a href="https://www.scopus.com/authid/detail.uri?authorId=${data}" target="_blank">${data}</a>` :
                                '';
                        }
                    },
                    {
                        data: 'gsid',
                        name: 'GSID'
                    },
                    {
                        data: 'orcid',
                        name: 'ORCID'
                    },
                    {
                        data: 'rid',
                        name: 'RID'
                    },

                    {
                        data: null,
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `
                                                                    <div class="d-flex justify-content-start">
                                                                        <button type="button" class="btn btn-info btn-sm me-2" onclick="viewperson('${row.uuid}');">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye font-medium-4">
                                                                                <path d="M1 12s1.5-7 11-7 11 7 11 7-1.5 7-11 7-11-7-11-7z"></path>
                                                                                <circle cx="12" cy="12" r="3"></circle>
                                                                            </svg>
                                                                        </button>
                                                                        <button type="button" class="btn btn-danger btn-sm" onclick="confirmPersonDelete('${row.uuid}', '${row.email}');">
                                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash font-medium-4">
                                                                                <polyline points="3 6 5 6 21 6"></polyline>
                                                                                <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                                                            </svg>
                                                                        </button>
                                                                    </div>`;
                        }
                    }
                ],
                pageLength: 10,
                scrollX: true
            });

            if (publicationCount === 0) {
                emptyState.removeClass("d-none"); // Show "No Data Available" message
                publication.addClass("d-none");
            }
            // Populate year dropdowns
            let minYear = {{ $minYear ?? 0 }};
            let maxYear = {{ $maxYear ?? 0 }};
            let selectedFrom = "{{ $fromYearSelected ?? 0 }}";
            let selectedTo = "{{ $toYearSelected ?? 0 }}";

            for (let year = minYear; year <= maxYear; year++) {
                $('#from-year').append(
                    `<option value="${year}" ${selectedFrom == year ? 'selected' : ''}>${year}</option>`
                );

                let isToSelected = (!selectedTo || selectedTo == 0) ?
                    (year == maxYear) :
                    (year == selectedTo);

                $('#to-year').append(
                    `<option value="${year}" ${isToSelected ? 'selected' : ''}>${year}</option>`
                );
            }

            // Handle dependent year filtering
            $('#from-year').change(function() {
                let fromYear = parseInt($(this).val());
                let toYear = parseInt($('#to-year').val());

                if (!isNaN(fromYear) && !isNaN(toYear) && fromYear > toYear) {
                    alert("'From' year should not be greater than 'To' year!");
                    $(this).prop("selectedIndex", 0); // Reset to first option
                    return; // Stop further execution
                }

                performSearch();
            });

            $('#to-year').change(function() {
                let toYear = parseInt($(this).val());
                let fromYear = parseInt($('#from-year').val());

                if (!isNaN(fromYear) && !isNaN(toYear) && toYear < fromYear) {
                    alert("'To' year should not be less than 'From' year!");
                    $(this).prop("selectedIndex", 0); // Reset to first option
                    return; // Stop further execution
                }

                performSearch();
            });

            $('#search-button').click(function() {
                performSearch();
            });

            $('#search-input').keypress(function(e) {
                if (e.which == 13) { // Enter key
                    performSearch();
                }
            });

            // Filter functionality
            $('#type-filter').change(function() {
                performSearch();
            });

            // Function to perform search
            function performSearch() {
                let searchQuery = $('#search-input').val();
                let typeFilter = $('#type-filter').val();
                let fromYear = parseInt($('#from-year').val());
                let toYear = parseInt($('#to-year').val());
                let pageSize = $('#page-size').val();

                if (!isNaN(fromYear) && !isNaN(toYear) && fromYear > toYear) {
                    alert("To Year must be greater than or equal to From Year");
                    return;
                }

                let params = new URLSearchParams();

                if (searchQuery) params.append('search', searchQuery);
                if (typeFilter && typeFilter !== 'all') params.append('type', typeFilter);
                if (fromYear) params.append('from_year', fromYear);
                if (toYear) params.append('to_year', toYear);
                if (pageSize) params.append('perPage', pageSize);

                params.set('page', 1);

                window.location.href = '?' + params.toString();
            }

            // Initialize popovers when page loads
            $(document).on('mouseenter', '.unpaywall-popover', function() {
                $(this).popover('show');
            });

            $(document).on('mouseleave', '.popover', function() {
                $(this).popover('hide');
            });

            // Hide all popovers on scroll to prevent sticky popovers
            $(window).on('scroll', function() {
                $('[data-bs-toggle="popover"]').popover('hide');
            });
        });

        // Updateing countAccording to select by user
        function updateCount() {
            let person = $('#person');
            const selected = document.getElementById('itemTypeSelector').value;
            const countDisplay = document.getElementById('itemCount');
            const exportForm = document.getElementById('exportForm'); // Changed to match form ID

            if (selected === 'publication') {
                countDisplay.innerText = publicationCount;
                person.addClass("d-none");
                publication.removeClass("d-none");
                exportForm.classList.remove("d-none");
                // console.log(publicationCount);
                if (publicationCount == 0) {
                    emptyState.removeClass("d-none"); // Show "No Data Available" message
                    publication.addClass("d-none");

                } else {
                    emptyState.addClass("d-none"); // Hide the message
                    publication.removeClass("d-none");
                }

            } else {
                countDisplay.innerText = personCount;
                person.removeClass("d-none");
                publication.addClass("d-none");
                exportForm.classList.add("d-none");
                if (personCount === 0) {
                    emptyState.removeClass("d-none"); // Show "No Data Available" message
                    person.addClass("d-none");
                } else {
                    emptyState.addClass("d-none"); // Hide the message
                    person.removeClass("d-none");
                }
            }
        }

        function viewperson(uuid) {
            // Find the person with the matching uuid
            var person = window.personsData.find(function(p) {
                return p.uuid === uuid;
            });

            if (person) {

                // Helper function to set or hide field
                function setField(rowId, fieldId, label, isLink = false, prefix = '', linkValue = '') {
                    if (label && label !== 'null' && label !== 'undefined') {
                        if (isLink) {
                            const href = prefix + (linkValue || label);
                            $(fieldId).html(`<a href="${href}" target="_blank">${label}</a>`);
                        } else {
                            $(fieldId).text(label);
                        }
                        $(rowId).show();
                    } else {
                        $(rowId).hide();
                    }
                }

                // Populate modal fields with person's details
                // Populate modal fields with person's details
                setField('#row_preferred_name', '#v_preferred_name', person.preferred_name);
                setField('#row_main_affiliation', '#v_main_affiliation', person.main_affiliation, true, '/orgunit/item/',
                    person.department);

                setField('#row_email', '#v_email', person.email);
                setField('#row_scopus_author_id', '#p_scopus_author_id', person.scopus_author_id, true,
                    "https://www.scopus.com/authid/detail.uri?authorId=");
                setField('#row_entity_type', '#v_entity_type', person.entity_type);
                setField('#row_gender', '#v_gender', person.gender);
                setField('#row_affiliation_id', '#v_affiliation_id', person.affiliation_id);
                setField('#row_job_title', '#v_job_title', person.job_title);
                setField('#row_gsid', '#v_gsid', person.gsid);
                setField('#row_orcid', '#v_orcid', person.orcid);
                setField('#row_rid', '#v_rid', person.rid);


                // Show the modal
                var myModal = new bootstrap.Modal(document.getElementById('viewPersonModal'));
                myModal.show();
            }
        }

        function confirmDelete(uuid, email) {
            var person = window.personsData.find(function(p) {
                return p.uuid === uuid;
            });

            if (person) {
                $('#deleteMessage').html("Are you sure you want to delete <b>" + person.preferred_name + "</b>?");
                $('#person_id').val(uuid);

                // Replace the placeholder __UUID__ in the form action
                var form = $('#deleteForm');
                var originalAction = form.attr('action'); // e.g., /person/delete/__UUID__
                var updatedAction = originalAction.replace('__UUID__', uuid);
                form.attr('action', updatedAction);

                // Debug: Log final URL
                console.log("Final delete URL:", updatedAction);

                // Show modal
                var deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
                deleteModal.show();
            }
        }

        // Initialize popovers properly
        function initUnpaywallPopovers() {
            $('[data-bs-toggle="popover"]').popover('dispose').popover({
                container: 'body',
                trigger: 'hover focus',
                html: true,
                delay: {
                    show: 150,
                    hide: 300
                },
                placement: 'auto'
            });
        }

        function viewPublication(uuid) {
            // Find the publication with the matching UUID
            if (!window.publicationsData || !Array.isArray(window.publicationsData)) {
                console.error('publicationsData is not available or not an array.');
                return;
            }

            var publication = window.publicationsData.find(function(p) {
                return p.uuid === uuid;
            });
            if (publication) {

                // console.log(publication);

                function setField(id, value, isLink = false, prefix = '') {

                    if (value && value !== 'null' && value !== 'undefined') {
                        if (isLink) {
                            $(id).html(`<a href="${prefix}${value}" target="_blank">${value}</a>`).parent().show();
                        } else {
                            $(id).text(value).parent().show();
                        }
                    } else {
                        $(id).parent().hide();
                    }
                }

                // abstract value
                function setAbstractField(id, value) {
                    if (value && value.trim() !== '' && value !== 'null' && value !== 'undefined') {
                        if (value.length > 150) {
                            let shortText = value.substring(0, 150) + "...";
                            let fullText = value;
                            let abstractHtml = `
            <span class="short-abstract">${shortText}</span>
            <span class="full-abstract" style="display: none;">${fullText}</span>
            <a href="#" class="read-more">Read More</a>
        `;
                            $(id).html(abstractHtml).parent().show();

                            // Toggle Read More / Read Less
                            $(id).find('.read-more').click(function(e) {
                                e.preventDefault();
                                let parent = $(this).parent();
                                parent.find('.short-abstract').toggle();
                                parent.find('.full-abstract').toggle();
                                $(this).text($(this).text() === "Read More" ? "Read Less" : "Read More");
                            });
                        } else {
                            $(id).text(value).parent().show();
                        }
                    } else {
                        $(id).parent().hide();
                    }
                }

                setField('#v_uuid', publication.uuid);
                setField('#v_publication_type', publication.publication_type);
                setField('#v_title', publication.title);
                setField('#v_authors', publication.authors);
                setAbstractField('#v_abstract', publication.abstract);
                setField('#v_scopus_author_id', publication.scopus_ids);
                setField('#v_journal', publication.journal);
                setField('#v_doi', publication.doi, true, 'https://doi.org/');
                setField('#v_scopus_citation', publication.scopus_citation);
                setField('#v_crossref_citation', publication.crossref_citation);
                setField('#v_eid', publication.eid, true, 'https://www.scopus.com/record/display.uri?eid=');
                setField('#v_volume', publication.volume);
                setField('#v_issn', publication.issn);
                setField('#v_isbn', publication.isbn);
                setField('#v_date_issued', publication.date_issued);
                setField('#v_sherpa_url', publication.sherpa_url, true);

                if (publication.doi && publication.doi !== 'null' && publication.doi !== 'undefined') {
                    let container = $('<div class="parent"></div>');

                    let altmetric = $('<div class="altmetric-embed"></div>')
                        .attr('data-hide-less-than', '1')
                        .attr('data-badge-type', 'donut')
                        .attr('data-doi', publication.doi.trim())
                        .css('display', 'inline-block');

                    let dimensions = $('<div class="__dimensions_badge_embed__"></div>')
                        .attr('data-hide-zero-citations', 'true')
                        .attr('data-style', 'small_circle')
                        .attr('data-doi', publication.doi.trim())
                        .css('display', 'inline-block');

                    container.append(altmetric).append(dimensions);
                    $('#v_metrics').html(container).closest('tr').show();

                    // ✅ FIX: Reload Altmetric script dynamically every time
                    $.getScript('https://d1bxh8uas1mnw7.cloudfront.net/assets/embed.js', function() {
                        if (typeof _altmetric_embed_init === 'function') {
                            _altmetric_embed_init();
                        }
                    });

                    // ✅ FIX: Reload Dimensions script dynamically every time
                    $.getScript('https://badge.dimensions.ai/badge.js', function() {
                        if (typeof __dimensions_embed === 'object' && typeof __dimensions_embed.addBadges ===
                            'function') {
                            __dimensions_embed.addBadges();
                        }
                    });

                } else {
                    $('#v_metrics').closest('tr').hide();
                }

                // Unpaywall logic
                let icon = '<i class="fa fa-lock"></i>';
                let color = 'grey'; // Default color
                let upurl = publication.upurl;

                if (publication.unpaywall) {
                    if (publication.unpaywall === 'gold') {
                        color = '#FFC300'; // Gold
                    } else if (publication.unpaywall === 'green') {
                        color = 'green';
                    } else if (publication.unpaywall === 'hybrid' || publication.unpaywall === 'bronze') {
                        color = '#CD7F32'; // Bronze
                    } else if (publication.unpaywall === 'closed') {
                        color = 'grey';
                    }
                }

                let unpaywallHtml = `<span style="color: ${color}; display: flex; align-items: center;">${icon}</span>`;

                if (publication.unpaywall !== 'closed' && upurl && upurl !== 'null' && upurl !== 'undefined') {
                    unpaywallHtml += `<br><a href="${upurl}" target="_blank">${upurl}</a>`;
                }

                if (publication.unpaywall || upurl) {
                    $('#v_unpaywall').html(unpaywallHtml).parent().show();
                } else {
                    $('#v_unpaywall').parent().hide();
                }

                // Show the modal
                var myModal = new bootstrap.Modal(document.getElementById('viewPublicationModal'));
                myModal.show();
            }
        }

        // Funcation for delete puvlication
        function confirmDeletePublication(uuid, title) {
            // Find the publication by uuid from your global publicationsData
            var publication = window.publicationsData.find(function(p) {
                return p.uuid === uuid;
            });

            if (publication) {
                if (publication) {
                    // Update the confirmation message
                    $('#deletePublicationMessage').html(
                        "Are you sure you want to delete <b>" + (publication.title || "this publication") + "</b>?"
                    );

                    // Set the hidden input value
                    $('#publication_id').val(uuid);

                    // Replace the UUID placeholder in the action URL
                    var form = $('#deletePublicationForm');
                    var actionTemplate = form.attr('action'); // should contain __UUID__
                    var updatedAction = actionTemplate.replace('__UUID__', uuid);
                    form.attr('action', updatedAction);

                    // Show the modal
                    var deleteModal = new bootstrap.Modal(document.getElementById('deletePublicationModal'));
                    deleteModal.show();
                }
            }
        }
    </script>


    </div>
@endsection
