@php
    $configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Processes List')

<!-- Vendor Styles -->
@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss'])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js'])
@endsection
<!-- DataTables Responsive Plugin from CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

@section('content')
    <div class="content-header row mb-3">
        <div class="col-12 d-flex align-items-center justify-content-between">
            <!-- Header Title -->
            <h2 class="content-header-title mb-0">
                Processes List
            </h2>

            <!-- Update Button -->
            <a href="{{ route('processes') }}" class="btn btn-primary rounded-pill d-flex align-items-center"
                id="updateButton">
                <i class="fas fa-refresh me-2" id="spinIcon"></i> Update
            </a>

            <script>
                document.getElementById('updateButton').addEventListener('click', function(event) {
                    event.preventDefault();

                    // Start the spinner
                    var spinIcon = document.getElementById('spinIcon');
                    spinIcon.classList.add('fa-spin');

                    // Perform the AJAX request
                    fetch("{{ route('processes') }}")
                        .then(response => response.json())
                        .then(data => {
                            spinIcon.classList.remove('fa-spin');

                            if (data.success) {
                                window.location.href = "{{ route('processes.index') }}";
                            } else {
                                console.log("Error:", data.error);
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            spinIcon.classList.remove('fa-spin');
                        });
                });
            </script>
        </div>
    </div>

    @if (isset($processes) && count($processes) > 0)
        <!-- Data Content - Only shown when processes exist -->
        <div class="col-xl-3">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-7">
                        <div class="card-body text-nowrap d-flex flex-column align-items-start">
                            <!-- File Icon with Space -->
                            <div class="d-flex align-items-center mb-2">
                                <i class="fa fa-cogs fa-2x me-3" style="color: rgb(76, 76, 209);"></i>
                                <!-- Number Text -->
                                <h5 class="card-title mb-0"> <span id="recordsTotal"></span></h5>
                            </div>
                            <!-- Total Publication Text Below Icon -->
                            <p class="mb-2">Total Processes</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card p-5 mt-3">
                    <!-- Added margin-top for space -->
                    <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                        <div class="row dt-row table-responsive">
                            <div class="col-sm-12">
                                <table class="user-list table table-hover dataTable" id="DataTables_Table_0"
                                    aria-describedby="DataTables_Table_0_info">
                                    <thead>
                                        <tr>
                                            <th class="sorting sorting_asc text-nowrap" tabindex="0"
                                                aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                                aria-sort="ascending">PROCESS ID</th>
                                            <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">NAME</th>
                                            <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">USER</th>
                                            <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">
                                                START TIME(UTC)
                                            </th>
                                            <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">
                                                FINISH TIME(UTC)
                                            </th>
                                            <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">STATUS
                                            </th>
                                            <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">
                                                ACTION</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Dynamic rows generated by DataTables server-side processing -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        <!-- Empty State - Only shown when no processes exist -->
        <div id="empty-state" class="text-center p-5">
            <div class="mb-4">
                <i class="fas fa-box-open text-muted" style="font-size: 5rem;"></i>
            </div>
            <h4 class="text-muted">No Data Available</h4>
            <p class="text-muted">There are currently no processes to display.</p>
        </div>
    @endif

    <!--View Modal -->
    <div class="modal fade" id="backDropModal" tabindex="-1">
        <div class="modal-dialog" style="max-width: 800px;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="backDropModalTitle">Processes data</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p id="deleteMessage">Are you sure you want to delete this process?</p>
                </div>
                <div class="modal-footer">
                    <!-- Hidden form with delete button -->
                    <form id="deleteForm" method="POST"action="{{ route('process.delete', ['id' => '__ID__']) }}">
                        @csrf
                        @method('DELETE')
                        <input type="hidden" name="process_id" id="process_id">
                        <button type="submit" class="btn btn-danger" id="deleteButton">Delete</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            // Pass the PHP variable to JavaScript
            @if (isset($processes) && count($processes) > 0)
                var processes = @json($processes); // Convert PHP array to JSON for JavaScript
                // console.log(processes);


                $('#recordsTotal').text(processes.length);

                $('#DataTables_Table_0').DataTable({
                    data: processes, // Use the data directly
                    columns: [{
                            data: 'process_id',
                            name: 'id'
                        },
                        {
                            data: 'script',
                            name: 'script'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'start_time',
                            name: 'start_time'
                        },
                        {
                            data: 'finished_time',
                            name: 'finished_time'
                        },
                        {
                            data: 'status',
                            name: 'status'
                        },
                        {
                            data: null,
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row) {
                                return `
                                    <div class="d-flex justify-content-start">
                                      <a href="#" class="btn btn-info btn-sm me-2" onclick="viewProcess('${row.process_id}');" data-bs-toggle="modal" data-bs-target="#backDropModal">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye font-medium-4">
                                                <path d="M1 12s1.5-7 11-7 11 7 11 7-1.5 7-11 7-11-7-11-7z"></path>
                                                <circle cx="12" cy="12" r="3"></circle>
                                            </svg>
                                        </a>
                                        <a href="#" class="btn btn-danger btn-sm waves-effect waves-float waves-light" onclick="confirmDelete('${row.process_id}');">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash font-medium-4">
                                                <polyline points="3 6 5 6 21 6"></polyline>
                                                <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                            </svg>
                                        </a>
                                    </div>`;
                            }
                        } // Action buttons
                    ],
                    scrollX: true,
                    order: [
                        [0, 'desc']
                    ],
                    pageLength: 10, // Default page length
                    autoWidth: false,
                });
            @endif
        });


        // function for view user
        function viewProcess(processId) {
            @if (isset($processes) && count($processes) > 0)
                var processes = @json($processes); // Convert PHP array to JSON for JavaScript
            @else
                var processes = []; // Fallback to an empty array if `$processes` is not defined
            @endif
            // Find the selected process based on `processId`
            const selectedProcess = processes.find(process => process.process_id == processId);

            if (selectedProcess) {
                const fileNames = selectedProcess.file_name.split(';');
                const fileIds = selectedProcess.file_bitstream_id.split(';');
                // Construct the Output Files section dynamically
                const outputFilesHtml = fileNames
                    .map((fileName, index) =>
                        `<div><a href="https://d8.irins.org/bitstreams/${fileIds[index]}/download">${fileName}</a></div>`
                    )
                    .join('');
                // Populate the modal body with dynamic content
                $('#backDropModal').find('.modal-body').html(`
                <table class="table">
                <thead>
                    <tr>
                        <th scope="col"><b>Fields</b></th>
                        <th scope="col"><b>Details</b></th>
                    </tr>
                </thead>
                <tbody>
                    <tr >
                        <th>Process ID:</th>
                        <td>${selectedProcess.process_id}</td>
                    </tr>
                    <tr>
                        <th>Name:</th>
                        <td>${selectedProcess.script}</td>
                    </tr>
                    <tr>
                        <th>User:</th>
                        <td>${selectedProcess.name}</td>
                    </tr>
                    <tr>
                        <th>Arguments:</th>
                        <td>${selectedProcess.parameters}</td>
                    </tr>
                    <tr>
                        <th>Output Files:</th>
                        <td>${outputFilesHtml}</td>
                    </tr>
                    <tr>
                        <th>Start Time (UTC):</th>
                        <td>${new Date(selectedProcess.start_time).toLocaleString()}</td>
                    </tr>
                    <tr>
                        <th>Finish Time (UTC):</th>
                        <td>${selectedProcess.finished_time ? new Date(selectedProcess.finished_time).toLocaleString() : "N/A"}</td>
                    </tr>
                    <tr>
                        <th>Status:</th>
                        <td>${selectedProcess.status}</td>
                    </tr>
                </tbody>
            </table>
        `);
                // Show the modal (Bootstrap auto-handles this if the attributes are correct)
                $('#backDropModal').modal('show');
            } else {
                alert('Process not found!');
            }
        }

        // function confirmDelete(processId) {
        //     @if (isset($processes) && count($processes) > 0)
        //         var processes = @json($processes); // Convert PHP array to JSON for JavaScript
        //     @else
        //         var processes = []; // Fallback to an empty array if `$processes` is not defined
        //     @endif
        //     // Find the selected process based on `processId`
        //     const selectedProcess = processes.find(process => process.process_id == processId);
        //     if (selectedProcess) {
        //         // Update the modal message with the selected process ID
        //         document.getElementById('deleteMessage').innerText =
        //             `Are you sure you want to delete process with ID: ${processId}?`;
        //         // Show the modal
        //         const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
        //         deleteModal.show();

        //         // Set the form action and pass processId
        //         document.getElementById('deleteButton').onclick = function() {
        //             document.getElementById('process_id').value = processId;
        //             document.getElementById('deleteForm').action = `/process/delete/${processId}`;
        //             document.getElementById('deleteForm').submit();
        //         };   
        //     } else {
        //         alert('Process not found!');
        //     }
        // }

        function confirmDelete(processId) {
            @if (isset($processes) && count($processes) > 0)
                var processes = @json($processes); // Convert PHP array to JSON for JavaScript
            @else
                var processes = []; // Fallback to an empty array if `$processes` is not defined
            @endif
            // Find the selected process based on `processId`
            const selectedProcess = processes.find(process => process.process_id == processId);

            if (selectedProcess) {
                // Update modal message
                document.getElementById('deleteMessage').innerText =
                    `Are you sure you want to delete process with ID: ${processId}?`;

                // Show modal
                const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
                deleteModal.show();

                // Set form action dynamically
                document.getElementById('deleteButton').onclick = function() {
                    document.getElementById('process_id').value = processId;

                    const form = document.getElementById('deleteForm');
                    const originalAction = form.getAttribute('action');
                    const updatedAction = originalAction.replace('__ID__', processId);

                    form.setAttribute('action', updatedAction);
                    form.submit();
                };
            } else {
                alert('Process not found!');
            }
        }
    </script>

@endsection
