<?php

use App\Http\Controllers\authentications\AuthenticationController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\pages\HomePage;
use App\Http\Controllers\pages\CollectionController;
use App\Http\Controllers\pages\CommunitiesController;
use App\Http\Controllers\pages\Community2CollectionController;
use App\Http\Controllers\pages\DataIntegrationController;
use App\Http\Controllers\pages\DepartmentController;
use App\Http\Controllers\pages\EditmetadataController;
use App\Http\Controllers\pages\EpersonController;
use App\Http\Controllers\pages\FacultyProfileController;
use App\Http\Controllers\pages\ImportExportController;
use App\Http\Controllers\pages\OrgUnitController;
use App\Http\Controllers\pages\OrgUnitItemController;
use App\Http\Controllers\pages\Patentcontroller;
use App\Http\Controllers\pages\PersonsController;
use App\Http\Controllers\pages\ProcessesController;
use App\Http\Controllers\pages\PublicationsController;
use App\Http\Controllers\pages\PersonStatisticsController;
use App\Http\Controllers\pages\RegistriesController;

// // Main Page Route
Route::match(['get', 'post'], '/', [AuthenticationController::class, 'index'])->name('auth-login-basic');
Route::get('/dashboard', [HomePage::class, 'index'])->name('dashboard');
Route::get('/dashboard_json', [HomePage::class, 'totalCount'])->name('dashboard_json');
Route::post('/logout', [AuthenticationController::class, 'logout'])->name('logout');
Route::middleware('check.api')->group(function () {
    // Community route
    Route::get('/community', [CommunitiesController::class, 'index'])->name('community.index');
    Route::post('/community/add', [CommunitiesController::class, 'addCommunity'])->name('community.add');
    Route::delete('/community/delete/{id}', [CommunitiesController::class, 'delete'])->name('community.delete');
    Route::post('/community/edit', [CommunitiesController::class, 'editCommunity'])->name('community.edit');

    // Collection route
    Route::get('/collection/{id}', [CollectionController::class, 'index'])->name('collection.index');
    Route::post('/collection/add', [CollectionController::class, 'addCollection'])->name('collection.add');
    Route::delete('/collection/delete/{id}', [CollectionController::class, 'deleteCollection'])->name('collection.delete');
    Route::post('/collection/edit', [CollectionController::class, 'editCollection'])->name('collection.edit');

    // Sub Community route
    Route::post('/subcommunity/add', [CollectionController::class, 'addSubCommunity'])->name('subcommunity.add');
    Route::post('/subcommunity/edit', [CollectionController::class, 'editSubCommunity'])->name('subCommunity.edit');
    Route::delete('/subcommunity/delete/{id}', [CollectionController::class, 'deleteSubCommunity'])->name('subcommunity.delete');

    // Publications Route form Collection to Item
    Route::get('/publication/{id}/{communityid}', [PublicationsController::class, 'displaypublications'])->name('publications.index');
    Route::get('/publications/data', [PublicationsController::class, 'getPublicationsData'])->name('publications.data');
    Route::delete('/publication/delete/{uuid}', [PublicationsController::class, 'delete'])->name('publicationlist.delete');

    // Pubications route for Sidebar
    Route::get('/publications', [PublicationsController::class, 'index'])->name('publicationlist.index');
    Route::get('/publications/update', [PublicationsController::class, 'publicationlistupdate'])->name('publicationlist.update');

    // Patents 
    Route::get('/patent/data/{collectionId}', [Patentcontroller::class, 'getPatentData'])->name('patent.data');
    Route::get('/patent/{id}/{communityid}', [Patentcontroller::class, 'index'])->name('patent.index');

    // Eperson/Admin routes 
    Route::get('/eperson', [EpersonController::class, 'index'])->name('eperson.index');
    Route::get('/epersons', [EpersonController::class, 'eperson'])->name('epersons');
    Route::post('/eperson/{uuid}', [EpersonController::class, 'view'])->name('eperson.view');
    Route::delete('eperson/delete/{id}', [EpersonController::class, 'delete'])->name('eperson.delete');

    // Process route
    Route::get('/process', [ProcessesController::class, 'index'])->name('processes.index');
    Route::get('/processes', [ProcessesController::class, 'process'])->name('processes');
    Route::delete('/process/delete/{id}', [ProcessesController::class, 'delete'])->name('process.delete');

    // Edit metadata
    Route::get('/editmetadata', [EditmetadataController::class, 'index'])->name('editmetadata');
    Route::get('/get-metadata/{metadataFieldId}', [EditmetadataController::class, 'getMetadata'])->name('getMetadata');
    Route::post('/save-metadata', [EditmetadataController::class, 'saveMetadata'])->name('save.metadata');

    // Data Integartion
    Route::get('/data-integration', [DataIntegrationController::class, 'index'])->name('data-integration.index');
    Route::post('/data-sherpa-url', [DataIntegrationController::class, 'sherpaUrl'])->name('data-inte-sherpaUrl');
    Route::post('/data-inte-crossref-citation', [DataIntegrationController::class, 'crossRefCiatation'])->name('data-inte-crossref-citation');
    Route::post('/data-inte-unpaywall', [DataIntegrationController::class, 'unpaywall'])->name('data-inte-unpaywall');
    // Route::post('/data-inte-import-scopus-citation', [DataIntegrationController::class, 'importScopusCitation'])->name('data-inte-import-scopus-citation');
    Route::post('/data-inte-update-scopus-citation', [DataIntegrationController::class, 'updateScopusCitation'])->name('data-inte-update-scopus-citation');
    Route::post('/update-solr-index', [DataIntegrationController::class, 'updateSolorIndex'])->name('update.solr.index');
    Route::post('/update-h-index', [DataIntegrationController::class, 'updateH_Index'])->name('update.hindex');
    Route::post('/update-citation', [DataIntegrationController::class, 'updateCitation'])->name('update.citation');
    Route::post('/update-co-author', [DataIntegrationController::class, 'updateCoauthor'])->name('update.coauthor');
    Route::post('/update-documentes', [DataIntegrationController::class, 'updateDocumentes'])->name('update.documentes');
    Route::post('/update-cited', [DataIntegrationController::class, 'updateCited'])->name('update.cited');
    Route::post('/map-person-orgunit', [DataIntegrationController::class, 'mapPersonwithDepartment'])->name('mapPersonwithDept');
    Route::post('/map-publication-person-scop', [DataIntegrationController::class, 'mapPublicationwithPersonScop'])->name('mapPubwithPersonScopusId');
    Route::post('/map-publication-person-res', [DataIntegrationController::class, 'mapPublicationwithPersonRes'])->name('mapPubwithPersonResearchId');

    // Persons Route For Sidebar
    Route::get('/persons', [PersonsController::class, 'displayallpersons'])->name('personslist.index');

    // Person Route form Collection to Item
    Route::get('/person/{id}/{communityid}', [PersonsController::class, 'index'])->name('persons.index');
    Route::delete('/person/delete/{uuid}', [PersonsController::class, 'delete'])->name('person.delete');

    // Orgunit Item list
    Route::get('/orgunit/item/{id}', [OrgUnitItemController::class, 'index'])->name('orgunitlist.index');
    Route::post('/export-publication', [OrgUnitItemController::class, 'exportPublication'])->name('export.org.publication');

    // Orgunit Route from collection to Item
    Route::get('/orgunit/{id}/{communityid}', [OrgUnitController::class, 'index'])->name('orgunit.index');
    Route::delete('/orgunit/delete/{uuid}', [OrgUnitController::class, 'delete'])->name('orgunit.delete');
    Route::post('/orgunit/edit', [OrgUnitController::class, 'editOrgUnit'])->name('orgunit.edit');

    // Edit collection to community
    Route::get('/community2collection', [Community2CollectionController::class, 'index'])->name('community2collection.index');
    Route::post('/submit-community2collection', [Community2CollectionController::class, 'store'])->name('community2collection.store');

    // regisries controller.
    Route::get('/registries', [RegistriesController::class, 'index'])->name('registries');
    Route::post('/metadataregistry/add', [RegistriesController::class, 'addMetadataRegistry'])->name('addmetadataregistry');
    Route::delete('/metadataregistry/delete/{id}', [RegistriesController::class, 'deleteMetadataRegistry'])->name('metadataregistry.delete');
    Route::post('/metadataregistry/update', [RegistriesController::class, 'updateMetadataRegistry'])->name('metadata.update');

    // Metadata Schema
    Route::get('/registries/{namespace}', [RegistriesController::class, 'showMetadataSchema'])->name('metadata.schema');
    Route::post('/addMetadataSchema/add', [RegistriesController::class, 'addMetadataSchema'])->name('addMetadataSchema');
    Route::delete('/registries/delete/{id}', [RegistriesController::class, 'deleteMetadataSchema'])->name('metadataSchema.data');
    Route::post('/registries/update', [RegistriesController::class, 'updateMetadataSchema'])->name('metadata.update.data');

    // Import Export
    Route::post('/export-metadata', [ImportExportController::class, 'exportMetadata'])->name('export.metadata');
    Route::get('/download-status/{token}', [ImportExportController::class, 'checkStatus'])->name('check.downloadStatus');
    // Route::get('/export-org', [ImportExportController::class, 'exportFilteredMetadata'])->name('export.metadataorg');

    // Departmetns
    Route::get('/departments', [DepartmentController::class, 'index'])->name('departments.index');
    Route::get('/departments/data', [DepartmentController::class, 'getDepartments'])->name('departments.data');
    Route::get('/departments/update', [DepartmentController::class, 'updateData'])->name('departments.update');
    
    
    // Faculty/Profile
    Route::get('/facultyprofile/{profileid}', [FacultyProfileController::class, 'index'])->name('profile.index');
    Route::get('/faculty/profile/{uuid}/publications', [FacultyProfileController::class, 'getPublications'])->name('faculty.profile.publications');
    
    // Faculty Publications Counts
    Route::get('/faculty-publications-statestic', [PersonStatisticsController::class, 'index'])->name('faculty-publication-statestic.index');
    Route::get('/faculty-publications-statestic/data', [PersonStatisticsController::class, 'getPersonStatestic'])->name('faculty-publications-statestic.data');
    Route::get('/faculty-publications-statestic/update', [PersonStatisticsController::class, 'updateData'])->name('faculty-publications-statestic.update');
});
