<?php
$configData = Helper::appClasses();
?>




<?php $__env->startSection('title', 'Metadata Schema - Details'); ?>

<?php $__env->startSection('vendor-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')('resources/assets/vendor/scss/pages/app-logistics-dashboard.scss'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')('resources/assets/js/app-logistics-dashboard.js'); ?>
<?php $__env->stopSection(); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<?php $__env->startSection('content'); ?>

    <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('registries')); ?>">Registries</a>
                </li>

                <li class="breadcrumb-item active">
                    Metadata Schema
                </li>
            </ol>
        </nav>
<div class="col-12 d-flex align-items-center justify-content-between">
    
    <h2>Metadata Schema: "<?php echo e($namespace); ?>"</h2>

</div>
<hr>
<p>This is the metadata schema for "<?php echo e($fullNamespaceUrl); ?>"</p>

<div class="card mt-3 p-4">
    <form id="createMetadataForm" novalidate method="POST" action="<?php echo e(route('addMetadataSchema')); ?>">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="schemaId" id="modalSchemaId">

        <!-- Element and Qualifier Fields -->
        <div class="row g-3 mb-3">
            <!-- Element Field -->
            <div class="col-md-6">
                <label for="element" class="form-label">Element <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="element" name="element" required>
                <div class="invalid-feedback">
                    This field is required.
                </div>
            </div>

            <!-- Qualifier Field -->
            <div class="col-md-6">
                <label for="qualifier" class="form-label">Qualifier</label>
                <input type="text" class="form-control" id="qualifier" name="qualifier">
            </div>
        </div>

        <!-- Scope Note Field -->
        <div class="mb-3">
            <label for="scopeNote" class="form-label">Scope Note</label>
            <textarea class="form-control" id="scopeNote" name="scopeNote" rows="3"></textarea>
        </div>

        <!-- Buttons -->
        <div class="d-flex justify-content-end gap-2">
            <button type="reset" class="btn btn-secondary">Reset</button>
            <button type="submit" class="btn btn-primary">Save</button>
        </div>
    </form>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p id="deleteMessage">Are you sure you want to delete?</p>
            </div>
            <div class="modal-footer">
                <!-- <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="deleteButton">Delete</button> -->
                <form id="deleteForm" method="POST" action="<?php echo e(route('metadataSchema.data', ['id' => '__ID__'])); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <input type="hidden" name="metadata_id" id="metadata_id">
                    <button type="submit" class="btn btn-danger" id="deleteButton">Delete</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </form>

            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editMetadataModal" tabindex="-1" aria-labelledby="editMetadataModalLabel"
    aria-hidden="true">
    <div class="modal-dialog">
        <form method="POST" action="<?php echo e(route('metadata.update.data')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="metadata_field_id" id="edit_metadata_field_id">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Metadata Field</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Element</label>
                        <input type="text" class="form-control" name="element" id="edit_element" required>
                    </div>
                    <div class="mb-3">
                        <label>Qualifier</label>
                        <input type="text" class="form-control" name="qualifier" id="edit_qualifier">
                    </div>
                    <div class="mb-3">
                        <label>Scope Note</label>
                        <textarea class="form-control" name="scope_note" id="edit_scope_note" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>




<script>
    // Bootstrap validation
    (function() {
        const form = document.getElementById('createMetadataForm');
        form.addEventListener('submit', function(event) {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    })();

   

    function confirmDelete(metadataID, namespace, name) {
        if (metadataID) {
            // Set confirmation message
            document.getElementById('deleteMessage').innerText =
                `Are you sure you want to delete metadata with Name: ${name} and Namespace: ${namespace}?`;

            // Show modal
            const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
            deleteModal.show();

            // Setup delete button click handler
            document.getElementById('deleteButton').onclick = function() {
                const form = document.getElementById('deleteForm');
                const routeTemplate = form.getAttribute('action'); // e.g., "/metadataregistry/delete/__ID__"
                const finalRoute = routeTemplate.replace('__ID__', metadataID);

                // Set actual form action and hidden input
                form.setAttribute('action', finalRoute);
                document.getElementById('metadata_id').value = metadataID;

                form.submit();
            };
        } else {
            alert('Metadata not found!');
        }
    }


    function editMetadata(id, field_name, scope_note, element, qualifier) {
        // console.log("Element:", element); // Debug
        // console.log("Qualifier:", qualifier); // Debug


        document.getElementById('edit_metadata_field_id').value = id;
        document.getElementById('edit_element').value = element;
        document.getElementById('edit_qualifier').value = qualifier;
        document.getElementById('edit_scope_note').value = scope_note;

        const modal = new bootstrap.Modal(document.getElementById('editMetadataModal'));
        modal.show();
    }
    document.addEventListener('DOMContentLoaded', function() {
        let metadata = <?php echo json_encode($metadata, 15, 512) ?>;
        const schemaId = <?php echo json_encode($schemaId, 15, 512) ?>;
        document.getElementById('modalSchemaId').value = schemaId;

        if (Array.isArray(metadata) && metadata.length > 0) {
            $('#DataTables_Table_0').DataTable({
                data: metadata,
                columns: [{
                        data: 'metadata_field_id',
                        title: 'ID'
                    },
                    {
                        data: 'field_name',
                        title: 'NAMESPACE'
                    },
                    {
                        data: 'scope_note',
                        title: 'SCOPE NOTE'
                    },
                    {
                        data: null,
                        title: 'Action',
                        orderable: false,
                        render: function(data, type, row) {
                            return `
                                    <div class="d-flex justify-content-start">

                                        <button type="button" class="btn btn-warning btn-sm me-2" onclick="editMetadata(${row.metadata_field_id}, '${row.field_name}', '${row.scope_note}', '${row.element ?? ''}', '${row.qualifier ?? ''}');">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-danger btn-sm" onclick="confirmDelete(${row.metadata_field_id}, '${row.field_name}', '${row.scope_note}');">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                    `;
                        }
                    }
                ],
                order: [
                    [0, 'asc']
                ],
                pageLength: 10,
                scrollX: true
            });
        } else {
            console.error("No data found in metadata");
        }
    });
</script>


<div class="row">
    <div class="col-12">
        <div class="card mt-3 p-4">
            <!-- Added margin-top for space -->
            <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                <div class="row dt-row table-responsive">
                    <div class="col-sm-12">
                        <table class="user-list table table-hover dataTable" id="DataTables_Table_0"
                            aria-describedby="DataTables_Table_0_info">
                           
                            <tbody>
                                <!-- Dynamic rows generated by DataTables server-side processing -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Admin\Documents\dspace_dash\resources\views/content/pages/schema-details.blade.php ENDPATH**/ ?>