<?php
    $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Admin List'); ?>

<?php $__env->startSection('content'); ?>

<?php $__env->startSection('title', 'eCommerce Dashboard - Apps'); ?>

<?php $__env->startSection('vendor-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js']); ?>
<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<?php $__env->startSection('content'); ?>

    <div id="modal-container"></div>

    <div id="modal-container">
        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="deleteMessage">
                        Are you sure you want to delete this record?
                    </div>
                    <form id="deleteForm" method="POST" action="<?php echo e(route('eperson.delete', ['id' => '__ID__'])); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <div class="modal-footer">
                            <input type="hidden" name="eperson_id" id="eperson_id">
                            <button type="submit" class="btn btn-danger" id="confirmDeleteButton">Delete</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="content-header row">
        <h2>Admin
            <!-- Update Button -->
            <a href="<?php echo e(route('epersons')); ?>"
                class="btn btn-primary rounded-pill d-flex align-items-center float-end mt-2 me-2" id="updateButton">
                <i class="fas fa-refresh me-2" id="spinIcon"></i> Update
            </a>
        </h2>
        <script>
            document.getElementById('updateButton').addEventListener('click', function(event) {
                event.preventDefault();

                // Start the spinner
                var spinIcon = document.getElementById('spinIcon');
                spinIcon.classList.add('fa-spin');

                // Perform the AJAX request
                fetch("<?php echo e(route('epersons')); ?>")
                    .then(response => response.json())
                    .then(data => {
                        spinIcon.classList.remove('fa-spin');

                        if (data.success) {
                            window.location.href = "<?php echo e(route('eperson.index')); ?>";
                        } else {
                            console.log("Error:", data.error);
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        spinIcon.classList.remove('fa-spin');
                    });
            });
        </script>

        <!-- Empty state content -->
        <div id="empty-state" class="text-center p-5 d-none">
            <div class="mb-4">
                <i class="fas fa-box-open text-muted" style="font-size: 5rem;"></i>
            </div>
            <h4 class="text-muted">No Data Available</h4>
            <p class="text-muted">There are currently no eperson records to display.</p>
        </div>

        <!-- Space below the row -->
        <div class="" id="stats-row" style="display: none;">
            <div class="col-lg-3 col-sm-8">
                <div class="card">
                    <div class="d-flex align-items-end row">
                        <div class="col-7">
                            <div class="card-body text-nowrap d-flex flex-column align-items-start">
                                <!-- File Icon with Space -->
                                <div class="d-flex align-items-center mb-2">
                                    <i class="fa fa-user-shield fa-2x me-3" style="color: rgb(76, 76, 209);"></i>
                                    <!-- Number Text -->
                                    <h5 class="card-title mb-0"><span id="recordsTotal"></span></h5>
                                </div>
                                <!-- Total Publication Text Below Icon -->
                                <p class="mb-2">Total Admin</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <!-- Table content -->
    <div id="table-container" class="row" style="display: none;">
        <div class="col-12">
            <div class="card p-5 mt-5">
                <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                    <div class="row dt-row">
                        <div class="col-sm-12">
                            <table class="user-list table table-hover dataTable no-footer" id="DataTables_Table_0"
                                aria-describedby="DataTables_Table_0_info">
                                <thead>
                                    <tr>
                                        <th class="sorting sorting_asc" tabindex="0" aria-controls="DataTables_Table_0"
                                            rowspan="1" colspan="1" aria-sort="ascending">ID
                                        </th>
                                        <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                            colspan="1">Name</th>
                                        <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                            colspan="1">Email</th>
                                        <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                            colspan="1">Role</th>
                                        <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1"
                                            colspan="1">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Table body content will be populated dynamically -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function viewEperson(uuid) {
            $.ajax({
                url: `/eperson/${uuid}`,
                type: 'POST',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content') // CSRF token
                },
                success: function(response) {
                    // console.log(response);
                    if (response.html) {
                        $('#modal-container').html(response.html); // Correctly inject HTML content
                        $('#viewModal').modal('show'); // Show modal
                    } else {
                        alert('No details found.');
                    }
                },
                error: function(xhr, status, error) {
                    alert('Failed to fetch details: ' + error);
                }
            });
        }

        function confirmDelete(uuid, email) {
            <?php if(isset($eperson)): ?>
                var ePersons = <?php echo json_encode($eperson, 15, 512) ?>; // Convert PHP array to JSON
            <?php else: ?>
                var ePersons = [];
            <?php endif; ?>

            const selectedEPerson = ePersons.find(ePerson => ePerson.uuid === uuid);

            if (selectedEPerson) {
                document.getElementById('deleteMessage').innerText =
                    `Are you sure you want to delete ePerson with Email: ${email}?`;

                const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
                deleteModal.show();

                // Replace the placeholder in the action with the actual UUID
                const form = document.getElementById('deleteForm');
                const originalAction = form.getAttribute('action');
                const newAction = originalAction.replace('__ID__', uuid);
                form.setAttribute('action', newAction);

                // Set hidden input
                document.getElementById('eperson_id').value = uuid;

                // Optional: Reset action after modal is hidden to avoid old IDs sticking around
                document.getElementById('deleteModal').addEventListener('hidden.bs.modal', function() {
                    form.setAttribute('action', originalAction); // Reset back to original with __ID__
                });
            } else {
                alert('ePerson not found!');
                console.error('No matching ePerson found in the array.');
            }
        }


        $(document).ready(function() {
            // Pass the PHP variable to JavaScript
            <?php if(isset($eperson)): ?>
                var epersons = <?php echo json_encode($eperson, 15, 512) ?>;
            <?php else: ?>
                var epersons = []; // Fallback to an empty array if $eperson is not defined
            <?php endif; ?>

            // Update the records count
            $('#recordsTotal').text(epersons.length);

            // Hide loading indicators or spinners if you have any
            // This ensures content doesn't show until we decide what to display

            // Check if there's data available
            if (!epersons || epersons.length === 0) {
                // Show empty state and hide the table container
                $('#empty-state').removeClass('d-none');
                $('#table-container').hide();
                $('#stats-row').hide();
            } else {
                // Show table and hide empty state
                $('#empty-state').addClass('d-none');
                $('#table-container').show();
                $('#stats-row').show();

                // Initialize DataTable with data
                $('#DataTables_Table_0').DataTable({
                    data: epersons,
                    columns: [{
                            data: 'uuid',
                            name: 'uuid',
                        },
                        {
                            data: 'concatenated_values',
                            name: 'concatenated_values',
                        },
                        {
                            data: 'email',
                            name: 'email',
                        },
                        {
                            data: 'name',
                            name: 'name',
                        },
                        {
                            data: null,
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row) {
                                return `
                                    <div class="d-flex justify-content-start">
                                        <button type="button" class="btn btn-info btn-sm me-2" onclick="viewEperson('${row.uuid}');">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye font-medium-4">
                                                <path d="M1 12s1.5-7 11-7 11 7 11 7-1.5 7-11 7-11-7-11-7z"></path>
                                                <circle cx="12" cy="12" r="3"></circle>
                                            </svg>
                                        </button>
                                    
                                        <a href="#" class="btn btn-danger btn-sm waves-effect waves-float waves-light" onclick="confirmDelete('${row.uuid}', '${row.email}');">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash font-medium-4">
                                                <polyline points="3 6 5 6 21 6"></polyline>
                                                <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                            </svg>
                                        </a>
                                    </div>`;
                            }
                        }
                    ],
                    pageLength: 10,
                    scrollX: true
                });
            }
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Admin\Documents\dspace_dash\resources\views/content/pages/eperson.blade.php ENDPATH**/ ?>