<?php
    $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Faculty/Scientist List'); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js']); ?>
<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<?php $__env->startSection('content'); ?>
    <div class="content-header row mb-3">
        <div class="col-12 d-flex align-items-center justify-content-between">
            <!-- Header Title -->
            <h2 class="content-header-title mb-0">
                Faculty / Scientist
            </h2>
        </div>
    </div>
    <section id="person" class="">
        <div class="col-xl-3 ">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-7">
                        <div class="card-body text-nowrap d-flex flex-column align-items-start">
                            <!-- File Icon with Space -->
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-users fa-2x text-primary me-3"></i>
                                <!-- Number Text -->
                                <h5 class="card-title mb-0"> <span id="recordsTotal"></span></h5>
                            </div>
                            <!-- Total Publication Text Below Icon -->
                            <p class="mb-2">Total Faculty / Scientist</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="card p-5 mt-5">
                <!-- Added margin-top for space -->
                <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                    <div class="row dt-row">
                        <div class="col-sm-12">
                            <table class="user-list table table-hover dataTable no-footer" id="DataTables_Table_0"
                                aria-describedby="DataTables_Table_0_info">
                                <thead>
                                    <tr>
                                        <th class="sorting sorting_asc text-nowrap col-5 px-2" tabindex="0"
                                            aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                            aria-sort="ascending">
                                            Preferred name
                                        </th>
                                        <th class="sorting col-4 text-nowrap px-2" tabindex="0"
                                            aria-controls="DataTables_Table_0" rowspan="1" colspan="1">
                                            Main Affiliation
                                        </th>
                                        <th class="sorting col-4 text-nowrap px-2" tabindex="0"
                                            aria-controls="DataTables_Table_0" rowspan="1" colspan="1">
                                            Email
                                        </th>
                                        <th class="sorting col-4 text-nowrap px-2" tabindex="0"
                                            aria-controls="DataTables_Table_0" rowspan="1" colspan="1">
                                            Scopus Author ID
                                        </th>
                                        <th class="sorting col-4 text-nowrap px-2" tabindex="0"
                                            aria-controls="DataTables_Table_0" rowspan="1" colspan="1">
                                            GSID
                                        </th>
                                        <th class="sorting col-4 text-nowrap px-2" tabindex="0"
                                            aria-controls="DataTables_Table_0" rowspan="1" colspan="1">
                                            ORCID
                                        </th>
                                        <th class="sorting col-4 text-nowrap px-2" tabindex="0"
                                            aria-controls="DataTables_Table_0" rowspan="1" colspan="1">
                                            RID
                                        </th>
                                        <th class="sorting col-4 text-nowrap px-2" tabindex="0"
                                            aria-controls="DataTables_Table_0" rowspan="1" colspan="1">
                                            ACTION
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- View Modal -->
                    <div class="modal fade" id="viewPersonModal" tabindex="-1" aria-labelledby="viewPersonModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg"> <!-- modal-lg for larger modal if needed -->
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="viewPersonModalLabel">Person Details</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <!-- Person details table -->
                                    <table class="table table-borderless">
                                        <thead>
                                            <tr class="border-bottom">
                                                <th scope="col"><b>Fields</b></th>
                                                <th scope="col"><b>Details</b></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr id="row_preferred_name" class="border-bottom">
                                                <th>Preferred name</th>
                                                <td id="v_preferred_name"></td>
                                            </tr>
                                            <tr id="row_main_affiliation" class="border-bottom">
                                                <th>Main Affiliation</th>
                                                <a href="/orgunit/item/${row.department}" target="_self">${data}<td
                                                        id="v_main_affiliation"></td></a>
                                            </tr>
                                            <tr id="row_email" class="border-bottom">
                                                <th>Email</th>
                                                <td id="v_email"></td>
                                            </tr>
                                            <tr id="row_scopus_author_id" class="border-bottom">
                                                <th>Scopus Author ID</th>
                                                <td id="v_scopus_author_id"></td>
                                            </tr>
                                            <tr id="row_entity_type" class="border-bottom">
                                                <th>Entity Type</th>
                                                <td id="v_entity_type"></td>
                                            </tr>
                                            <tr id="row_gender" class="border-bottom">
                                                <th>Gender</th>
                                                <td id="v_gender"></td>
                                            </tr>
                                            <tr id="row_affiliation_id" class="border-bottom">
                                                <th>Affiliation Id</th>
                                                <td id="v_affiliation_id"></td>
                                            </tr>
                                            <tr id="row_job_title" class="border-bottom">
                                                <th>Job Title</th>
                                                <td id="v_job_title"></td>
                                            </tr>
                                            <tr id="row_gsid" class="border-bottom">
                                                <th>GSID</th>
                                                <td id="v_gsid"></td>
                                            </tr>
                                            <tr id="row_orcid" class="border-bottom">
                                                <th>ORCID</th>
                                                <td id="v_orcid"></td>
                                            </tr>
                                            <tr id="row_rid" class="border-bottom">
                                                <th>RID</th>
                                                <td id="v_rid"></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>

        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <!-- We will insert the person's name dynamically into the following paragraph -->
                        <p id="deleteMessage">Are you sure you want to delete this person?</p>
                    </div>
                    <div class="modal-footer">
                        <!-- Hidden form with delete button -->
                        <form id="deleteForm" method="POST"
                            action="<?php echo e(route('person.delete', ['uuid' => '__UUID__'])); ?>">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <!-- We'll store the person's id (uuid) here -->
                            <input type="hidden" name="person_id" id="person_id">
                            <button type="submit" class="btn btn-danger" id="deleteButton">Delete</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </section>
    <!-- Empty State Message -->
    <div id="empty-state" class="text-center p-5 d-none">
        <div class="mb-4">
            <i class="fas fa-box-open text-muted" style="font-size: 5rem;"></i>
        </div>
        <h4 class="text-muted">No Data Available</h4>
        <p class="text-muted">There are no persons available in the database.</p>
    </div>

    <script>
        $(document).ready(function() {
            // Assuming each person object has: uuid and text_value
            var personsRaw = <?php echo json_encode($data, 15, 512) ?>;
            let recordsCount = personsRaw.length;


            // Reference elements
            let emptyState = $('#empty-state');
            let dataTableContainer = $('#DataTables_Table_0');
            let section = $('#person');


            // Function to toggle visibility based on data presence
            function checkEmptyState() {
                if (recordsCount === 0) {
                    emptyState.removeClass("d-none"); // Show "No Data Available" message
                    dataTableContainer.hide();
                    section.hide();
                } else {
                    emptyState.addClass("d-none"); // Hide the message
                    dataTableContainer.show();
                    section.show();
                }
            }

            // Call function to check the state initially
            checkEmptyState();

            // Process data if available

            if (recordsCount > 0) {
                var persons = personsRaw.map(function(person) {
                    return {
                        uuid: person.dspace_object_id,
                        preferred_name: person.preferred_name || '',
                        main_affiliation: person.main_affiliation || '',
                        email: person.email || '',
                        scopus_author_id: person.scopus_author_id || '',
                        entity_type: person.entity_type || '',
                        gender: person.gender || '',
                        affiliation_id: person.affiliation_id || '',
                        job_title: person.job_title || '',
                        department: person.department || '',
                        // Add these if you need them and have them in your data
                        gsid: person.gsid || '',
                        orcid: person.orcid || '',
                        rid: person.rid || '',
                    };
                });
            }

            // Store persons in a global variable for later access in viewperson function.
            window.personsData = persons;

            $('#recordsTotal').text(persons.length);
            const orgunitRoute = "<?php echo e(route('orgunitlist.index', ['id' => '__ID__'])); ?>";
            const profile = "<?php echo e(route('profile.index', ['profileid' => '__ID__'])); ?>";
            $('#DataTables_Table_0').DataTable({
                data: persons,
                columns: [{
                        data: 'preferred_name',
                        name: 'Preferred name',
                        render: function(data, type, row) {
                            if (data && row.uuid) {
                                // Replace the placeholder with the actual UUID
                                const url = profile.replace('__ID__', row.uuid);
                                return `<a href="${url}" class="text-primary">${data}</a>`;
                            }
                            return data || '';
                        }

                    },
                    {
                        data: 'main_affiliation',
                        dept: 'department',
                        name: 'Main Affiliation',
                        render: function(data, type, row) {
                            if (data && row.department) {
                                // Replace the placeholder with actual department ID
                                const url = orgunitRoute.replace('__ID__', row.department);
                                return `<a href="${url}" target="_self">${data}</a>`;
                            }
                            return '';
                        }

                    },
                    {
                        data: 'email',
                        name: 'Email'
                    },
                    {
                        data: 'scopus_author_id',
                        name: 'Scopus Author ID',
                        render: function(data, type, row) {
                            return data ?
                                `<a href="https://www.scopus.com/authid/detail.uri?authorId=${data}" target="_blank">${data}</a>` :
                                '';
                        }
                    },
                    {
                        data: 'gsid',
                        name: 'GSID'
                    },
                    {
                        data: 'orcid',
                        name: 'ORCID'
                    },
                    {
                        data: 'rid',
                        name: 'RID'
                    },

                    {
                        data: null,
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `
                                                                <div class="d-flex justify-content-start">
                                                                    <button type="button" class="btn btn-info btn-sm me-2" onclick="viewperson('${row.uuid}');">
                                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-eye font-medium-4">
                                                                            <path d="M1 12s1.5-7 11-7 11 7 11 7-1.5 7-11 7-11-7-11-7z"></path>
                                                                            <circle cx="12" cy="12" r="3"></circle>
                                                                        </svg>
                                                                    </button>
                                                                    <button type="button" class="btn btn-danger btn-sm" onclick="confirmPersonDelete('${row.uuid}', '${row.email}');">
                                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash font-medium-4">
                                                                            <polyline points="3 6 5 6 21 6"></polyline>
                                                                            <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                                                        </svg>
                                                                    </button>
                                                                </div>`;
                        }
                    }
                ],
                pageLength: 10,
                scrollX: true
            });
        });

        function viewperson(uuid) {
            // Find the person with the matching uuid
            var person = window.personsData.find(function(p) {
                return p.uuid === uuid;
            });

            if (person) {

                // Helper function to set or hide field
                function setField(rowId, fieldId, label, isLink = false, prefix = '', linkValue = '') {
                    if (label && label !== 'null' && label !== 'undefined') {
                        if (isLink) {
                            const href = prefix + (linkValue || label);
                            $(fieldId).html(`<a href="${href}" target="_blank">${label}</a>`);
                        } else {
                            $(fieldId).text(label);
                        }
                        $(rowId).show();
                    } else {
                        $(rowId).hide();
                    }
                }

                // Populate modal fields with person's details
                // Populate modal fields with person's details
                setField('#row_preferred_name', '#v_preferred_name', person.preferred_name);
                setField('#row_main_affiliation', '#v_main_affiliation', person.main_affiliation, true, '/orgunit/item/',
                    person.department);

                setField('#row_email', '#v_email', person.email);
                setField('#row_scopus_author_id', '#v_scopus_author_id', person.scopus_author_id, true,
                    "https://www.scopus.com/authid/detail.uri?authorId=");
                setField('#row_entity_type', '#v_entity_type', person.entity_type);
                setField('#row_gender', '#v_gender', person.gender);
                setField('#row_affiliation_id', '#v_affiliation_id', person.affiliation_id);
                setField('#row_job_title', '#v_job_title', person.job_title);
                setField('#row_gsid', '#v_gsid', person.gsid);
                setField('#row_orcid', '#v_orcid', person.orcid);
                setField('#row_rid', '#v_rid', person.rid);


                // Show the modal
                var myModal = new bootstrap.Modal(document.getElementById('viewPersonModal'));
                myModal.show();
            }
        }

        // function confirmPersonDelete(uuid, email) {
        //     // Find the person by uuid from your global personsData
        //     var person = window.personsData.find(function(p) {
        //         return p.uuid === uuid;
        //     });
        //     if (person) {
        //         // Insert the person's name into the confirmation message
        //         $('#deleteMessage').html("Are you sure you want to delete <b>" + person.preferred_name + "</b>?");
        //         // Set the hidden input with the person's id
        //         $('#person_id').val(uuid);

        //         // Update the form's action URL by replacing the placeholder :uuid
        //         // var action = $('#deleteForm').attr('action');
        //         var url = "/person/delete/" + uuid;
        //         // action = action.replace(':uuid', uuid);
        //         $('#deleteForm').attr('action', url);

        //         // For debugging, you can log the final action URL:
        //         // console.log("Final delete URL:", url);

        //         // Show the delete modal
        //         var deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
        //         deleteModal.show();
        //     }
        // }

        function confirmPersonDelete(uuid, email) {
            var person = window.personsData.find(function(p) {
                return p.uuid === uuid;
            });

            if (person) {
                $('#deleteMessage').html("Are you sure you want to delete <b>" + person.preferred_name + "</b>?");
                $('#person_id').val(uuid);

                // Replace the placeholder __UUID__ in the form action
                var form = $('#deleteForm');
                var originalAction = form.attr('action'); // e.g., /person/delete/__UUID__
                var updatedAction = originalAction.replace('__UUID__', uuid);
                form.attr('action', updatedAction);

                // Debug: Log final URL
                console.log("Final delete URL:", updatedAction);

                // Show modal
                var deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
                deleteModal.show();
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Admin\Documents\dspace_dash\resources\views/content/pages/personslist.blade.php ENDPATH**/ ?>