<?php
    $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Patents'); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js']); ?>
<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<?php $__env->startSection('content'); ?>
    <div class="content-header row mb-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('community.index')); ?>">Community</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('collection.index', ['id' => $communityid])); ?>">Collection</a>
                </li>
                <li class="breadcrumb-item active">
                    Patent Items
                </li>
            </ol>
        </nav>
        <div class="col-12 d-flex align-items-center justify-content-between">
            <!-- Header Title -->
            <h2 class="content-header-title mb-0">
                <?php echo e($name); ?>

            </h2>
        </div>

        <section id="publication-section" class="">
            <div class="col-xl-3">
                <h4>Patent List</h4>
                <div class="card">
                    <div class="d-flex align-items-end row">
                        <div class="col-7">
                            <div class="card-body text-nowrap d-flex flex-column align-items-start">
                                <!-- Icon and Count -->
                                <div class="d-flex align-items-center mb-2">
                                    <i class="fas fa-file fa-2x text-primary me-3"></i>
                                    <h5 class="card-title mb-0">
                                        <span id="recordsTotal"><?php echo e($totalPatent); ?></span>
                                    </h5>
                                </div>
                                <!-- Label -->
                                <p class="mb-2">Total Patent</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card p-5 mt-3">
                    <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                        <div class="row dt-row">
                            <div class="col-sm-12">
                                <table class="user-list table table-hover dataTable no-footer" id="patentTable"
                                    style="width:100%">
                                    <thead>
                                        <tr>
                                            <th>Title</th>
                                            <th>Patent No</th>
                                            <th>Date Issued</th>
                                            <th>Publisher</th>
                                            <th>Authors</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>
    </div>
    <script>
        $(document).ready(function() {
            $(function() {
                $('#patentTable').DataTable({
                    processing: true,
                    serverSide: true,
                    scrollX: true,
                    ajax: "<?php echo e(route('patent.data', $id)); ?>",
                    columns: [{
                            data: 'title',
                            name: 'title'
                        },
                        {
                            data: 'patent',
                            name: 'patent'
                        },
                        {
                            data: 'dateissue',
                            name: 'dateissue'
                        },
                        {
                            data: 'publisher',
                            name: 'publisher'
                        },
                        {
                            data: 'author',
                            name: 'author'
                        },
                    ],
                    dom: '<"row mb-3"' +
                        '<"col-sm-12 col-md-6"l>' +
                        '<"col-sm-12 col-md-6 d-flex justify-content-end align-items-center"fB>' +
                        '>' +
                        't' +
                        '<"row mt-3"' +
                        '<"col-sm-12 col-md-6"i>' +
                        '<"col-sm-12 col-md-6"p>' +
                        '>',
                    buttons: [{
                        extend: 'collection',
                        className: 'btn btn-label-primary dropdown-toggle ms-2 waves-effect waves-light border-none',
                        text: '<i class="ti ti-file-export ti-xs me-sm-1"></i> <span class="d-none d-sm-inline-block">Export</span>',
                        buttons: [{
                                extend: 'print',
                                text: '<i class="ti ti-printer me-1"></i>Print',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            },
                            {
                                extend: 'csv',
                                text: '<i class="ti ti-file-text me-1"></i>Csv',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            },
                            {
                                extend: 'excel',
                                text: '<i class="ti ti-file-spreadsheet me-1"></i>Excel',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            },
                            {
                                extend: 'pdf',
                                text: '<i class="ti ti-file-description me-1"></i>Pdf',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            },
                            {
                                extend: 'copy',
                                text: '<i class="ti ti-copy me-1"></i>Copy',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            }
                        ]
                    }],
                })
            })
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Admin\Documents\dspace_dash\resources\views/content/pages/patent.blade.php ENDPATH**/ ?>