<?php
    use Illuminate\Support\Facades\DB; // ✅ Import DB facade

    // ✅ Fetch allowed metadata_field_id dynamically from the database
    $allowedIds = DB::table('metadatavalue')->distinct()->pluck('metadata_field_id')->toArray();
?>

<?php
    $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Edit CMS Metadata'); ?>

<?php $__env->startSection('content'); ?>

<?php $__env->startSection('title', 'Logistics Dashboard - Apps'); ?>

<?php $__env->startSection('vendor-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')('resources/assets/vendor/scss/pages/app-logistics-dashboard.scss'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')('resources/assets/js/app-logistics-dashboard.js'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-header row d-flex align-items-center">
        <div class="d-flex align-items-center">
            <i class="fa fa-edit fa-2x text-primary me-3"></i>
            <h2 class="mb-0">Edit CMS Metadata</h2>
        </div>
    </div>
    

    <div class="row">
        <div class="col-12">
            <div class="card p-4 mt-3">
                <!-- Dropdown for Metadata Selection -->
                <div class="mb-3">
                    <div class="row">
                        <div class="col-12 col-sm-8 col-md-6 col-lg-4">
                            <select id="metadataSelect" class="form-select">
                                <option value="metadata-edit" selected>Select metadata-edit to edit</option>
                                <option value="<?php echo e($homeHeaderId); ?>">cris.cms.home-header</option>
                                <option value="<?php echo e($homeNewsId); ?>">cris.cms.home-news</option>
                                <option value="<?php echo e($footerId); ?>">cris.cms.footer</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Card for Displaying Metadata Information -->
                <div class="card" id="metadataCard" style="display: none;">
                    <div class="card-body">
                        <h5 class="card-title" id="metadataCardTitle">Metadata Details</h5>
                        <p class="card-text" id="metadataCardContent">Select a metadata field to see details.</p>
                    </div>
                </div>

                <!-- Dynamic Heading for Selected Metadata -->
                <h4 id="metadataTitle" style="display: none;"></h4>

                <!-- Textarea for Editing Metadata -->
                <div id="metadataTextareaContainer" class="mb-3" style="display: none;">
                    <label for="metadataTextarea" class="form-label">Edit Metadata Content:</label>
                    <textarea id="metadataTextarea" class="form-control" rows="5" style="resize: vertical; overflow-y: auto;"></textarea>


                    <!-- Save Button with File Icon -->
                    <button id="saveBtn" class="btn btn-primary mt-3">
                        <i class="ti ti-save"></i> Save
                    </button>
                </div>
            </div>
        </div>
    </div>


    <script>
        const getMetadataUrlTemplate = "<?php echo e(route('getMetadata', ['metadataFieldId' => '__ID__'])); ?>";

        document.getElementById("metadataSelect").addEventListener("change", function() {
            var selectedValue = this.value;
            var metadataTitle = document.getElementById("metadataTitle");
            var textareaContainer = document.getElementById("metadataTextareaContainer");
            var metadataTextarea = document.getElementById("metadataTextarea");

            if (selectedValue !== "metadata-edit") {
                metadataTitle.innerText = "Edit CMS Metadata '" + this.options[this.selectedIndex].text + "'";
                metadataTitle.style.display = "block";
                textareaContainer.style.display = "block";

                // Replace the placeholder in the route template with actual ID
                const url = getMetadataUrlTemplate.replace('__ID__', selectedValue);

                fetch(url)
                    .then(response => response.json())
                    .then(data => {
                        metadataTextarea.value = data?.text_value || "";
                    })
                    .catch(error => console.error("Error:", error));
            } else {
                metadataTitle.style.display = "none";
                textareaContainer.style.display = "none";
                metadataTextarea.value = "";
            }

        });


        // ✅ Allowed IDs are now fetched dynamically from the backend
        var allowedIds = <?php echo json_encode($allowedIds); ?>;

        document.getElementById("saveBtn").addEventListener("click", function() {
            var metadataFieldId = document.getElementById("metadataSelect").value;
            var textValue = document.getElementById("metadataTextarea").value;


            // ✅ Check if metadataFieldId is in allowedIds
            if (!allowedIds.includes(parseInt(metadataFieldId))) {
                alert("This function only works for valid metadata_field_id from the database.");
                return;
            }

            if (metadataFieldId === "metadata-edit") {
                showMessage("Please select a valid metadata field!", "danger");
                return;
            }

            fetch("<?php echo e(route('save.metadata')); ?>", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
                    },
                    body: JSON.stringify({
                        metadata_field_id: metadataFieldId,
                        text_value: textValue
                    })
                })
                .then(response => response.json())
                .then(data => {
                    // alert(data.message);
                    if (data.status === 'success') {
                        location.reload();
                    }
                })
                .catch(error => console.error("Error:", error));


        });
    </script>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Admin\Documents\dspace_dash\resources\views/content/pages/editmetadata.blade.php ENDPATH**/ ?>