<?php
    $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Faculty/Scientist Profile'); ?>

<?php $__env->startSection('vendor-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Page Styles -->
<?php $__env->startSection('page-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/scss/pages/page-profile.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js']); ?>
<?php $__env->stopSection(); ?>

<!-- Page Scripts -->
<?php $__env->startSection('page-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/js/pages-profile.js']); ?>
<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<?php $__env->startSection('content'); ?>
    <div class="content-header row mb-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('personslist.index')); ?>">Persons List</a>
                </li>
                <li class="breadcrumb-item active">
                    Person Details
                </li>
            </ol>
        </nav>
    </div>
    <div class="col-12">
        <div class="card mb-6">
            <div class="user-profile-header d-flex flex-column flex-lg-row text-sm-start text-center mb-5">
                <div class="flex-grow-1 mt-3 mt-lg-5">
                    <div
                        class="d-flex align-items-md-end align-items-sm-start align- items-center justify-content-md-between justify-content-start mx-5 flex-md-row flex-column gap-4">
                        <div class="user-profile-info w-100 pt-3">
                            <h4 class="mt-lg-4"><?php echo e($meta['title']['value'] ?? 'No Name'); ?></h4>
                            <ul class="d-flex align-items-center flex-wrap justify-content-between gap-4 my-4 p-0">
                                
                                <?php if(!empty($meta['affiliation']['value'])): ?>
                                    <li class="list-inline-item d-flex gap-2 align-items-center">
                                        <div class="badge rounded bg-label-info p-1_5">
                                            <i class="ti ti-building ti-lg"></i>
                                        </div>

                                        <?php if(!empty($meta['affiliation']['authority'])): ?>
                                            <a href="<?php echo e(route('orgunitlist.index', ['id' => $meta['affiliation']['authority']])); ?>"
                                                class="fw-medium text-primary text-decoration-none">
                                                <?php echo e($meta['affiliation']['value']); ?>

                                            </a>
                                        <?php else: ?>
                                            <span class="fw-medium"><?php echo e($meta['affiliation']['value']); ?></span>
                                        <?php endif; ?>
                                    </li>
                                <?php endif; ?>
                                
                                <?php if(!empty($meta['email']['value'])): ?>
                                    <li class="list-inline-item d-flex gap-2 align-items-center">
                                        <div class="badge rounded bg-label-info p-1_5">
                                            <i class="ti ti-mail ti-lg"></i>
                                        </div>
                                        <a href="mailto:<?php echo e($meta['email']['value']); ?>">
                                            <?php echo e($meta['email']['value']); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if(!empty($meta['orchid_id']['value'])): ?>
                                    <li class="list-inline-item d-flex gap-2 align-items-center">
                                        <img src="<?php echo e(asset('assets/img/logo/orcid.png')); ?>" alt="orcid" height="30">
                                        <a href="https://orcid.org/<?php echo e($meta['orchid_id']['value']); ?>" target="_blank">
                                            <?php echo e($meta['orchid_id']['value']); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if(!empty($meta['scopus_id']['value'])): ?>
                                    <li class="list-inline-item d-flex gap-2 align-items-center">
                                        <img src="<?php echo e(asset('assets/img/logo/scopus.png')); ?>" alt="Scopus" height="35">
                                        <a href="https://www.scopus.com/authid/detail.uri?authorId=<?php echo e($meta['scopus_id']['value']); ?>"
                                            target="_blank">
                                            <?php echo e($meta['scopus_id']['value']); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if(!empty($meta['researcher_id']['value'])): ?>
                                    <li class="list-inline-item d-flex gap-2 align-items-center">
                                        <img src="<?php echo e(asset('assets/img/logo/researcher.jpg')); ?>" alt="researcher"
                                            height="35">
                                        <a href="https://www.webofscience.com/wos/author/record/<?php echo e($meta['researcher_id']['value']); ?>"
                                            target="_blank">
                                            <?php echo e($meta['researcher_id']['value']); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>

                                
                                <?php if(!empty($meta['google_scholar_id']['value'])): ?>
                                    <li class="list-inline-item d-flex gap-2 align-items-center">
                                        <img src="<?php echo e(asset('assets/img/logo/google-scholour.png')); ?>" alt="google-scholour"
                                            height="35">
                                        <a href="https://scholar.google.com/citations?hl=en&user=<?php echo e($meta['google_scholar_id']['value']); ?>"
                                            target="_blank">
                                            <?php echo e($meta['google_scholar_id']['value']); ?>

                                        </a>
                                    </li>
                                <?php endif; ?>

                            </ul>
                            <ul
                                class="list-inline mb-0 d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center gap-4 my-2">
                                <li class="list-inline-item d-flex gap-2 align-items-center">
                                    <span class="fw-medium text-dark">
                                        Total Citation: <?php echo e($meta['totalCitation'] ?? 'N/A'); ?>

                                    </span>
                                </li>
                                <li class="list-inline-item d-flex gap-2 align-items-center">
                                    <i class="fa fa-unlock-alt text-center" style="color:#808080; font-size: 20px;"></i>
                                    <?php echo e($meta['unpaywallCounts']['close'] ?? '0'); ?>

                                </li>
                                <li class="list-inline-item d-flex gap-2 align-items-center">
                                    <i class="fa fa-unlock-alt text-center" style="color:#FFD700; font-size: 20px;"></i>
                                    <?php echo e($meta['unpaywallCounts']['gold'] ?? '0'); ?>

                                </li>
                                <li class="list-inline-item d-flex gap-2 align-items-center">
                                    <i class="fa fa-unlock-alt text-center" style="color:#228B22; font-size: 20px;"></i>
                                    <?php echo e($meta['unpaywallCounts']['green'] ?? '0'); ?>

                                </li>
                                <li class="list-inline-item d-flex gap-2 align-items-center">
                                    <i class="fa fa-unlock-alt text-center" style="color:#CD7F32; font-size: 20px;"></i>
                                    <?php echo e($meta['unpaywallCounts']['bronze'] ?? '0' + $meta['unpaywallCounts']['hybrid'] ?? '0'); ?>

                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <table id="publicationTable" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Authors</th>
                        <th>Journal</th>
                        <th>Type</th>
                        <th>Year</th>
                        <th>DOI</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
    </div>
    <script>
        const orgunitRoute = "<?php echo e(route('orgunitlist.index', ['id' => '__ID__'])); ?>";
        $(document).ready(function() {
            const profileUuid = "<?php echo e($profileid); ?>";
            // console.log('Profile id'+ profileUuid);

            const table = $('#publicationTable').DataTable({
                ajax: {
                    url: `/faculty/profile/${profileUuid}/publications`,
                    dataSrc: 'data'
                },
                columns: [{
                        data: 'title',
                        render: (data, type, row) =>
                            `<a href="https://doi.org/${row.doi}" target="_blank">${data ?? 'No Title'}</a>`
                    },
                    {
                        data: 'authors'
                    },
                    {
                        data: 'journal'
                    },
                    {
                        data: 'publication_type'
                    },
                    {
                        data: 'date_issued',
                        render: d => d ? new Date(d).getFullYear() : ''
                    },
                    {
                        data: 'doi',
                        render: d => d ? `<a href="https://doi.org/${d}" target="_blank">${d}</a>` : ''
                    },
                ],
                dom: '<"row mb-3"' +
                    '<"col-sm-12 col-md-6"l>' +
                    '<"col-sm-12 col-md-6 d-flex justify-content-end align-items-center"fB>' +
                    '>' +
                    't' +
                    '<"row mt-3"' +
                    '<"col-sm-12 col-md-6"i>' +
                    '<"col-sm-12 col-md-6"p>' +
                    '>',
                buttons: [{
                    extend: 'collection',
                    className: 'btn btn-label-primary dropdown-toggle ms-2 waves-effect waves-light border-none',
                    text: '<i class="ti ti-file-export ti-xs me-sm-1"></i> <span class="d-none d-sm-inline-block">Export</span>',
                    buttons: [{
                            extend: 'print',
                            text: '<i class="ti ti-printer me-1"></i>Print',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },
                        {
                            extend: 'csv',
                            text: '<i class="ti ti-file-text me-1"></i>CSV',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },
                        {
                            extend: 'excel',
                            text: '<i class="ti ti-file-spreadsheet me-1"></i>Excel',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },
                        {
                            extend: 'pdf',
                            text: '<i class="ti ti-file-description me-1"></i>PDF',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },
                        {
                            extend: 'copy',
                            text: '<i class="ti ti-copy me-1"></i>Copy',
                            className: 'dropdown-item',
                            exportOptions: {
                                columns: ':visible'
                            }
                        }
                    ]
                }]
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Admin\Documents\dspace_dash\resources\views/content/pages/facultyprofile.blade.php ENDPATH**/ ?>