<?php
    $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Metadata Registry'); ?>

<?php $__env->startSection('content'); ?>

<?php $__env->startSection('title', 'Logistics Dashboard - Apps'); ?>

<?php $__env->startSection('vendor-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')('resources/assets/vendor/scss/pages/app-logistics-dashboard.scss'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')('resources/assets/js/app-logistics-dashboard.js'); ?>
<?php $__env->stopSection(); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<?php $__env->startSection('content'); ?>
    <div>
        <h2>Metadata Registry!</h2>
        <hr>
        <p>The metadata registry maintains a list of all metadata fields available in the repository. These fields may be
            divided amongst multiple schemas. However, DSpace requires the qualified Dublin Core schema.</p>
    </div>

    <!-- Form Box -->

    <div class="card mt-3 p-4">
        <form id="metadataForm" novalidate method="POST" action="<?php echo e(route('addmetadataregistry')); ?>">
            <?php echo csrf_field(); ?>
            <!-- Namespace and Name Fields in One Row -->
            <div class="row mb-3 align-items-center">
                <!-- Small Namespace Textbox -->
                <div class="col-auto">
                    <label for="namespace" class="col-form-label">Namespace<span class="text-danger">*</span></label>
                </div>
                <div class="col-5">
                    <input type="text" class="form-control" id="namespace" name="namespace" required>
                    <div class="invalid-feedback">
                        This field is required.
                    </div>
                </div>

                <!-- Name Textbox Next to Namespace -->
                <div class="col-auto">
                    <label for="name" class="col-form-label">Name<span class="text-danger">*</span></label>
                </div>
                <div class="col-5">
                    <input type="text" class="form-control" id="name" name="name" required>
                    <div class="invalid-feedback">
                        This field is required.
                    </div>
                </div>
            </div>

            <!-- Buttons -->
            <div class="d-flex justify-content-end gap-2">
                <button type="reset" class="btn btn-secondary">Reset</button>
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>
    </div>

    <!-- <form id="deleteForm" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <input type="hidden" name="metadata_id" id="metadata_id">
            </form> -->

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p id="deleteMessage">Are you sure you want to delete?</p>
                </div>
                <div class="modal-footer">
                    <!-- <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                <button type="button" class="btn btn-danger" id="deleteButton">Delete</button> -->
                    <form id="deleteForm" method="POST"
                        action="<?php echo e(route('metadataregistry.delete', ['id' => '__ID__'])); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <input type="hidden" name="metadata_id" id="metadata_id">
                        <button type="submit" class="btn btn-danger" id="deleteButton">Delete</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </form>

                </div>

            </div>
        </div>
    </div>


    
    <div class="modal fade" id="editMetadataModal" tabindex="-1" aria-labelledby="editMetadataModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editMetadataForm" method="POST" action="<?php echo e(route('metadata.update')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title" id="editMetadataModalLabel">Edit Metadata</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <input type="hidden" name="metadata_schema_id" id="edit_metadata_id">
                        <div class="mb-3">
                            <label for="edit_namespace" class="form-label">Namespace</label>
                            <input type="text" class="form-control" id="edit_namespace" name="namespace" required>
                        </div>
                        <div class="mb-3">
                            <label for="edit_name" class="form-label">Name</label>
                            <input type="text" class="form-control" id="edit_name" name="name" required>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    

    <script>
        // Bootstrap validation
        (function() {
            const form = document.getElementById('metadataForm');
            form.addEventListener('submit', function(event) {
                if (!form.checkValidity()) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                form.classList.add('was-validated');
            }, false);
        })();


        // Confirm delete function
        function confirmDelete(metadataID, namespace, name) {
            if (metadataID) {
                // Set confirmation message
                document.getElementById('deleteMessage').innerText =
                    `Are you sure you want to delete metadata with Name: ${name} and Namespace: ${namespace}?`;

                // Show modal
                const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
                deleteModal.show();

                // Get form and replace action
                const deleteForm = document.getElementById('deleteForm');
                const actionTemplate = deleteForm.getAttribute('action'); // e.g. /metadataregistry/delete/__ID__
                const newAction = actionTemplate.replace('__ID__', metadataID);

                // On Delete button click
                document.getElementById('deleteButton').onclick = function() {
                    document.getElementById('metadata_id').value = metadataID;
                    deleteForm.setAttribute('action', newAction);
                    deleteForm.submit();
                };
            } else {
                alert('Metadata not found!');
            }
        }


        function editMetadata(id, namespace, name) {
            document.getElementById("edit_metadata_id").value = id;
            document.getElementById("edit_namespace").value = namespace;
            document.getElementById("edit_name").value = name;

            // Show the modal
            let modal = new bootstrap.Modal(document.getElementById('editMetadataModal'));
            modal.show();
        }




        $(document).ready(function() {
            let metadata = <?php echo json_encode($metadata, 15, 512) ?>;
            const registryUrlTemplate = "<?php echo e(route('metadata.schema', ['namespace' => '__NAMESPACE__'])); ?>";

            if (Array.isArray(metadata) && metadata.length > 0) {
                $('#DataTables_Table_0').DataTable({
                    data: metadata,
                    columns: [{
                            data: 'metadata_schema_id',
                            title: 'ID',
                            render: function(data, type, row) {
                                // return `<a href="/registries/${row.short_id}">${data}</a>`;
                                const url = registryUrlTemplate.replace('__NAMESPACE__', row.short_id);
                                return `<a href="${url}">${data}</a>`;
                            }
                        }, // Match DB column
                        {
                            data: 'namespace',
                            title: 'Namespace',
                            render: function(data, type, row) {
                                // return `<a href="/registries/${row.short_id}">${data}</a>`;
                                const url = registryUrlTemplate.replace('__NAMESPACE__', row.short_id);
                                return `<a href="${url}">${data}</a>`;
                            }
                        },
                        {
                            data: 'short_id',
                            title: 'Name',
                            render: function(data, type, row) {
                                // return `<a href="/registries/${data}">${data}</a>`;
                                const url = registryUrlTemplate.replace('__NAMESPACE__', row.short_id);
                                return `<a href="${url}">${data}</a>`;
                            }
                        }, // Fix: Match DB column to 'Name'
                        {
                            data: null,
                            title: 'Action',
                            orderable: false,
                            render: function(data, type, row) {
                                return `
                            <div class="d-flex justify-content-start">
                            <button type="button" class="btn btn-warning btn-sm me-2" onclick="editMetadata('${row.metadata_schema_id}', '${row.namespace}', '${row.short_id}');">
                                  <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn btn-danger btn-sm" onclick="confirmDelete('${row.metadata_schema_id}', '${row.short_id}','${row.namespace}');">
                              <i class="fas fa-trash"></i>
                            </button>
                            </div>
                            `;
                            }
                        }
                    ],
                    order: [
                        [0, 'asc']
                    ],
                    pageLength: 10,
                    scrollX: true
                });



            } else {
                console.error("No data found in metadata");
            }


        });
    </script>

    <div class="row">
        <div class="col-12">
            <div class="card mt-3 p-4">
                <!-- Added margin-top for space -->
                <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                    <div class="row dt-row table-responsive">
                        <div class="col-sm-12">
                            <table class="user-list table table-hover dataTable" id="DataTables_Table_0"
                                aria-describedby="DataTables_Table_0_info">
                                <thead>
                                    <tr>
                                        <th class="sorting sorting_asc text-nowrap" tabindex="0"
                                            aria-controls="DataTables_Table_0" rowspan="1" colspan="1"
                                            aria-sort="ascending">ID</th>
                                        <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0"
                                            rowspan="1" colspan="1">NAMESPACE</th>
                                        <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0"
                                            rowspan="1" colspan="1">NAME</th>
                                        <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0"
                                            rowspan="1" colspan="1">
                                            ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Dynamic rows generated by DataTables server-side processing -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Admin\Documents\dspace_dash\resources\views/content/pages/registries.blade.php ENDPATH**/ ?>