<?php
    $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Home'); ?>

<?php $__env->startSection('content'); ?>

<?php $__env->startSection('title', 'Logistics Dashboard - Apps'); ?>

<?php $__env->startSection('vendor-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')('resources/assets/vendor/scss/pages/app-logistics-dashboard.scss'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')('resources/assets/js/app-logistics-dashboard.js'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-header row mb-3">
        <div class="col-12 d-flex align-items-center justify-content-between">
            <!-- Header Title -->
            <h2 class="content-header-title mb-0">
                Welcome Administrator!
            </h2>

            <!-- Add Community Button -->
            <a href="<?php echo e(route('dashboard_json')); ?>" id="updateButton"
                class="btn btn-primary rounded-pill d-flex align-items-center waves-effect waves-light">
                <i class="fas fa-refresh me-2" id="spinIcon"></i> Update
            </a>
        </div>
    </div>

    
    <script>
        document.getElementById('updateButton').addEventListener('click', function(event) {
            event.preventDefault(); // Prevents default behavior (page reload)

            // Start the spinner
            var spinIcon = document.getElementById('spinIcon');
            spinIcon.classList.add('fa-spin');

            // Perform the AJAX requestF

            fetch("<?php echo e(route('dashboard_json')); ?>")
                .then(response => response.json())
                .then(data => {
                    spinIcon.classList.remove('fa-spin'); // Stop the spinner

                    if (data.success) {
                        // console.log("Session Success Message:", data.success);
                        window.location.href = "<?php echo e(route('dashboard')); ?>";
                    } else {
                        console.log("Error:", data.error);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    spinIcon.classList.remove('fa-spin'); // Stop the spinner
                    // document.getElementById('errorMessage').textContent =
                    // 'An error occurred while fetching the data.';
                });
        });
    </script>

    <div class="row g-6 ">
        <div class="col-12 col-sm-6 col-lg-4">
            <div class="card h-100 mb-4">
                <div class="card-header">
                    <h4 class="card-title">Publications/Patent/Faculty</h4>
                </div>
                <div class="card-body card-dashboard">
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td><i class="fa fa-users text-center"
                                            style="color:#646c9a; font-size: 25px; margin-right:5px; vertical-align: middle;"></i><a
                                            href="<?php echo e(route('personslist.index')); ?>">Faculty
                                            / Scientist</a></td>
                                    <td id="total_f"><?php echo e($data['totalPerson']); ?></td>
                                </tr>
                                <tr>
                                    <td><i class="fa fa-file text-center"
                                            style="color:#2D9BD6; font-size: 31px; margin-right:5px; vertical-align: middle;">
                                        </i><a href="<?php echo e(route('publicationlist.index')); ?>">
                                            Publications</a></td>
                                    <td id="total_p"><?php echo e($data['totalPublication']); ?></td>
                                </tr>
                                <tr>
                                    <td><i class="fa fa-file-contract text-center"
                                            style="color:#646c9a; font-size: 25px; margin-right:5px; vertical-align: middle;">
                                        </i>
                                        Patent
                                    </td>
                                    <td id="total_f"><?php echo e($data['totalPatent']); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-lg-4">
            <div class="card h-100 mb-4">
                <div class="card-header">
                    <h4 class="card-title">Citation &amp; Metrics</h4>
                </div>
                <div class="card-body card-dashboard">
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td><img src="<?php echo e(asset('assets/img/logo/crossref.png')); ?>" alt="Crossref"
                                            height="40"> Crossref</td>
                                    <td><?php echo e($data['totalcrossRef']); ?></td>
                                </tr>
                                <tr>
                                    <td><img src="<?php echo e(asset('assets/img/logo/scopus.png')); ?>" alt="Scopus" height="40">
                                        Scopus</td>
                                    <td><?php echo e($data['totalScopus']); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-lg-4">
            <div class="card h-100 mb-4">
                <div class="card-header">
                    <h4 class="card-title">Communities/Collections</h4>
                </div>
                <div class="card-body card-dashboard">
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td><i class="fa fa-users text-center"
                                            style="color:#6A1B9A; font-size: 31px; vertical-align: middle;"></i>
                                        Communities</td>
                                    <td><?php echo e($data['totalCommunities']); ?></td>
                                </tr>
                                <tr>
                                    <td><i class="fa fa-folder-open text-center"
                                            style="color:#2E86C1;  font-size: 31px; vertical-align: middle;"></i>
                                        Collections</td>
                                    <td><?php echo e($data['totalCollections']); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-lg-4">
            <div class="card h-100 mb-4">
                <div class="card-header">
                    <h4 class="card-title">Publication Venue</h4>
                </div>
                <div class="card-body card-dashboard">
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td><i class="fa fa-unlock-alt text-center" style="color:#808080; font-size: 20px;"></i>
                                        Closed Access</td>
                                    <td><?php echo e($data['close']); ?></td>
                                </tr>
                                <tr>
                                    <td><i class="fa fa-unlock-alt text-center" style="color:#FFD700; font-size: 20px;"></i>
                                        Gold OA</td>
                                    <td><?php echo e($data['gold']); ?></td>
                                </tr>
                                <tr>
                                    <td><i class="fa fa-unlock-alt text-center" style="color:#228B22; font-size: 20px;"></i>
                                        Green OA</td>
                                    <td><?php echo e($data['open']); ?></td>
                                </tr>
                                <tr>
                                    <td><i class="fa fa-unlock-alt text-center" style="color:#CD7F32; font-size: 20px;"></i>
                                        Bronze OA</td>
                                    <td><?php echo e($data['bronze']); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-lg-4">
            <div class="card h-100 mb-4">
                <div class="card-header">
                    <h4 class="card-title">Admin/Process</h4>
                </div>
                <div class="card-body card-dashboard">
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td><i class="fa fa-user-shield text-center"
                                            style="color:#4B49AC; font-size: 20px;"></i> Admin</td>
                                    <td><?php echo e($data['totalEPerson']); ?></td>
                                </tr>
                                <tr>
                                    <td><i class="fa fa-cogs text-center" style="color:#F39C12; font-size: 20px;"></i>
                                        Process</td>
                                    <td><?php echo e($data['totalProcess']); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Admin\Documents\dspace_dash\resources\views/content/pages/pages-home.blade.php ENDPATH**/ ?>