<?php
    $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Collection List'); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js']); ?>
<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<?php $__env->startSection('content'); ?>
    <div class="content-header row mb-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('community.index')); ?>">Community</a>
                </li>
                <li class="breadcrumb-item active">
                    Collection
                </li>
            </ol>
        </nav>
        <div class="col-12 d-flex align-items-center justify-content-between">
            <!-- Header Title -->
            <h2 class="content-header-title mb-0">
                <?php echo e($community_name); ?>

            </h2>

            <!-- Buttons Wrapper -->
            <div class="d-flex">
                <!-- Add Subcommunity Button -->
                <button type="button" class="btn btn-primary rounded-pill d-flex align-items-center me-2"
                    data-bs-toggle="modal" data-bs-target="#addSubcommunityModal">
                    <i class="fas fa-plus me-2"></i> Add Subcommunity
                </button>

                <!-- Add Collection Button -->
                <button type="button" class="btn btn-primary rounded-pill d-flex align-items-center" data-bs-toggle="modal"
                    data-bs-target="#addCollectionModal">
                    <i class="fas fa-plus me-2"></i> Add Collection
                </button>
            </div>
        </div>

        <!-- Collection Creation Modal -->
        <div class="modal fade" id="addCollectionModal" tabindex="-1" aria-labelledby="addCollectionModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addCollectionModalLabel">Create Collection</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(route('collection.add')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" value="<?php echo e($id); ?>"> <!-- Hidden ID field -->
                            <div class="mb-3">
                                <label for="name" class="form-label">Collection Name:</label>
                                <input type="text" id="name" name="name" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label for="entity_type" class="form-label">Entity Type:</label>
                                <select id="entity_type" name="entity_type" class="form-control" required
                                    onchange="updateSecondDropdown()">
                                    <option value="">Select Entity Type</option>
                                    <option value="Person">Person</option>
                                    <option value="Publication">Publication</option>
                                    <option value="OrgUnit">OrgUnit</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="entity_action" class="form-label">Entity Action:</label>
                                <select id="entity_action" name="entity_action" class="form-control" required>
                                    <option value="">Select Entity Action</option>
                                </select>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Add</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
        
        <div class="modal fade" id="addSubCommunityModal" tabindex="-1" aria-labelledby="addSubCommunityModal"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addSubCommunityModalLabel">Create Sub Community</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(route('subcommunity.add')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" id="communityId" value="<?php echo e($id); ?>">
                            <!-- Hidden ID field -->
                            <div class="mb-3">
                                <label for="name" class="form-label">Sub Community Name:</label>
                                <input type="text" id="name" name="name" class="form-control" required>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Add</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <?php if($hasSubCommunity === 'yes'): ?>
        <section id="subCummunity">
            
            <div class="col-xl-3">
                <h4>Sub Community List</h4>
                <div class="card">
                    <div class="d-flex align-items-end row">
                        <div class="col-7">
                            <div class="card-body text-nowrap d-flex flex-column align-items-start">
                                <!-- File Icon with Space -->
                                <div class="d-flex align-items-center mb-2">
                                    <i class="fas fa-sitemap fa-2x text-primary me-3"></i>
                                    <!-- Number Text -->
                                    <h5 class="card-title mb-0"> <span id="subCommunityRecordsTotal"></span></h5>
                                </div>
                                <!-- Total Publication Text Below Icon -->
                                <p class="mb-2">Total SubCommunity</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <div class="card p-5 mt-3">
                        <!-- Table Wrapper -->
                        <div id="SubCommunityTable_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                            <div class="row dt-row">
                                <div class="col-sm-12">
                                    <table class="user-list table table-hover dataTable no-footer" id="SubCommunityTable"
                                        aria-describedby="SubCommunityTable_info" width="100%">
                                        <thead>
                                            <tr>
                                                
                                                <th class="sorting col-5" tabindex="0">NAME</th>
                                                <th class="sorting col-5" tabindex="0">ACTION</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Data will be dynamically inserted here -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Sub Community Edit Modal -->
            <div class="modal fade" id="editSubCommunityModal" tabindex="-1"
                aria-labelledby="editSubCommunityModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="editSubCommunityModalLabel">Edit Sub Community</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form id="editSubCommunityForm" method="POST" action="<?php echo e(route('subCommunity.edit')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" id="subCommunityId">
                                <div class="mb-3">
                                    <label for="subCommunityName" class="form-label">Sub Community Name</label>
                                    <input type="text" class="form-control" id="subCommunityName"
                                        name="subCommunityName" placeholder="Enter sub community name" value="">
                                    <!-- Error message will be displayed here -->
                                    <span id="subCommunityErrorMessage" style="color: red; display: block;"></span>
                                </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" form="editSubCommunityForm" class="btn btn-primary">Update</button>
                            </form>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Delete Confirmation Modal for sub community-->
            <div class="modal fade" id="deleteSubCommunityModal" tabindex="-1"
                aria-labelledby="deleteSubCommunityModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteSubCommunityModalLabel">Confirm Delete</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p id="deleteSubCommunityMessage">Are you sure you want to delete this sub-community?</p>
                        </div>
                        <div class="modal-footer">
                            <!-- Hidden form with delete button -->
                            
                            <form id="deleteSubCommunityForm" method="POST"
                                action="<?php echo e(route('subcommunity.delete', ['id' => '__ID__'])); ?>">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <input type="hidden" name="subCommunity_id" id="subCommunity_id">
                                <button type="submit" class="btn btn-danger"
                                    id="deleteSubCommunityButton">Delete</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section> <!--Sub Community Section End -->
    <?php endif; ?>
    

    
    <section id="collection" class="">
        <div class="col-xl-3 mt-3">
            <h4>Collection List</h4>
            <div class="card mt-3">
                <div class="d-flex align-items-end row">
                    <div class="col-7">
                        <div class="card-body text-nowrap d-flex flex-column align-items-start">
                            <!-- File Icon with Space -->
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-bars fa-2x text-primary me-3"></i>
                                <!-- Number Text -->
                                <h5 class="card-title mb-0"> <span id="recordsTotal"></span></h5>
                            </div>
                            <!-- Total Publication Text Below Icon -->
                            <p class="mb-2">Total Collection</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card p-5 mt-3">
                    <!-- Added margin-top for space -->
                    <div id="DataTables_Table_0_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                        <div class="row dt-row">
                            <div class="col-sm-12">
                                <table class="user-list table table-hover dataTable no-footer" id="DataTables_Table_0"
                                    aria-describedby="DataTables_Table_0_info" width="100%">
                                    <thead>
                                        <tr>
                                            
                                            
                                            
                                            
                                            <th class="sorting col-2" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">NAME</th>
                                            <th class="sorting col-3" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">ENTITY TYPE</th>
                                            <th class="sorting col-2" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">HANDL ID</th>
                                            
                                            <th class="sorting col-3" tabindex="0" aria-controls="DataTables_Table_0"
                                                rowspan="1" colspan="1">
                                                ACTION</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Dynamic rows generated by DataTables server-side processing -->
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p id="deleteMessage">Are you sure you want to delete this collection?</p>
                    </div>
                    <div class="modal-footer">
                        <!-- Hidden form with delete button -->
                        
                        <form id="deleteForm" method="POST"
                            action="<?php echo e(route('collection.delete', ['id' => '__ID__'])); ?>">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="hidden" name="collection_id" id="collection_id">
                            <button type="submit" class="btn btn-danger" id="deleteButton">Delete</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        
        <!-- Collection Edit Modal -->
        <div class="modal fade" id="editCollectionModal" tabindex="-1" aria-labelledby="editCollectionModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editCollectionModalLabel">Edit Collection</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form id="editCollectionForm" method="POST" action="<?php echo e(route('collection.edit')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="id" id="collectionId">
                            <div class="mb-3">
                                <label for="collectionName" class="form-label">Collection Name</label>
                                <input type="text" class="form-control" id="collectionName" name="collection_name"
                                    placeholder="Enter collection name" value="">
                                <!-- Error message will be displayed here -->
                                <span id="collectionErrorMessage" style="color: red; display: block;"></span>
                            </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" form="editCollectionForm" class="btn btn-primary">Update</button>
                        </form>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </section> <!--Collection Section End -->
    <!-- Empty State Message -->
    <div id="empty-state" class="text-center p-5 d-none">
        <div class="mb-4">
            <i class="fas fa-box-open text-muted" style="font-size: 5rem;"></i>
        </div>
        <h4 class="text-muted">No Data Available</h4>
        <p class="text-muted">There are no collections or sub-communities available.</p>
        
    </div>
    <script>
        $(document).ready(function() {
            let community_id = <?php echo json_encode($id); ?>;
            let metadataValues = <?php echo json_encode($collectionData, 15, 512) ?>;
            let count = <?php echo json_encode($count, 15, 512) ?>; // Number of collections
            var baseUrl = "<?php echo e(url('/')); ?>";

            $('#recordsTotal').text(count);

            let subCommunityData = <?php echo json_encode($subCommunityData, 15, 512) ?> ?? []; // Ensure it's always an array
            let subCommunityCount = subCommunityData.length; // Count the records safely
            $('#subCommunityRecordsTotal').text(subCommunityCount);

            let collectionContainer = $('#collection');
            let subCommunityContainer = $('#sub-community');
            let emptyState = $('#empty-state'); // ID of the "No Data Available" message

            // Function to check if both are empty
            function checkEmptyState() {
                if (count === 0 && subCommunityCount === 0) {
                    emptyState.removeClass("d-none"); // Show message
                    collectionContainer.hide();
                    subCommunityContainer.hide();
                } else {
                    emptyState.addClass("d-none"); // Hide message
                    if (count > 0) collectionContainer.show();
                    if (subCommunityCount > 0) subCommunityContainer.show();
                }
            }
 
            // Check on page load
            checkEmptyState();

            // Initialize Collection DataTable if there is data
            if (count > 0) {
                $('#DataTables_Table_0').DataTable({
                    data: metadataValues,
                    columns: [
                        // {
                        //     data: 'dspace_object_id',
                        //     name: 'id'
                        // },
                        {
                            data: 'collection_name',
                            name: 'collectionName',
                            render: function(data, type, row) {
                                let entityPath = row.entity_type ? row.entity_type.toLowerCase() :
                                    'unknown';
                                return `<a href="${baseUrl}/${entityPath}/${row.dspace_object_id}/${community_id}" class="text-primary">${data}</a>`;

                            }
                        },
                        {
                            data: 'entity_type',
                            name: 'entityType'
                        },
                        {
                            data: 'handle',
                            name: 'handle_id'
                        },
                        {
                            data: null,
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row) {
                                return `
                            <div class="d-flex">
                                <a href="#" class="btn btn-warning btn-sm me-2" onclick="editCollection('${row.dspace_object_id}','${row.collection_name}');">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="#" class="btn btn-danger btn-sm" onclick="confirmDelete('${row.dspace_object_id}','${row.collection_name}');">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </div>`;
                            }
                        }
                    ],
                    order: [
                        [0, 'desc']
                    ],
                    pageLength: 10,
                    scrollX: true
                });
            }

            // Initialize Sub-Community DataTable if there is data
            if (subCommunityCount > 0) {
                $('#SubCommunityTable').DataTable({
                    data: subCommunityData,
                    columns: [
                        // {
                        //     data: 'dspace_object_id',
                        //     name: 'id'
                        // },
                        {
                            data: 'text_value',
                            name: 'subCommunityName',
                            render: function(data, type, row) {

                                return `<a href="${baseUrl}/collection/${row.dspace_object_id}" class="text-primary">${data}</a>`;
                            }
                        },
                        {
                            data: null,
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row) {
                                return `
                            <div class="d-flex">
                                <a href="#" class="btn btn-warning btn-sm me-2" onclick="editSubCommunity('${row.dspace_object_id}', '${row.text_value}');">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="#" class="btn btn-danger btn-sm" onclick="confirmDeleteSubCommunity('${row.dspace_object_id}', '${row.text_value}');">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </div>`;
                            }
                        }
                    ],
                    order: [
                        [0, 'desc']
                    ],
                    pageLength: 10,
                    scrollX: true
                });
            }
        });


        // for updating model dropdown
        function updateSecondDropdown() {
            var entityType = document.getElementById("entity_type").value;
            var entityAction = document.getElementById("entity_action");

            // Clear previous options
            entityAction.innerHTML = '<option value="">Select Entity Action</option>';

            // Define options based on selected entity type
            var options = {
                "Person": ["person", "person-edit"],
                "Publication": ["publication", "publication-edit"],
                "OrgUnit": ["orgunit", "orgunit-edit"]
            };

            // Add new options dynamically
            if (entityType in options) {
                options[entityType].forEach(function(action) {
                    var option = document.createElement("option");
                    option.value = action;
                    option.textContent = action;
                    entityAction.appendChild(option);
                });
            }
        }

        // confirm delete for coleection
        function confirmDelete(collectionID, collectionName) {
            // Find the selected process based on `processId`
            const collectionId = collectionID;
            const name = collectionName;

            if (collectionId) {
                // Update the modal message with the selected process ID
                document.getElementById('deleteMessage').innerText =
                    `Are you sure you want to delete collection with Name: ${name}?`;
                // Show the modal
                const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
                deleteModal.show();

                // Set the form action and pass processId
                // document.getElementById('deleteButton').onclick = function() {
                //     document.getElementById('collection_id').value = collectionId;
                //     document.getElementById('deleteForm').action = `/collection/delete/${collectionId}`;
                //     document.getElementById('deleteForm').submit();
                // };

                const deleteForm = document.getElementById('deleteForm');
                const actionTemplate = deleteForm.getAttribute('action'); // contains __ID__
                const newAction = actionTemplate.replace('__ID__', collectionID);

                document.getElementById('deleteButton').onclick = function() {
                    document.getElementById('collection_id').value = collectionID;
                    deleteForm.setAttribute('action', newAction);
                    deleteForm.submit();
                };

            } else {
                alert('Process not found!');
            }
        }

        // Collection edit function
        function editCollection(collectionID, collectionName) {
            if (collectionID) {
                const editModalElement = document.getElementById('editCollectionModal');


                if (editModalElement) {
                    const editModal = new bootstrap.Modal(editModalElement);
                    editModal.show();
                    document.getElementById("collectionId").value = collectionID;
                    const inputField = document.getElementById("collectionName");
                    const errorMessageElement = document.getElementById("collectionErrorMessage");

                    if (errorMessageElement) {
                        errorMessageElement.innerHTML = "";
                    }

                    if (collectionName && collectionName.trim() !== "") {
                        inputField.value = collectionName;
                    } else {
                        inputField.value = "Unnamed Collection";
                    }

                    document.getElementById("editCollectionForm").onsubmit = function(event) {
                        if (inputField.value.trim() === "" || inputField.value.trim() === "Unnamed Collection") {
                            event.preventDefault();
                            if (errorMessageElement) {
                                errorMessageElement.innerHTML = "Collection name cannot be empty!";
                            }
                        }
                    };
                } else {
                    console.error("Modal element not found!");
                }
            } else {
                alert('Collection not found!');
            }
        }
        //Collection Script End

        // Community Script started
        // $(document).ready(function() {
        //     let subCommunityData = <?php echo json_encode($subCommunityData, 15, 512) ?>;
        //     let subCommunityCount = subCommunityData.length; // Count the records

        //     $('#subCommunityRecordsTotal').text(subCommunityCount); // Display count

        //     $('#SubCommunityTable').DataTable({
        //         data: subCommunityData, // Use the sub-community data
        //         columns: [{
        //                 data: 'dspace_object_id',
        //                 name: 'id'
        //             },
        //             {
        //                 data: 'text_value', // This contains the sub-community name
        //                 name: 'subCommunityName',
        //                 render: function(data, type, row) {
        //                     return `<a href="/community/${row.dspace_object_id}" class="text-primary">${data}</a>`;
        //                 }
        //             },
        //             {
        //                 data: null,
        //                 orderable: false,
        //                 searchable: false,
        //                 render: function(data, type, row) {
        //                     return `
    //                 <div class="d-flex justify-content-start">
    //                     <a href="#" class="btn btn-warning btn-sm me-2" onclick="editSubCommunity('${row.dspace_object_id}', '${row.text_value}');">
    //                         <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-edit font-medium-4">
    //                             <path d="M11 2H4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V6l-7-4z"></path>
    //                             <path d="M18 3l3 3-10 10-3-3L18 3z"></path>
    //                         </svg>
    //                     </a>
    //                     <a href="#" class="btn btn-danger btn-sm waves-effect waves-float waves-light" onclick="confirmDeleteSubCommunity('${row.dspace_object_id}', '${row.text_value}');">
    //                         <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash font-medium-4">
    //                             <polyline points="3 6 5 6 21 6"></polyline>
    //                             <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
    //                         </svg>
    //                     </a>
    //                 </div>`;
        //                 }
        //             } // Action buttons
        //         ],
        //         order: [
        //             [0, 'desc']
        //         ],
        //         pageLength: 10, // Default page length
        //         scrollX: true
        //     });
        // });

        // Community Update/Edit
        function editSubCommunity(subCommunityId, subCommunityName) {
            if (subCommunityId) {
                const editModalElement = document.getElementById('editSubCommunityModal');
                if (editModalElement) {
                    const editModal = new bootstrap.Modal(editModalElement);
                    editModal.show();

                    document.getElementById("subCommunityId").value = subCommunityId;
                    const inputField = document.getElementById("subCommunityName");
                    const errorMessageElement = document.getElementById("subCommunityErrorMessage");

                    if (errorMessageElement) {
                        errorMessageElement.innerHTML = "";
                    }

                    if (subCommunityName && subCommunityName.trim() !== "") {
                        inputField.value = subCommunityName;
                    } else {
                        inputField.value = "Unnamed Sub-Community";
                    }

                    document.getElementById("editSubCommunityForm").onsubmit = function(event) {
                        if (inputField.value.trim() === "" || inputField.value.trim() === "Unnamed Sub-Community") {
                            event.preventDefault();
                            if (errorMessageElement) {
                                errorMessageElement.innerHTML = "Sub-Community name cannot be empty!";
                            }
                        }
                    };
                } else {
                    console.error("Modal element not found!");
                }
            } else {
                alert('Sub-Community not found!');
            }
        }

        // sub community delete 
        // function confirmDeleteSubCommunity(subCommunityID, subCommunityName) {
        //     // Ensure values are assigned correctly
        //     const subCommunityId = subCommunityID;
        //     const name = subCommunityName;

        //     if (subCommunityId) {
        //         // Update the modal message with the selected sub-community name
        //         document.getElementById('deleteSubCommunityMessage').innerText =
        //             `Are you sure you want to delete the sub-community: ${name}?`;

        //         // Show the modal
        //         const deleteSubCommunityModal = new bootstrap.Modal(document.getElementById('deleteSubCommunityModal'));
        //         deleteSubCommunityModal.show();


        //         // Replace the action dynamically using the template
        //         const deleteForm = document.getElementById('deleteSubCommunityMessage');
        //         const actionTemplate = deleteForm.getAttribute('action'); // this will be like /community/delete/__ID__
        //         const newAction = actionTemplate.replace('__ID__', subCommunityId);

        //         document.getElementById('deleteSubCommunityButton').onclick = function() {
        //             document.getElementById('community_id').value = subCommunityId;
        //             deleteForm.setAttribute('action', newAction);
        //             deleteForm.submit();
        //         };

        //         // // Set the form action and pass sub-community ID
        //         // document.getElementById('deleteSubCommunityButton').onclick = function() {
        //         //     document.getElementById('subCommunity_id').value = subCommunityId;
        //         //     document.getElementById('deleteSubCommunityForm').action = `/subcommunity/delete/${subCommunityId}`;
        //         //     document.getElementById('deleteSubCommunityForm').submit();
        //         // };

        //     } else {
        //         alert('Sub-community not found!');
        //     }
        // }

        function confirmDeleteSubCommunity(subCommunityID, subCommunityName) {
            const subCommunityId = subCommunityID;
            const name = subCommunityName;

            if (subCommunityId) {
                // Set modal message
                document.getElementById('deleteSubCommunityMessage').innerText =
                    `Are you sure you want to delete the sub-community: ${name}?`;

                // Show modal
                const deleteSubCommunityModal = new bootstrap.Modal(document.getElementById('deleteSubCommunityModal'));
                deleteSubCommunityModal.show();

                // Get the form and action template
                const deleteForm = document.getElementById('deleteSubCommunityForm');
                const actionTemplate = deleteForm.getAttribute('action'); // e.g., /community/delete/__ID__
                const newAction = actionTemplate.replace('__ID__', subCommunityId);

                // On delete button click
                document.getElementById('deleteSubCommunityButton').onclick = function() {
                    document.getElementById('subCommunity_id').value = subCommunityId;
                    deleteForm.setAttribute('action', newAction);
                    deleteForm.submit();
                };
            } else {
                alert('Sub-community not found!');
            }
        }


        // Community Script End
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Admin\Documents\dspace_dash\resources\views/content/pages/collection.blade.php ENDPATH**/ ?>