<?php
    $configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Publication'); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss']); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js']); ?>
<?php $__env->stopSection(); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<?php $__env->startSection('content'); ?>
    <div class="content-header row mb-3">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('community.index')); ?>">Community</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('collection.index', ['id' => $communityid])); ?>">Collection</a>
                </li>
                <li class="breadcrumb-item active">
                    Publication Items
                </li>
            </ol>
        </nav>
        <div class="col-12 d-flex align-items-center justify-content-between">
            <!-- Header Title -->
            <h2 class="content-header-title mb-0">
                <?php echo e($name); ?>

            </h2>
            <form id="exportCsvForm" action="<?php echo e(route('export.metadata')); ?>" method="POST" target="downloadFrame">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="download_token" id="downloadToken">
                <input type="hidden" name="id" value="<?php echo e($id); ?>">
                <button type="submit" id="exportBtn" class="btn btn-primary rounded-pill d-flex align-items-center">
                    <i id="exportIcon" class="fa fa-file me-2"></i>
                    <span id="exportText">Export CSV</span>
                </button>
            </form>

            <iframe id="downloadFrame" name="downloadFrame" style="display:none;"></iframe>

        </div>

        <script>
            const checkStatusUrl = "<?php echo e(route('check.downloadStatus', ['token' => '__TOKEN__'])); ?>";
            document.getElementById('exportCsvForm').addEventListener('submit', function() {

                let btn = document.getElementById('exportBtn');
                let icon = document.getElementById('exportIcon');
                let text = document.getElementById('exportText');
                let iframe = document.getElementById('downloadFrame');
                let tokenField = document.getElementById('downloadToken');

                // Create unique token
                let token = Date.now() + '-' + Math.random().toString(36).substr(2, 9);
                tokenField.value = token;

                // Start loader
                btn.disabled = true;
                text.textContent = "Exporting...";
                icon.classList.remove('fa-file');
                icon.classList.add('fa-spinner', 'fa-spin');

                // Replace placeholder with actual token
                let url = checkStatusUrl.replace('__TOKEN__', token);

                // Poll server every 1 second
                let checkInterval = setInterval(() => {

                    fetch(url)
                        .then(res => res.json())
                        .then(data => {
                            if (data.ready) {
                                clearInterval(checkInterval);

                                // Stop loader
                                btn.disabled = false;
                                text.textContent = "Export CSV";
                                icon.classList.remove('fa-spinner', 'fa-spin');
                                icon.classList.add('fa-file');
                            }
                        });

                }, 1000);

            });
        </script>


    </div>
    <section id="publication-section" class="">
        <div class="col-xl-3">
            <h4>Publication List</h4>
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-7">
                        <div class="card-body text-nowrap d-flex flex-column align-items-start">
                            <!-- Icon and Count -->
                            <div class="d-flex align-items-center mb-2">
                                <i class="fas fa-file fa-2x text-primary me-3"></i>
                                <h5 class="card-title mb-0">
                                    <span id="recordsTotal"><?php echo e($totalCount); ?></span>
                                </h5>
                            </div>
                            <!-- Label -->
                            <p class="mb-2">Total Publications</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Publications List -->
        <div id="publications-container" class="mt-4">
            <div class="card mb-4">
                <div class="row mt-4 mb-2 px-4">
                    <!-- Search and Filter -->
                    <?php
                        $selectedPerPage = request('perPage', 10);
                        $searchQuery = request('search', '');
                    ?>
                    <div class="col-md-4 mt-3 mt-md-0 d-flex align-items-center gap-2">
                        <span>Show</span>
                        <select class="form-select form-select-sm w-auto" id="page-size">
                            <option value="10" <?php echo e($selectedPerPage == 10 ? 'selected' : ''); ?>>10</option>
                            <option value="25" <?php echo e($selectedPerPage == 25 ? 'selected' : ''); ?>>25</option>
                            <option value="50" <?php echo e($selectedPerPage == 50 ? 'selected' : ''); ?>>50</option>
                            <option value="100" <?php echo e($selectedPerPage == 100 ? 'selected' : ''); ?>>100</option>
                        </select>
                        <span>entries</span>
                    </div>

                    <?php
                        $fromYearSelected = request('from_year');
                        $toYearSelected = request('to_year');
                    ?>


                    <div class="col-md-4 mt-3 mt-md-0 d-flex align-items-center gap-2">
                        <label for="from-year">From:</label>
                        <select id="from-year" class="form-select form-select-sm w-auto"></select>

                        <label for="to-year">To:</label>
                        <select id="to-year" class="form-select form-select-sm w-auto"></select>
                    </div>

                    
                    <div class="col-md-4 justify-content-end">
                        <div class="input-group mt-3 mt-md-0">
                            <input type="text" id="search-input" class="form-control"
                                placeholder="Search publications..." value="<?php echo e($searchQuery); ?>">
                            <button class="btn btn-primary" type="button" id="search-button">
                                <i class="fas fa-search"></i> Search
                            </button>
                        </div>
                    </div>
                </div>

                <?php if(count($publications) > 0): ?>
                    <?php $__currentLoopData = $publications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $publication): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row px-4 pt-5">
                            <!-- Publication Details -->
                            <div class="col-md-10">
                                <?php if(!empty($publication['publication_type'])): ?>
                                    <span class="badge bg-primary text-white badge-sm">
                                        <?php echo e($publication['publication_type']); ?>

                                    </span>
                                <?php endif; ?>

                                <a href="https://doi.org/<?php echo e($publication['doi']); ?>" target="_blank"
                                    class="text-decoration-none">
                                    <h5 class="card-title mb-1"><?php echo e($publication['title'] ?? 'No Title'); ?>

                                    </h5>
                                </a>
                                <p class="text-muted mb-1"><?php echo e($publication['authors'] ?? 'Unknown Authors'); ?></p>
                                <p class="mb-1">
                                    <em>
                                        <?php echo e($publication['journal'] ?? ''); ?>

                                        <?php echo $publication['date_issued']
                                            ? '<b>Year: </b>' . \Carbon\Carbon::parse($publication['date_issued'])->format('Y')
                                            : ''; ?>

                                        <?php echo $publication['volume'] ? ', <b>Volume:</b> ' . $publication['volume'] : ''; ?>

                                    </em>
                                </p>
                                <?php if(!empty($publication['doi'])): ?>
                                    <a href="https://doi.org/<?php echo e($publication['doi']); ?>" target="_blank"
                                        class="text-decoration-none">
                                        <?php echo e($publication['doi']); ?>

                                    </a>
                                <?php endif; ?>

                            </div>

                            <!-- Action Buttons -->
                            <div class="col-md-2 d-flex flex-column align-items-start justify-content-start">
                                <!-- Button group at the top -->
                                <div class="mb-5">
                                    <button type="button" class="btn btn-info btn-sm me-2"
                                        onclick="viewPublication('<?php echo e($publication['uuid']); ?>')">
                                        <i class="fas fa-eye"></i>
                                    </button>

                                    <button type="button" class="btn btn-danger btn-sm"
                                        onclick="confirmDeletePublication('<?php echo e($publication['uuid']); ?>');">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>

                                <?php if(!empty($publication['doi']) && $publication['doi'] !== 'null' && $publication['doi'] !== 'undefined'): ?>
                                    <?php
                                        $metricId = 'metricBadgesContainer_' . $publication['uuid'];
                                    ?>

                                    <div class="d-flex align-items-center gap-3" id="<?php echo e($metricId); ?>">
                                        <!-- The badges will be injected here via JS -->
                                    </div>

                                    <script>
                                        document.addEventListener("DOMContentLoaded", function() {
                                            const doi = <?php echo json_encode($publication['doi'], 15, 512) ?>;
                                            const containerId = <?php echo json_encode($metricId, 15, 512) ?>;

                                            if (doi && doi !== 'null' && doi !== 'undefined') {
                                                let container = $('#' + containerId);

                                                let altmetric = $('<div class="altmetric-embed"></div>')
                                                    .attr('data-hide-less-than', '1')
                                                    .attr('data-badge-type', 'donut')
                                                    .attr('data-doi', doi.trim())
                                                    .css('display', 'inline-block');

                                                let dimensions = $('<div class="__dimensions_badge_embed__"></div>')
                                                    .attr('data-hide-zero-citations', 'true')
                                                    .attr('data-style', 'small_circle')
                                                    .attr('data-doi', doi.trim())
                                                    .css('display', 'inline-block');

                                                container.append(altmetric).append(dimensions);

                                                // Load Altmetric script
                                                $.getScript('https://d1bxh8uas1mnw7.cloudfront.net/assets/embed.js', function() {
                                                    if (typeof _altmetric_embed_init === 'function') {
                                                        _altmetric_embed_init();
                                                    }
                                                });

                                                // Load Dimensions script
                                                $.getScript('https://badge.dimensions.ai/badge.js', function() {
                                                    if (typeof __dimensions_embed === 'object' &&
                                                        typeof __dimensions_embed.addBadges === 'function') {
                                                        __dimensions_embed.addBadges();
                                                    }
                                                });
                                            }
                                        });
                                    </script>
                                <?php endif; ?>

                                <div class="row mt-3">
                                    <div class="mb-5 d-flex align-items-center">
                                        <?php if($publication['crossref_citation'] > 0): ?>
                                            <div class="d-flex align-items-center me-3">
                                                <img src="<?php echo e(asset('assets/img/logo/crossref.png')); ?>" alt="Crossref"
                                                    height="20" class="me-1">
                                                <span><?php echo e($publication['crossref_citation'] ?? 0); ?></span>
                                            </div>
                                        <?php endif; ?>

                                        <?php if($publication['scopus_citation'] > 0): ?>
                                            <div class="d-flex align-items-center">
                                                <img src="<?php echo e(asset('assets/img/logo/scopus.png')); ?>" alt="Scopus"
                                                    height="20" class="me-1">
                                                <span><?php echo e($publication['scopus_citation'] ?? 0); ?></span>
                                            </div>
                                        <?php endif; ?>

                                        <?php
                                            $unpaywall = $publication['unpaywall'] ?? 'closed';
                                            $upurl = $publication['upurl'] ?? null;
                                            $doi = $publication['doi'] ?? null;
                                            $icon = '<i class="fa fa-lock"></i>';
                                            $color = 'grey';

                                            if ($unpaywall === 'gold') {
                                                $color = '#FFC300';
                                            } elseif ($unpaywall === 'green') {
                                                $color = 'green';
                                            } elseif (in_array($unpaywall, ['hybrid', 'bronze'])) {
                                                $color = '#CD7F32';
                                            }

                                            // Safe HTML for DOI popover
                                            $doiUrl = 'https://doi.org/' . urlencode($doi);
                                            $doiLink = "<a href=\"{$doiUrl}\" target=\"_blank\" class=\"text-decoration-none\">{$doi}</a>";

                                        ?>

                                        <?php if($unpaywall !== 'closed' && !empty($upurl) && $upurl !== 'null' && $upurl !== 'undefined'): ?>
                                            <span class="ms-3 unpaywall-popover"
                                                style="color: <?php echo e($color); ?>; cursor: pointer;" tabindex="0"
                                                role="button" data-bs-toggle="popover" data-bs-trigger="focus hover"
                                                data-bs-html="true"
                                                data-bs-content="<a href='<?php echo e($upurl); ?>' target='_blank' style='color:black; text-decoration:underline;'><?php echo e($upurl); ?></a>">
                                                <?php echo $icon; ?>

                                            </span>
                                        <?php elseif(!empty($doi)): ?>
                                            <span class="ms-3 unpaywall-popover"
                                                style="color: <?php echo e($color); ?>; cursor: pointer;" tabindex="0"
                                                role="button" data-bs-toggle="popover" data-bs-trigger="focus hover"
                                                data-bs-html="true" data-bs-content="<?php echo e($doiLink); ?>">
                                                <?php echo $icon; ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>

                            </div>

                        </div>
                        <hr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="alert alert-info mx-4 my-4">No publications found.</div>
                <?php endif; ?>

                <!-- Combined pagination info and links -->
                <div class="pagination-container px-4">
                    <div class="d-flex justify-content-between align-items-center pb-3 flex-wrap">
                        <!-- Pagination Information -->
                        <div class="pagination-info">
                            <p class="mb-0">
                                Showing <?php echo e($publications->firstItem() ?? 0); ?> to <?php echo e($publications->lastItem() ?? 0); ?>

                                of
                                <?php echo e($publications->total()); ?> entries
                                <?php if(request('search') | request('from_year') || (request('to_year') && $totalCount > $publications->total())): ?>
                                    (filtered from <?php echo e($totalCount); ?> total entries)
                                <?php endif; ?>
                            </p>
                        </div>

                        <!-- Pagination Links -->
                        <div class="pagination-links">
                            <?php echo e($publications->links('vendor.pagination.bootstrap-4')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- View Publication Modal -->
        <div class="modal fade" id="viewPublicationModal" tabindex="-1" aria-labelledby="viewPublicationModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="viewPublicationModalLabel">Publication Details</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <!-- Publication details table -->
                        <table class="table table-borderless">
                            <thead>
                                <tr class="border-bottom">
                                    <th scope="col"><b>Fields</b></th>
                                    <th scope="col"><b>Details</b></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="border-bottom">
                                    <th>UUID</th>
                                    <td id="v_uuid"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Title</th>
                                    <td id="v_title"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Type</th>
                                    <td id="v_publication_type"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Abstract</th>
                                    <td id="v_abstract"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Authors</th>
                                    <td id="v_authors"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>SOPUS-AUTHOR-ID</th>
                                    <td id="v_scopus_author_id"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Journal</th>
                                    <td id="v_journal"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>DOI</th>
                                    <td id="v_doi"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>EID</th>
                                    <td id="v_eid"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Scopus Citation</th>
                                    <td id="v_scopus_citation"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>CrossRef Citation</th>
                                    <td id="v_crossref_citation"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Volume</th>
                                    <td id="v_volume"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>ISSN</th>
                                    <td id="v_issn"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>ISBN</th>
                                    <td id="v_isbn"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Date Issued</th>
                                    <td id="v_date_issued"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Sherpa URL</th>
                                    <td id="v_sherpa_url"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Unpaywall</th>
                                    <td id="v_unpaywall"></td>
                                </tr>
                                <tr class="border-bottom">
                                    <th>Metrics</th>
                                    <td id="v_metrics"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Delete Modal -->
        <div class="modal fade" id="deletePublicationModal" tabindex="-1" aria-labelledby="deletePublicationModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <p id="deletePublicationMessage">Are you sure you want to delete this publication?</p>
                    </div>
                    <div class="modal-footer">
                        <form id="deletePublicationForm" method="POST"
                            action="<?php echo e(route('publicationlist.delete', ['uuid' => '__UUID__'])); ?>">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="hidden" name="publication_id" id="publication_id">
                            <button type="submit" class="btn btn-danger">Delete</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Empty State Message -->
    <div id="empty-state" class="text-center p-5 d-none">
        <div class="mb-4">
            <i class="fas fa-box-open text-muted" style="font-size: 5rem;"></i>
        </div>
        <h4 class="text-muted">No Data Available</h4>
        <p class="text-muted">There are no PublicationsList available in the database.</p>
    </div>

    <script>
        $(document).ready(function() {
            initUnpaywallPopovers();

            // Handle page-size change (pagination)
            $('#page-size').change(function() {
                let pageSize = $(this).val();
                let currentParams = new URLSearchParams(window.location.search);

                currentParams.set('perPage', pageSize);
                currentParams.set('page', 1); // reset to first page

                window.location.href = '?' + currentParams.toString();
            });

            // Fetch data from Laravel
            let publicationsRaw = <?php echo json_encode($publications, 15, 512) ?> || [];
            window.publicationsData = <?php echo json_encode($publications->items(), 15, 512) ?>;
            let recordsCount = <?php echo e($totalCount); ?>;
            let section = $('#publication-section');
            let emptyState = $('#empty-state');

            function checkEmptyState() {
                if (recordsCount === 0) {
                    emptyState.removeClass("d-none"); // Show empty state
                    section.hide(); // Hide the whole section
                } else {
                    emptyState.addClass("d-none"); // Hide empty state
                    section.show(); // Show section if data exists
                }
            }

            // Check empty state on page load
            checkEmptyState();

            // Populate year dropdowns
            let minYear = <?php echo e($minYear ?? 0); ?>;
            let maxYear = <?php echo e($maxYear ?? 0); ?>;
            let selectedFrom = "<?php echo e($fromYearSelected); ?>";
            let selectedTo = "<?php echo e($toYearSelected); ?>";

            for (let year = minYear; year <= maxYear; year++) {
                $('#from-year').append(
                    `<option value="${year}" ${selectedFrom == year ? 'selected' : ''}>${year}</option>`
                );

                let isToSelected = selectedTo ?
                    (selectedTo == year) :
                    (year == maxYear); // Default select maxYear if selectedTo is empty

                $('#to-year').append(
                    `<option value="${year}" ${isToSelected ? 'selected' : ''}>${year}</option>`
                );
            }

            // Handle dependent year filtering
            $('#from-year').change(function() {
                let fromYear = parseInt($(this).val());
                let toYear = parseInt($('#to-year').val());

                if (!isNaN(fromYear) && !isNaN(toYear) && fromYear > toYear) {
                    alert("'From' year should not be greater than 'To' year!");
                    $(this).prop("selectedIndex", 0); // Reset to first option
                    return; // Stop further execution
                }

                performSearch();
            });

            $('#to-year').change(function() {
                let toYear = parseInt($(this).val());
                let fromYear = parseInt($('#from-year').val());

                if (!isNaN(fromYear) && !isNaN(toYear) && toYear < fromYear) {
                    alert("'To' year should not be less than 'From' year!");
                    $(this).prop("selectedIndex", 0); // Reset to first option
                    return; // Stop further execution
                }

                performSearch();
            });

            $('#search-button').click(function() {
                performSearch();
            });

            $('#search-input').keypress(function(e) {
                if (e.which == 13) { // Enter key
                    performSearch();
                }
            });

            // Filter functionality
            $('#type-filter').change(function() {
                performSearch();
            });

            // Function to perform search
            function performSearch() {
                let searchQuery = $('#search-input').val();
                let typeFilter = $('#type-filter').val();
                let fromYear = parseInt($('#from-year').val());
                let toYear = parseInt($('#to-year').val());
                let pageSize = $('#page-size').val();

                if (!isNaN(fromYear) && !isNaN(toYear) && fromYear > toYear) {
                    alert("To Year must be greater than or equal to From Year");
                    return;
                }

                let params = new URLSearchParams();

                if (searchQuery) params.append('search', searchQuery);
                if (typeFilter && typeFilter !== 'all') params.append('type', typeFilter);
                if (fromYear) params.append('from_year', fromYear);
                if (toYear) params.append('to_year', toYear);
                if (pageSize) params.append('perPage', pageSize);

                params.set('page', 1);

                window.location.href = '?' + params.toString();
            }

            // Initialize popovers when page loads
            $(document).on('mouseenter', '.unpaywall-popover', function() {
                $(this).popover('show');
            });

            $(document).on('mouseleave', '.popover', function() {
                $(this).popover('hide');
            });

            // Hide all popovers on scroll to prevent sticky popovers
            $(window).on('scroll', function() {
                $('[data-bs-toggle="popover"]').popover('hide');
            });
        });

        // Initialize popovers properly
        function initUnpaywallPopovers() {
            $('[data-bs-toggle="popover"]').popover('dispose').popover({
                container: 'body',
                trigger: 'hover focus',
                html: true,
                delay: {
                    show: 150,
                    hide: 300
                },
                placement: 'auto'
            });
        }

        function viewPublication(uuid) {
            // Find the publication with the matching UUID
            if (!window.publicationsData || !Array.isArray(window.publicationsData)) {
                console.error('publicationsData is not available or not an array.');
                return;
            }

            var publication = window.publicationsData.find(function(p) {
                return p.uuid === uuid;
            });
            if (publication) {

                // console.log(publication);

                function setField(id, value, isLink = false, prefix = '') {

                    if (value && value !== 'null' && value !== 'undefined') {
                        if (isLink) {
                            $(id).html(`<a href="${prefix}${value}" target="_blank">${value}</a>`).parent().show();
                        } else {
                            $(id).text(value).parent().show();
                        }
                    } else {
                        $(id).parent().hide();
                    }
                }

                // abstract value
                function setAbstractField(id, value) {
                    if (value && value.trim() !== '' && value !== 'null' && value !== 'undefined') {
                        if (value.length > 150) {
                            let shortText = value.substring(0, 150) + "...";
                            let fullText = value;
                            let abstractHtml = `
                                    <span class="short-abstract">${shortText}</span>
                                    <span class="full-abstract" style="display: none;">${fullText}</span>
                                    <a href="#" class="read-more">Read More</a>`;
                            $(id).html(abstractHtml).parent().show();

                            // Toggle Read More / Read Less
                            $(id).find('.read-more').click(function(e) {
                                e.preventDefault();
                                let parent = $(this).parent();
                                parent.find('.short-abstract').toggle();
                                parent.find('.full-abstract').toggle();
                                $(this).text($(this).text() === "Read More" ? "Read Less" : "Read More");
                            });
                        } else {
                            $(id).text(value).parent().show();
                        }
                    } else {
                        $(id).parent().hide();
                    }
                }

                setField('#v_uuid', publication.uuid);
                setField('#v_publication_type', publication.publication_type);
                setField('#v_title', publication.title);
                setField('#v_authors', publication.authors);
                setAbstractField('#v_abstract', publication.abstract);
                setField('#v_scopus_author_id', publication.scopus_ids);
                setField('#v_journal', publication.journal);
                setField('#v_doi', publication.doi, true, 'https://doi.org/');
                setField('#v_scopus_citation', publication.scopus_citation);
                setField('#v_crossref_citation', publication.crossref_citation);
                setField('#v_eid', publication.eid, true, 'https://www.scopus.com/record/display.uri?eid=');
                setField('#v_volume', publication.volume);
                setField('#v_issn', publication.issn);
                setField('#v_isbn', publication.isbn);
                setField('#v_date_issued', publication.date_issued);
                setField('#v_sherpa_url', publication.sherpa_url, true);

                if (publication.doi && publication.doi !== 'null' && publication.doi !== 'undefined') {
                    let container = $('<div class="parent"></div>');

                    let altmetric = $('<div class="altmetric-embed"></div>')
                        .attr('data-hide-less-than', '1')
                        .attr('data-badge-type', 'donut')
                        .attr('data-doi', publication.doi.trim())
                        .css('display', 'inline-block');

                    let dimensions = $('<div class="__dimensions_badge_embed__"></div>')
                        .attr('data-hide-zero-citations', 'true')
                        .attr('data-style', 'small_circle')
                        .attr('data-doi', publication.doi.trim())
                        .css('display', 'inline-block');

                    container.append(altmetric).append(dimensions);
                    $('#v_metrics').html(container).closest('tr').show();

                    // ✅ FIX: Reload Altmetric script dynamically every time
                    $.getScript('https://d1bxh8uas1mnw7.cloudfront.net/assets/embed.js', function() {
                        if (typeof _altmetric_embed_init === 'function') {
                            _altmetric_embed_init();
                        }
                    });

                    // ✅ FIX: Reload Dimensions script dynamically every time
                    $.getScript('https://badge.dimensions.ai/badge.js', function() {
                        if (typeof __dimensions_embed === 'object' && typeof __dimensions_embed.addBadges ===
                            'function') {
                            __dimensions_embed.addBadges();
                        }
                    });

                } else {
                    $('#v_metrics').closest('tr').hide();
                }

                // Unpaywall logic
                let icon = '<i class="fa fa-lock"></i>';
                let color = 'grey'; // Default color
                let upurl = publication.upurl;

                if (publication.unpaywall) {
                    if (publication.unpaywall === 'gold') {
                        color = '#FFC300'; // Gold
                    } else if (publication.unpaywall === 'green') {
                        color = 'green';
                    } else if (publication.unpaywall === 'hybrid' || publication.unpaywall === 'bronze') {
                        color = '#CD7F32'; // Bronze
                    } else if (publication.unpaywall === 'closed') {
                        color = 'grey';
                    }
                }

                let unpaywallHtml = `<span style="color: ${color}; display: flex; align-items: center;">${icon}</span>`;

                if (publication.unpaywall !== 'closed' && upurl && upurl !== 'null' && upurl !== 'undefined') {
                    unpaywallHtml += `<br><a href="${upurl}" target="_blank">${upurl}</a>`;
                }

                if (publication.unpaywall || upurl) {
                    $('#v_unpaywall').html(unpaywallHtml).parent().show();
                } else {
                    $('#v_unpaywall').parent().hide();
                }

                // Show the modal
                var myModal = new bootstrap.Modal(document.getElementById('viewPublicationModal'));
                myModal.show();
            }
        }

        // Funcation for delete puvlication
        function confirmDeletePublication(uuid, title) {
            // Find the publication by uuid from your global publicationsData
            var publication = window.publicationsData.find(function(p) {
                return p.uuid === uuid;
            });

            if (publication) {
                if (publication) {
                    // Update the confirmation message
                    $('#deletePublicationMessage').html(
                        "Are you sure you want to delete <b>" + (publication.title || "this publication") + "</b>?"
                    );

                    // Set the hidden input value
                    $('#publication_id').val(uuid);

                    // Replace the UUID placeholder in the action URL
                    var form = $('#deletePublicationForm');
                    var actionTemplate = form.attr('action'); // should contain __UUID__
                    var updatedAction = actionTemplate.replace('__UUID__', uuid);
                    form.attr('action', updatedAction);

                    // Show the modal
                    var deleteModal = new bootstrap.Modal(document.getElementById('deletePublicationModal'));
                    deleteModal.show();
                }
            }
        }
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Admin\Documents\dspace_dash\resources\views/content/pages/publication.blade.php ENDPATH**/ ?>